/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.tree;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import lotr.common.block.AxialSlabBlock;
import lotr.common.block.LOTRBlockStates;
import lotr.common.world.gen.feature.LOTRFeatures;
import lotr.common.world.gen.tree.LOTRTreeDecorators;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.treedecorator.TreeDecorator;

public class PineBranchDecorator
extends TreeDecorator {
    private final BlockStateProvider logProvider;
    private final float prob;

    public PineBranchDecorator(BlockStateProvider log, float f) {
        super(LOTRTreeDecorators.PINE_BRANCH);
        this.logProvider = log;
        this.prob = f;
    }

    public PineBranchDecorator(BlockState log, float f) {
        this((BlockStateProvider)new SimpleBlockStateProvider(log), f);
    }

    public <T> PineBranchDecorator(Dynamic<T> dyn) {
        this(LOTRFeatures.deserializeBlockProvider(dyn, "provider"), dyn.get("probability").asFloat(0.0f));
    }

    public void func_225576_a_(IWorld world, Random rand, List<BlockPos> trunk, List<BlockPos> leaves, Set<BlockPos> decoSet, MutableBoundingBox bb) {
        int baseY = trunk.get(0).func_177956_o();
        int trunkHeight = trunk.size();
        Direction[] lastDir = new Direction[1];
        trunk.stream().filter(pos -> {
            int diff = pos.func_177956_o() - baseY;
            return diff >= 3 && diff < trunkHeight - 3;
        }).forEach(pos -> {
            Direction dir;
            if (rand.nextFloat() < this.prob && (dir = Direction.Plane.HORIZONTAL.func_179518_a(rand)) != lastDir[0]) {
                lastDir[0] = dir;
                BlockPos branchPos = pos.func_177982_a(dir.func_82601_c(), 0, dir.func_82599_e());
                if (AbstractTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)branchPos)) {
                    BlockState blockstate = this.logProvider.func_225574_a_(rand, branchPos);
                    if (blockstate.func_177230_c() instanceof RotatedPillarBlock) {
                        blockstate = (BlockState)blockstate.func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)dir.func_176740_k());
                    } else if (blockstate.func_177230_c() instanceof AxialSlabBlock && blockstate.func_196959_b(LOTRBlockStates.SLAB_AXIS)) {
                        blockstate = (BlockState)((BlockState)blockstate.func_206870_a(LOTRBlockStates.SLAB_AXIS, (Comparable)dir.func_176740_k())).func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)(dir.func_176743_c() == Direction.AxisDirection.NEGATIVE ? SlabType.TOP : SlabType.BOTTOM));
                    }
                    this.func_227423_a_((IWorldWriter)world, branchPos, blockstate, decoSet, bb);
                }
            }
        });
    }

    public <T> T func_218175_a(DynamicOps<T> ops) {
        return (T)new Dynamic(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString("type"), (Object)ops.createString(Registry.field_229390_w_.func_177774_c((Object)this.field_227422_a_).toString()), (Object)ops.createString("provider"), (Object)this.logProvider.func_218175_a(ops), (Object)ops.createString("probability"), (Object)ops.createFloat(this.prob)))).getValue();
    }
}

