/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.tree;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import lotr.common.block.StrippedWoodHelper;
import lotr.common.world.gen.tree.LOTRTreeDecorators;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LogBlock;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.treedecorator.TreeDecorator;

public class PineStripDecorator
extends TreeDecorator {
    private final float prob;
    private final float stripBeginHeightFraction;
    private final float stripCompleteHeightFraction;

    public PineStripDecorator(float f, float s0, float s1) {
        super(LOTRTreeDecorators.PINE_BRANCH);
        this.prob = f;
        this.stripBeginHeightFraction = s0;
        this.stripCompleteHeightFraction = s1;
    }

    public <T> PineStripDecorator(Dynamic<T> dyn) {
        this(dyn.get("probability").asFloat(0.0f), dyn.get("strip_begin_height_fraction").asFloat(0.0f), dyn.get("strip_complete_height_fraction").asFloat(1.0f));
    }

    public void func_225576_a_(IWorld world, Random rand, List<BlockPos> trunk, List<BlockPos> leaves, Set<BlockPos> decoSet, MutableBoundingBox bb) {
        if (rand.nextFloat() < this.prob) {
            int trunkBase = trunk.get(0).func_177956_o();
            int trunkHeight = trunk.size();
            int stripBeginY = Math.round((float)trunkHeight * this.stripBeginHeightFraction);
            int stripCompleteY = Math.round((float)trunkHeight * this.stripCompleteHeightFraction);
            Function<Integer, Boolean> stripTest = y -> {
                int yRel = y - trunkBase;
                if (yRel < stripBeginY) {
                    return false;
                }
                if (yRel >= stripCompleteY) {
                    return true;
                }
                return rand.nextFloat() < (float)(yRel - stripBeginY + 1) / (float)(stripCompleteY - stripBeginY + 1);
            };
            this.stripWood(world, trunk, stripTest, bb);
            this.stripWood(world, decoSet, stripTest, bb);
        }
    }

    private void stripWood(IWorld world, Collection<BlockPos> posCollection, Function<Integer, Boolean> stripTest, MutableBoundingBox bb) {
        HashSet temp = new HashSet();
        for (BlockPos pos : posCollection) {
            int y = pos.func_177956_o();
            if (!stripTest.apply(y).booleanValue()) continue;
            BlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            Block stripped = StrippedWoodHelper.getStrippingMap().get(block);
            if (stripped == null) continue;
            EnumProperty axis = LogBlock.field_176298_M;
            BlockState newState = (BlockState)stripped.func_176223_P().func_206870_a((IProperty)axis, state.func_177229_b((IProperty)axis));
            this.func_227423_a_((IWorldWriter)world, pos, newState, temp, bb);
        }
    }

    public <T> T func_218175_a(DynamicOps<T> ops) {
        return (T)new Dynamic(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString("type"), (Object)ops.createString(Registry.field_229390_w_.func_177774_c((Object)this.field_227422_a_).toString()), (Object)ops.createString("probability"), (Object)ops.createFloat(this.prob), (Object)ops.createString("strip_begin_height_fraction"), (Object)ops.createFloat(this.stripBeginHeightFraction), (Object)ops.createString("strip_complete_height_fraction"), (Object)ops.createFloat(this.stripCompleteHeightFraction)))).getValue();
    }
}

