/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.map;

import com.google.common.math.IntMath;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import lotr.common.LOTRLog;
import lotr.common.LOTRMod;
import lotr.common.init.LOTRBiomes;
import lotr.common.world.map.MapLabel;
import lotr.common.world.map.MapSettingsManager;
import lotr.common.world.map.MapWaypoint;
import lotr.common.world.map.NorthernLightsSettings;
import lotr.common.world.map.Road;
import lotr.common.world.map.RoadPointCache;
import lotr.common.world.map.WaterLatitudeSettings;
import net.minecraft.network.PacketBuffer;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.LogicalSide;

public class MapSettings {
    public static final ResourceLocation MAP_SETTINGS_PATH = new ResourceLocation("lotr", "map/map.json");
    public static final ResourceLocation DEFAULT_MAP_IMAGE_PATH = new ResourceLocation("lotr", "map/middle_earth.png");
    public static final ResourceLocation MENU_WAYPOINT_ROUTE_PATH = new ResourceLocation("lotr", "map/menu_waypoint_route.json");
    private final MapSettingsManager manager;
    private final ResourceLocation mapImagePath;
    private int imageWidth;
    private int imageHeight;
    private byte[] cachedImageBytes;
    private int[] imageBiomeIds;
    private int fallbackBiomeId;
    private final int originX;
    private final int originZ;
    private final int scalePower;
    private final int scaleFactor;
    private final String title;
    private final boolean translateTitle;
    private final Set<Direction> lockSides;
    private final boolean proceduralRivers;
    private WaterLatitudeSettings waterLatitude;
    private NorthernLightsSettings northernLights;
    private List<MapWaypoint> waypoints;
    private Map<Integer, MapWaypoint> waypointsById;
    private Map<ResourceLocation, MapWaypoint> waypointsByName;
    private List<MapWaypoint> menuWaypointRoute;
    private List<Road> roads;
    private final RoadPointCache roadPointCache = new RoadPointCache();
    private List<MapLabel> labels;

    public MapSettings(MapSettingsManager mgr, ResourceLocation map, int origX, int origZ, int scale, String ttl, boolean translate, Set<Direction> locks, boolean rivers) {
        this.manager = mgr;
        this.mapImagePath = map;
        this.originX = origX;
        this.originZ = origZ;
        this.scalePower = scale;
        this.scaleFactor = IntMath.pow((int)2, (int)this.scalePower);
        this.title = ttl;
        this.translateTitle = translate;
        this.lockSides = locks;
        this.proceduralRivers = rivers;
    }

    public static MapSettings read(MapSettingsManager manager, JsonObject json) {
        String imagePath = json.get("image").getAsString();
        int originX = json.get("origin_x").getAsInt();
        int originZ = json.get("origin_z").getAsInt();
        int scale = json.get("scale_power").getAsInt();
        int minScale = 2;
        int maxScale = 10;
        int clampedScale = MathHelper.func_76125_a((int)scale, (int)2, (int)10);
        if (clampedScale != scale) {
            scale = clampedScale;
            LOTRLog.warn("Map scale power must be between %d and %d - clamping value provided in map.json to %d", 2, 10, scale);
        }
        String title = json.get("title").getAsString();
        boolean translateTitle = json.get("translate_title").getAsBoolean();
        HashSet<Direction> lockSides = new HashSet<Direction>();
        json.get("lock_sides").getAsJsonArray().forEach(jsonElem -> {
            String dirName = jsonElem.getAsString();
            Direction dir = Direction.func_176739_a((String)dirName);
            if (dir != null && dir.func_176740_k().func_176722_c()) {
                lockSides.add(dir);
            } else {
                LOTRLog.warn("Invalid direction '%s' for map locked sides", dirName);
            }
        });
        boolean proceduralRivers = true;
        if (json.has("procedural_rivers")) {
            proceduralRivers = json.get("procedural_rivers").getAsBoolean();
        }
        return new MapSettings(manager, new ResourceLocation(imagePath), originX, originZ, scale, title, translateTitle, lockSides, proceduralRivers);
    }

    public void readMenuWaypointRoute(JsonObject json) {
        if (this.waypoints == null) {
            LOTRLog.error("Cannot load menu waypoint route - waypoints aren't loaded yet!");
        }
        JsonArray wpList = json.get("waypoint_route").getAsJsonArray();
        this.menuWaypointRoute = new ArrayList<MapWaypoint>();
        for (JsonElement elem : wpList) {
            try {
                String wpName = elem.getAsString();
                ResourceLocation wpRes = new ResourceLocation(wpName);
                MapWaypoint waypoint = this.waypointsByName.get(wpRes);
                if (waypoint != null) {
                    this.menuWaypointRoute.add(waypoint);
                    continue;
                }
                LOTRLog.warn("Tried to add a map waypoint to the menu route that doesn't exist for this map - name %s. Check the route list", wpRes);
            }
            catch (Exception e) {
                LOTRLog.warn("Invalid array element '%s' in menu waypoint route json. Must be a list of waypoints by their resource location names. See the mod's default file for an example", elem.toString());
                e.printStackTrace();
            }
        }
    }

    public static MapSettings read(MapSettingsManager manager, PacketBuffer buf) {
        String imagePath = buf.func_218666_n();
        int originX = buf.readInt();
        int originZ = buf.readInt();
        byte scale = buf.readByte();
        String title = buf.func_218666_n();
        boolean translateTitle = buf.readBoolean();
        HashSet<Direction> lockSides = new HashSet<Direction>();
        int numLockSides = buf.readByte();
        for (int i = 0; i < numLockSides; ++i) {
            byte dirIndex = buf.readByte();
            Direction dir = Direction.func_82600_a((int)dirIndex);
            if (dir != null && dir.func_176740_k().func_176722_c()) {
                lockSides.add(dir);
                continue;
            }
            LOTRLog.warn("Invalid direction index %d for map locked sides", dirIndex);
        }
        boolean proceduralRivers = buf.readBoolean();
        MapSettings mapSettings = new MapSettings(manager, new ResourceLocation(imagePath), originX, originZ, scale, title, translateTitle, lockSides, proceduralRivers);
        if (!mapSettings.isDefaultImage()) {
            byte[] imgBytes = buf.func_179251_a();
            mapSettings.setImageBytes(imgBytes);
        }
        mapSettings.setWaterLatitudes(WaterLatitudeSettings.read(mapSettings, buf));
        mapSettings.setNorthernLights(NorthernLightsSettings.read(mapSettings, buf));
        ArrayList<MapWaypoint> waypoints = new ArrayList<MapWaypoint>();
        int numWaypoints = buf.readInt();
        for (int i = 0; i < numWaypoints; ++i) {
            try {
                MapWaypoint waypoint = MapWaypoint.read(mapSettings, buf);
                waypoints.add(waypoint);
                continue;
            }
            catch (Exception e) {
                LOTRLog.warn("Error loading a map waypoint from server");
                e.printStackTrace();
            }
        }
        mapSettings.setWaypoints(waypoints);
        ArrayList<MapWaypoint> menuWaypointRoute = new ArrayList<MapWaypoint>();
        int numMenuWaypoints = buf.readInt();
        for (int i = 0; i < numMenuWaypoints; ++i) {
            int assignedId = buf.func_150792_a();
            MapWaypoint waypoint = mapSettings.waypointsById.get(assignedId);
            if (waypoint != null) {
                menuWaypointRoute.add(waypoint);
                continue;
            }
            LOTRLog.error("Tried to add a map waypoint to the menu route that doesn't exist - assigned ID %d. Something has broken!", assignedId);
        }
        mapSettings.menuWaypointRoute = menuWaypointRoute;
        ArrayList<Road> roads = new ArrayList<Road>();
        int numRoads = buf.readInt();
        for (int i = 0; i < numRoads; ++i) {
            try {
                Road road = Road.read(mapSettings, buf);
                roads.add(road);
                continue;
            }
            catch (Exception e) {
                LOTRLog.warn("Error loading a map road from server");
                e.printStackTrace();
            }
        }
        mapSettings.setRoadsAndGenerateCurvesOnThread(roads);
        ArrayList<MapLabel> labels = new ArrayList<MapLabel>();
        int numLabels = buf.readInt();
        for (int i = 0; i < numLabels; ++i) {
            try {
                MapLabel label = MapLabel.read(mapSettings, buf);
                labels.add(label);
                continue;
            }
            catch (Exception e) {
                LOTRLog.warn("Error loading a map label from server");
                e.printStackTrace();
            }
        }
        mapSettings.setLabels(labels);
        return mapSettings;
    }

    public void write(PacketBuffer buf) {
        buf.func_180714_a(this.mapImagePath.toString());
        buf.writeInt(this.originX);
        buf.writeInt(this.originZ);
        buf.writeByte(this.scalePower);
        buf.func_180714_a(this.title);
        buf.writeBoolean(this.translateTitle);
        buf.writeByte(this.lockSides.size());
        this.lockSides.forEach(dir -> buf.writeByte(dir.func_176745_a()));
        buf.writeBoolean(this.proceduralRivers);
        if (!this.isDefaultImage()) {
            buf.func_179250_a(this.cachedImageBytes);
        }
        this.waterLatitude.write(buf);
        this.northernLights.write(buf);
        buf.writeInt(this.waypoints.size());
        this.waypoints.forEach(waypoint -> waypoint.write(buf));
        buf.writeInt(this.menuWaypointRoute.size());
        this.menuWaypointRoute.forEach(waypoint -> buf.func_150787_b(waypoint.getAssignedId()));
        buf.writeInt(this.roads.size());
        this.roads.forEach(road -> road.write(buf));
        buf.writeInt(this.labels.size());
        this.labels.forEach(label -> label.write(buf));
    }

    public LogicalSide getSide() {
        return this.manager.getSide();
    }

    public boolean isDefaultImage() {
        return this.mapImagePath.equals((Object)DEFAULT_MAP_IMAGE_PATH);
    }

    public boolean loadedImage() {
        return this.cachedImageBytes != null && this.imageBiomeIds != null;
    }

    public void loadImage(IResourceManager resMgr) {
        if (!this.loadedImage()) {
            try {
                BufferedImage biomeImage;
                if (this.cachedImageBytes == null) {
                    InputStream is = this.isDefaultImage() ? LOTRMod.getModResourceStream(ResourcePackType.SERVER_DATA, this.mapImagePath) : resMgr.func_199002_a(this.mapImagePath).func_199027_b();
                    this.cachedImageBytes = MapSettings.readInputStreamBytesFully(is);
                }
                if ((biomeImage = ImageIO.read(this.createCachedImageInputStream())) == null) {
                    throw new RuntimeException("Fatal error: Could not load LOTR biome map image " + this.mapImagePath);
                }
                this.imageWidth = biomeImage.getWidth();
                this.imageHeight = biomeImage.getHeight();
                int[] mapRGB = biomeImage.getRGB(0, 0, this.imageWidth, this.imageHeight, null, 0, this.imageWidth);
                this.imageBiomeIds = new int[this.imageWidth * this.imageHeight];
                this.fallbackBiomeId = LOTRBiomes.getBiomeID(LOTRBiomes.SEA);
                HashMap<Integer, Integer> cachedBiomeIDs = new HashMap<Integer, Integer>();
                HashSet<Integer> unknownColors = new HashSet<Integer>();
                for (int i = 0; i < mapRGB.length; ++i) {
                    int color = mapRGB[i] & 0xFFFFFF;
                    Integer biomeId = (Integer)cachedBiomeIDs.get(color);
                    if (biomeId == null) {
                        Biome biome = LOTRBiomes.MAP_BIOME_COLORS.get(color);
                        if (biome != null) {
                            biomeId = LOTRBiomes.getBiomeID(biome);
                        } else {
                            biomeId = this.fallbackBiomeId;
                            if (!unknownColors.contains(color)) {
                                unknownColors.add(color);
                                LOTRLog.error("Found unknown biome color on map: " + String.format("%1$06X", color) + ", substituting sea");
                            }
                        }
                        cachedBiomeIDs.put(color, biomeId);
                    }
                    this.imageBiomeIds[i] = biomeId;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static byte[] readInputStreamBytesFully(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        return buffer.toByteArray();
    }

    public void setImageBytes(byte[] bytes) {
        if (this.cachedImageBytes != null) {
            throw new IllegalArgumentException("Map's cachedImageBytes are already set, cannot replace them!");
        }
        this.cachedImageBytes = bytes;
    }

    public void copyImageBytesFrom(MapSettings other) {
        this.setImageBytes(other.cachedImageBytes);
    }

    public InputStream createCachedImageInputStream() {
        return new ByteArrayInputStream(this.cachedImageBytes);
    }

    public int getBiomeIdAt(int mapX, int mapZ) {
        if (mapX < 0 || mapX >= this.imageWidth || mapZ < 0 || mapZ >= this.imageHeight) {
            return this.fallbackBiomeId;
        }
        int index = mapZ * this.imageWidth + mapX;
        return this.imageBiomeIds[index];
    }

    public ResourceLocation getMapImagePath() {
        return this.mapImagePath;
    }

    public int getWidth() {
        return this.imageWidth;
    }

    public int getHeight() {
        return this.imageHeight;
    }

    public int getOriginX() {
        return this.originX;
    }

    public int getOriginZ() {
        return this.originZ;
    }

    public int getScalePower() {
        return this.scalePower;
    }

    public int getScaleFactor() {
        return this.scaleFactor;
    }

    public String getTitle(BiFunction<String, Object[], String> formatter) {
        if (this.translateTitle) {
            return formatter.apply(this.title, new Object[0]);
        }
        return this.title;
    }

    public boolean isScreenSideLocked(Direction dir) {
        return this.lockSides.contains(dir);
    }

    public boolean getProceduralRivers() {
        return this.proceduralRivers;
    }

    public int mapToWorldX(double x) {
        return (int)Math.round(this.mapToWorldX_frac(x));
    }

    public int mapToWorldZ(double z) {
        return (int)Math.round(this.mapToWorldZ_frac(z));
    }

    public double mapToWorldX_frac(double x) {
        return (x - (double)this.originX) * (double)this.scaleFactor;
    }

    public double mapToWorldZ_frac(double z) {
        return (z - (double)this.originZ) * (double)this.scaleFactor;
    }

    public int mapToWorldDistance(double dist) {
        return (int)Math.round(dist * (double)this.scaleFactor);
    }

    public int worldToMapX(double x) {
        return (int)Math.round(this.worldToMapX_frac(x));
    }

    public int worldToMapZ(double z) {
        return (int)Math.round(this.worldToMapZ_frac(z));
    }

    public double worldToMapX_frac(double x) {
        return x / (double)this.scaleFactor + (double)this.originX;
    }

    public double worldToMapZ_frac(double z) {
        return z / (double)this.scaleFactor + (double)this.originZ;
    }

    public int worldToMapDistance(double dist) {
        return (int)Math.round(dist / (double)this.scaleFactor);
    }

    public WaterLatitudeSettings getWaterLatitudes() {
        return this.waterLatitude;
    }

    public void setWaterLatitudes(WaterLatitudeSettings water) {
        if (this.waterLatitude != null) {
            throw new IllegalArgumentException("Cannot set map's water latitudes - already set!");
        }
        this.waterLatitude = water;
    }

    public NorthernLightsSettings getNorthernLights() {
        return this.northernLights;
    }

    public void setNorthernLights(NorthernLightsSettings nls) {
        if (this.northernLights != null) {
            throw new IllegalArgumentException("Cannot set map's northern lights - already set!");
        }
        this.northernLights = nls;
    }

    public List<MapWaypoint> getWaypoints() {
        return this.waypoints;
    }

    public void setWaypoints(List<MapWaypoint> wps) {
        if (this.waypoints != null) {
            throw new IllegalArgumentException("Cannot set map's waypoints - already set!");
        }
        this.waypoints = wps;
        this.waypointsById = this.waypoints.stream().collect(Collectors.toMap(MapWaypoint::getAssignedId, UnaryOperator.identity()));
        this.waypointsByName = this.waypoints.stream().collect(Collectors.toMap(MapWaypoint::getName, UnaryOperator.identity()));
    }

    public MapWaypoint getWaypointByID(int id) {
        return this.waypointsById.get(id);
    }

    public MapWaypoint getWaypointByName(ResourceLocation name) {
        return this.waypointsByName.get(name);
    }

    public List<MapWaypoint> getMenuWaypointRoute() {
        return this.menuWaypointRoute;
    }

    public List<Road> getRoads() {
        return this.roads;
    }

    private void setRoads(List<Road> inputRoads) {
        if (this.roads != null) {
            throw new IllegalArgumentException("Cannot set map's roads - already set!");
        }
        this.roads = inputRoads;
    }

    public void setRoadsAndGenerateCurvesInstantly(List<Road> inputRoads) {
        this.setRoads(inputRoads);
        for (Road road : this.roads) {
            road.generateCurves();
        }
    }

    public void setRoadsAndGenerateCurvesOnThread(List<Road> inputRoads) {
        this.setRoads(inputRoads);
        Thread roadCurveThread = new Thread(() -> {
            for (Road road : this.roads) {
                road.generateCurves();
            }
        }, "Road curve generator thread");
        roadCurveThread.start();
    }

    public RoadPointCache getRoadPointCache() {
        return this.roadPointCache;
    }

    public List<MapLabel> getLabels() {
        return this.labels;
    }

    public void setLabels(List<MapLabel> lbls) {
        if (this.labels != null) {
            throw new IllegalArgumentException("Cannot set map's labels - already set!");
        }
        this.labels = lbls;
    }
}

