/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.map;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Map;
import lotr.common.LOTRLog;
import lotr.common.data.InstancedJsonReloadListener;
import lotr.common.network.LOTRPacketHandler;
import lotr.common.network.SPacketMapSettings;
import lotr.common.world.map.MapLabel;
import lotr.common.world.map.MapSettings;
import lotr.common.world.map.MapWaypoint;
import lotr.common.world.map.NorthernLightsSettings;
import lotr.common.world.map.Road;
import lotr.common.world.map.WaterLatitudeSettings;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.fml.LogicalSide;

public class MapSettingsManager
extends InstancedJsonReloadListener {
    private static final String MAP_FOLDER = "map";
    private static final String WAYPOINT_SUBFOLDER = "waypoints/";
    private static final String ROAD_SUBFOLDER = "roads/";
    private static final String LABEL_SUBFOLDER = "labels/";
    private static final MapSettingsManager CLIENT_INSTANCE = new MapSettingsManager(LogicalSide.CLIENT);
    private static final MapSettingsManager SERVER_INSTANCE = new MapSettingsManager(LogicalSide.SERVER);
    private boolean loadedDefaultMap = false;
    private MapSettings defaultMap;
    private MapSettings currentLoadedMap;

    private MapSettingsManager(LogicalSide side) {
        super(MAP_FOLDER, "MapSettings", side);
    }

    public static MapSettingsManager clientInstance() {
        return CLIENT_INSTANCE;
    }

    public static MapSettingsManager serverInstance() {
        return SERVER_INSTANCE;
    }

    public static MapSettingsManager sidedInstance(IWorldReader world) {
        return !world.func_201670_d() ? SERVER_INSTANCE : CLIENT_INSTANCE;
    }

    public static MapSettingsManager sidedInstance(LogicalSide side) {
        return side == LogicalSide.SERVER ? SERVER_INSTANCE : CLIENT_INSTANCE;
    }

    public MapSettings getLoadedMapOrLoadDefault(IResourceManager resMgr) {
        this.loadDefaultMapIfNotLoaded(resMgr);
        return this.getCurrentLoadedMap();
    }

    private void loadDefaultMapIfNotLoaded(IResourceManager resMgr) {
        if (!this.loadedDefaultMap) {
            JsonObject mapJson = this.loadDefaultJson(MapSettings.MAP_SETTINGS_PATH);
            JsonObject waterJson = this.loadDefaultJson(WaterLatitudeSettings.WATER_SETTINGS_PATH);
            JsonObject nlJson = this.loadDefaultJson(NorthernLightsSettings.NORTHERN_LIGHTS_SETTINGS_PATH);
            Map<ResourceLocation, JsonObject> wpJsons = this.loadDefaultJsonsInSubFolder(WAYPOINT_SUBFOLDER, 4);
            JsonObject menuWpRouteJson = this.loadDefaultJson(MapSettings.MENU_WAYPOINT_ROUTE_PATH);
            Map<ResourceLocation, JsonObject> roadJsons = this.loadDefaultJsonsInSubFolder(ROAD_SUBFOLDER, 4);
            Map<ResourceLocation, JsonObject> labelJsons = this.loadDefaultJsonsInSubFolder(LABEL_SUBFOLDER, 4);
            this.defaultMap = this.loadMapFromJson(resMgr, mapJson, waterJson, nlJson, wpJsons, menuWpRouteJson, roadJsons, labelJsons);
            this.loadedDefaultMap = true;
            this.logMapLoad("Loaded default map settings", this.defaultMap);
        }
    }

    public void loadClientMapFromServer(IResourceManager resMgr, MapSettings mapSettings) {
        if (mapSettings.isDefaultImage()) {
            this.loadDefaultMapIfNotLoaded(resMgr);
            mapSettings.copyImageBytesFrom(this.defaultMap);
        }
        mapSettings.loadImage(resMgr);
        this.currentLoadedMap = mapSettings;
        this.logMapLoad("Loaded clientside map settings from server", this.currentLoadedMap);
    }

    private MapSettings loadMapFromJson(IResourceManager resMgr, JsonObject mapJson, JsonObject waterJson, JsonObject nlJson, Map<ResourceLocation, JsonObject> waypointJsons, JsonObject menuWpRouteJson, Map<ResourceLocation, JsonObject> roadJsons, Map<ResourceLocation, JsonObject> labelJsons) {
        MapSettings mapSettings = MapSettings.read(this, mapJson);
        mapSettings.loadImage(resMgr);
        WaterLatitudeSettings waterSettings = WaterLatitudeSettings.read(mapSettings, waterJson);
        mapSettings.setWaterLatitudes(waterSettings);
        NorthernLightsSettings northernLightsSettings = NorthernLightsSettings.read(mapSettings, nlJson);
        mapSettings.setNorthernLights(northernLightsSettings);
        ArrayList<MapWaypoint> waypoints = new ArrayList<MapWaypoint>();
        int nextWaypointId = 0;
        for (Map.Entry<ResourceLocation, JsonObject> entry : waypointJsons.entrySet()) {
            ResourceLocation resourceLocation = entry.getKey();
            ResourceLocation wpName = new ResourceLocation(resourceLocation.func_110624_b(), resourceLocation.func_110623_a().substring(WAYPOINT_SUBFOLDER.length()));
            JsonObject wpJson = entry.getValue();
            try {
                MapWaypoint waypoint = MapWaypoint.read(mapSettings, wpName, wpJson, nextWaypointId);
                if (waypoint != null) {
                    waypoints.add(waypoint);
                }
                ++nextWaypointId;
            }
            catch (Exception e) {
                LOTRLog.warn("Failed to load map waypoint %s from file", wpName);
                e.printStackTrace();
            }
        }
        mapSettings.setWaypoints(waypoints);
        mapSettings.readMenuWaypointRoute(menuWpRouteJson);
        ArrayList<Road> roads = new ArrayList<Road>();
        for (Map.Entry<ResourceLocation, JsonObject> entry : roadJsons.entrySet()) {
            ResourceLocation res = entry.getKey();
            ResourceLocation roadName = new ResourceLocation(res.func_110624_b(), res.func_110623_a().substring(ROAD_SUBFOLDER.length()));
            JsonObject roadJson = entry.getValue();
            try {
                Road road = Road.read(mapSettings, roadName, roadJson);
                if (road == null) continue;
                roads.add(road);
            }
            catch (Exception e) {
                LOTRLog.warn("Failed to load map road %s from file", roadName);
                e.printStackTrace();
            }
        }
        mapSettings.setRoadsAndGenerateCurvesInstantly(roads);
        ArrayList<MapLabel> arrayList = new ArrayList<MapLabel>();
        for (Map.Entry<ResourceLocation, JsonObject> entry : labelJsons.entrySet()) {
            ResourceLocation res = entry.getKey();
            ResourceLocation labelName = new ResourceLocation(res.func_110624_b(), res.func_110623_a().substring(LABEL_SUBFOLDER.length()));
            JsonObject labelJson = entry.getValue();
            try {
                MapLabel label = MapLabel.read(mapSettings, labelName, labelJson);
                if (label == null) continue;
                arrayList.add(label);
            }
            catch (Exception e) {
                LOTRLog.warn("Failed to load map label %s from file", labelName);
                e.printStackTrace();
            }
        }
        mapSettings.setLabels(arrayList);
        return mapSettings;
    }

    public MapSettings getCurrentLoadedMap() {
        if (this.currentLoadedMap != null) {
            return this.currentLoadedMap;
        }
        return this.defaultMap;
    }

    protected void apply(Map<ResourceLocation, JsonObject> jsons, IResourceManager serverResMgr, IProfiler profiler) {
        JsonObject mapJson = this.loadDataJsonIfExists(jsons, MapSettings.MAP_SETTINGS_PATH);
        JsonObject waterJson = this.loadDataJsonIfExists(jsons, WaterLatitudeSettings.WATER_SETTINGS_PATH);
        JsonObject nlJson = this.loadDataJsonIfExists(jsons, NorthernLightsSettings.NORTHERN_LIGHTS_SETTINGS_PATH);
        JsonObject menuWpRouteJson = this.loadDataJsonIfExists(jsons, MapSettings.MENU_WAYPOINT_ROUTE_PATH);
        if (mapJson != null && waterJson != null && nlJson != null && menuWpRouteJson != null) {
            Map<ResourceLocation, JsonObject> waypointJsons = this.filterDataJsonsBySubFolder(jsons, WAYPOINT_SUBFOLDER);
            Map<ResourceLocation, JsonObject> roadJsons = this.filterDataJsonsBySubFolder(jsons, ROAD_SUBFOLDER);
            Map<ResourceLocation, JsonObject> labelJsons = this.filterDataJsonsBySubFolder(jsons, LABEL_SUBFOLDER);
            this.currentLoadedMap = this.loadMapFromJson(serverResMgr, mapJson, waterJson, nlJson, waypointJsons, menuWpRouteJson, roadJsons, labelJsons);
            this.logMapLoad("Loaded serverside map settings", this.currentLoadedMap);
        } else {
            LOTRLog.error("Couldn't load serverside map settings - a necessary json file is missing! Which one could it be? Something is broken...");
        }
    }

    private void logMapLoad(String prefix, MapSettings map) {
        LOTRLog.info("%s - image %s, %d waypoints, %d roads, %d labels", prefix, map.getMapImagePath(), map.getWaypoints().size(), map.getRoads().size(), map.getLabels().size());
    }

    public void sendMapToPlayer(ServerPlayerEntity player) {
        SPacketMapSettings packet = new SPacketMapSettings(this.currentLoadedMap);
        LOTRPacketHandler.sendTo(packet, player);
    }
}

