/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.map;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import lotr.common.LOTRLog;
import lotr.common.world.map.MapSettings;
import lotr.common.world.map.RoadCurveGenerator;
import lotr.common.world.map.RoadSection;
import lotr.common.world.map.RouteRoadPoint;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class Road {
    private final MapSettings mapSettings;
    private final ResourceLocation resourceName;
    private final String name;
    private final boolean translateName;
    private final List<RouteRoadPoint> controlPoints;
    private final List<RoadSection> sections = new ArrayList<RoadSection>();

    public Road(MapSettings map, ResourceLocation res, String name, boolean translateName, List<RouteRoadPoint> controlPoints) {
        this.mapSettings = map;
        this.resourceName = res;
        this.name = name;
        this.translateName = translateName;
        this.controlPoints = controlPoints;
    }

    public Road generateCurves() {
        if (!this.sections.isEmpty()) {
            throw new IllegalStateException("Road " + this.resourceName + " curves were already generated");
        }
        this.sections.addAll(RoadCurveGenerator.generateSplines(this.mapSettings, this, this.controlPoints, this.mapSettings.getRoadPointCache()));
        return this;
    }

    public static Road read(MapSettings map, ResourceLocation resourceName, JsonObject json) {
        if (json.size() == 0) {
            LOTRLog.info("Road %s has an empty file - not loading it in this world", resourceName);
            return null;
        }
        JsonObject nameObj = json.get("name").getAsJsonObject();
        String name = nameObj.get("text").getAsString();
        boolean translateName = nameObj.get("translate").getAsBoolean();
        ArrayList<RouteRoadPoint> controlPoints = new ArrayList<RouteRoadPoint>();
        JsonArray route = json.get("route").getAsJsonArray();
        for (JsonElement routeElement : route) {
            JsonObject pointObj = routeElement.getAsJsonObject();
            RouteRoadPoint controlPoint = RouteRoadPoint.read(map, resourceName, pointObj);
            if (controlPoint == null) continue;
            controlPoints.add(controlPoint);
        }
        return new Road(map, resourceName, name, translateName, controlPoints);
    }

    public static Road read(MapSettings map, PacketBuffer buf) {
        ResourceLocation resourceName = buf.func_192575_l();
        String name = buf.func_218666_n();
        boolean translateName = buf.readBoolean();
        ArrayList<RouteRoadPoint> controlPoints = new ArrayList<RouteRoadPoint>();
        int routeSize = buf.func_150792_a();
        for (int i = 0; i < routeSize; ++i) {
            RouteRoadPoint controlPoint = RouteRoadPoint.read(map, resourceName, buf);
            if (controlPoint == null) continue;
            controlPoints.add(controlPoint);
        }
        return new Road(map, resourceName, name, translateName, controlPoints);
    }

    public void write(PacketBuffer buf) {
        buf.func_192572_a(this.resourceName);
        buf.func_180714_a(this.name);
        buf.writeBoolean(this.translateName);
        buf.func_150787_b(this.controlPoints.size());
        for (RouteRoadPoint point : this.controlPoints) {
            point.write(buf);
        }
    }

    public ResourceLocation getName() {
        return this.resourceName;
    }

    public ITextComponent getDisplayName() {
        if (this.translateName) {
            return new TranslationTextComponent(this.name, new Object[0]);
        }
        return new StringTextComponent(this.name);
    }

    public boolean hasSameDisplayNameAs(Road other) {
        return this.getDisplayName().func_150254_d().equals(other.getDisplayName().func_150254_d());
    }

    public List<RoadSection> getSections() {
        return this.sections;
    }
}

