/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import lotr.common.init.LOTRWorldTypes;
import lotr.common.world.map.MapSettingsManager;
import lotr.common.world.map.RoadPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import org.apache.commons.lang3.tuple.Pair;

public class RoadPointCache {
    private Map<Pair<Integer, Integer>, List<RoadPoint>> pointMap = new HashMap<Pair<Integer, Integer>, List<RoadPoint>>();
    private static final int COORD_LOOKUP_SCALE = 1000;
    private static final int ROAD_RADIUS = 4;
    private Map<Pair<Integer, Integer>, Boolean> roadAtQueryCache = new HashMap<Pair<Integer, Integer>, Boolean>();
    private static final int QUERY_CACHE_SIZE = 60000;

    public boolean isRoadAt(int x, int z) {
        Pair key = Pair.of((Object)x, (Object)z);
        Boolean cachedResult = this.roadAtQueryCache.get(key);
        if (cachedResult == null) {
            cachedResult = this.getRoadCentreCloseness(x, z, 4) >= 0.0f;
            if (this.roadAtQueryCache.size() > 60000) {
                this.roadAtQueryCache.clear();
            }
            this.roadAtQueryCache.put((Pair<Integer, Integer>)key, cachedResult);
        }
        return cachedResult;
    }

    public boolean isRoadAtPositionSurface(BlockPos pos) {
        return this.isRoadAt(pos.func_177958_n(), pos.func_177952_p());
    }

    public boolean isPartOfRoadWithinRange(int x, int z, int range) {
        return this.getRoadCentreCloseness(x, z, 4 + range) >= 0.0f;
    }

    public float getRoadCentreCloseness(int x, int z, int width) {
        double widthSq = width * width;
        float mostCloseness = -1.0f;
        List<RoadPoint> points = this.getPointsForCoords(x, z);
        for (RoadPoint point : points) {
            double dz;
            double dx = point.getWorldX() - (double)x;
            double distSq = dx * dx + (dz = point.getWorldZ() - (double)z) * dz;
            if (!(distSq < widthSq)) continue;
            double sqDistRatio = distSq / widthSq;
            float distRatio = 1.0f / (float)MathHelper.func_181161_i((double)sqDistRatio);
            float closeness = 1.0f - distRatio;
            if (mostCloseness == -1.0f) {
                mostCloseness = closeness;
                continue;
            }
            if (!(closeness > mostCloseness)) continue;
            mostCloseness = closeness;
        }
        return mostCloseness;
    }

    public List<RoadPoint> getPointsForCoords(int x, int z) {
        int x1 = x / 1000;
        int z1 = z / 1000;
        return this.getRoadList(x1, z1, false);
    }

    public void add(RoadPoint point) {
        int x = (int)Math.round(point.getWorldX() / 1000.0);
        int z = (int)Math.round(point.getWorldZ() / 1000.0);
        int overlap = 1;
        for (int i = -overlap; i <= overlap; ++i) {
            for (int k = -overlap; k <= overlap; ++k) {
                int xKey = x + i;
                int zKey = z + k;
                this.getRoadList(xKey, zKey, true).add(point);
            }
        }
    }

    private List<RoadPoint> getRoadList(int xKey, int zKey, boolean addToMap) {
        Pair key = Pair.of((Object)xKey, (Object)zKey);
        List<RoadPoint> list = this.pointMap.get(key);
        if (list == null) {
            list = new ArrayList<RoadPoint>();
            if (addToMap) {
                this.pointMap.put((Pair<Integer, Integer>)key, list);
            }
        }
        return list;
    }

    public static Predicate<BlockPos> filterNotGeneratingOnRoad(IWorld world) {
        return pos -> !LOTRWorldTypes.hasMapFeatures(world) || !MapSettingsManager.sidedInstance((IWorldReader)world).getCurrentLoadedMap().getRoadPointCache().isRoadAtPositionSurface((BlockPos)pos);
    }

    public static boolean checkNotGeneratingOnRoad(IWorld world, BlockPos pos) {
        return RoadPointCache.filterNotGeneratingOnRoad(world).test(pos);
    }

    public static boolean checkNotGeneratingWithinRangeOfRoad(IWorld world, BlockPos pos, int range) {
        return !LOTRWorldTypes.hasMapFeatures(world) || !MapSettingsManager.sidedInstance((IWorldReader)world).getCurrentLoadedMap().getRoadPointCache().isPartOfRoadWithinRange(pos.func_177958_n(), pos.func_177952_p(), range);
    }
}

