/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.map;

import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;

public interface Waypoint {
    public String getRawName();

    public ITextComponent getDisplayName();

    @Nullable
    public ITextComponent getDisplayLore();

    @Nullable
    public ITextComponent getDisplayOwnership();

    public double getMapX();

    public double getMapZ();

    public int getWorldX();

    public int getWorldZ();

    public int getWorldYForDisplay();

    @Nullable
    public BlockPos getTravelPosition(ServerWorld var1, PlayerEntity var2);

    public boolean hasPlayerUnlocked(PlayerEntity var1);

    public String getNotUnlockedMessage(PlayerEntity var1, BiFunction<String, Object[], String> var2);

    public boolean isCustom();

    public boolean isSharedCustom();

    public boolean isSharedHidden();

    public WaypointDisplayState getDisplayState(@Nullable PlayerEntity var1);

    public static enum WaypointDisplayState {
        HIDDEN(0, 0),
        STANDARD_LOCKED(0, 200),
        STANDARD_LOCKED_TO_ENEMIES(8, 200),
        STANDARD(4, 200),
        STANDARD_CONQUERED(12, 200),
        CUSTOM_LOCKED(0, 204),
        CUSTOM(4, 204),
        SHARED_CUSTOM_LOCKED(0, 208),
        SHARED_CUSTOM(4, 208);

        public final int iconU;
        public final int iconV;

        private WaypointDisplayState(int u, int v) {
            this.iconU = u;
            this.iconV = v;
        }

        public boolean isHidden() {
            return this == HIDDEN;
        }
    }
}

