/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.map;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;

public enum WaypointRegion {
    SEA("sea"),
    WESTERN_ISLES("western_isles"),
    SHIRE("shire"),
    OLD_FOREST("old_forest"),
    LINDON("lindon"),
    BLUE_MOUNTAINS("blue_mountains"),
    ERIADOR("eriador"),
    BREE_LAND("bree_land"),
    LONE_LANDS("lone_lands"),
    RIVENDELL("rivendell"),
    TROLLSHAWS("trollshaws"),
    COLDFELLS("coldfells"),
    ETTENMOORS("ettenmoors"),
    ANGMAR("angmar"),
    EREGION("eregion"),
    DUNLAND("dunland"),
    ENEDWAITH("enedwaith"),
    NAN_CURUNIR("nan_curunir"),
    NORTHLANDS("northlands"),
    FOROCHEL("forochel"),
    FORODWAITH("forodwaith"),
    MISTY_MOUNTAINS("misty_mountains"),
    GREY_MOUNTAINS("grey_mountains"),
    VALES_OF_ANDUIN("vales_of_anduin"),
    WOODLAND_REALM("woodland_realm"),
    MIRKWOOD("mirkwood"),
    WILDERLAND("wilderland"),
    DALE("dale"),
    IRON_HILLS("iron_hills"),
    LOTHLORIEN("lothlorien"),
    FANGORN("fangorn"),
    ROHAN("rohan"),
    WHITE_MOUNTAINS("white_mountains"),
    DRUWAITH_IAUR("druwaith_iaur"),
    ANDRAST("andrast"),
    ANORIEN("anorien"),
    ITHILIEN("ithilien"),
    LOSSARNACH("lossarnach"),
    LEBENNIN("lebennin"),
    DOR_EN_ERNIL("dor_en_ernil"),
    LAMEDON("lamedon"),
    BLACKROOT_VALE("blackroot_vale"),
    PINNATH_GELIN("pinnath_gelin"),
    ANFALAS("anfalas"),
    WESTERN_GONDOR("western_gondor"),
    TOLFALAS("tolfalas"),
    EMYN_MUIL("emyn_muil"),
    NINDALF("nindalf"),
    BROWN_LANDS("brown_lands"),
    DAGORLAD("dagorlad"),
    MORDOR("mordor"),
    NURN("nurn"),
    DORWINION("dorwinion"),
    HARONDOR("harondor"),
    HARNENNOR("harnennor"),
    LOSTLADEN("lostladen"),
    UMBAR("umbar"),
    SOUTHRON_COASTS("southron_coasts"),
    HARAD_DESERT("harad_desert");

    public final ResourceLocation namespacedID;
    public final int networkID;

    private WaypointRegion(String name) {
        this.namespacedID = new ResourceLocation("lotr", name);
        this.networkID = this.ordinal();
    }

    public static WaypointRegion forName(ResourceLocation name) {
        for (WaypointRegion region : WaypointRegion.values()) {
            if (!region.namespacedID.equals((Object)name)) continue;
            return region;
        }
        return null;
    }

    public static List<ResourceLocation> getAllNames() {
        return Stream.of(WaypointRegion.values()).map(region -> region.namespacedID).collect(Collectors.toList());
    }

    public static WaypointRegion forNetworkID(int id) {
        for (WaypointRegion region : WaypointRegion.values()) {
            if (region.networkID != id) continue;
            return region;
        }
        return null;
    }
}

