/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.thinkbigcore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;

public class ChestHooks
extends ChestGenHooks {
    private static final HashMap<String, ChestHooks> chestInfo = new HashMap();
    private int countMin = 0;
    private int countMax = 0;
    private ArrayList<WeightedRandomChestContent> contents = new ArrayList();

    public static void init(String category, List items, int min, int max) {
        chestInfo.put(category, new ChestHooks(category, items, min, max));
    }

    public static ChestHooks getInfo(String category) {
        if (!chestInfo.containsKey(category)) {
            chestInfo.put(category, new ChestHooks(category));
        }
        return chestInfo.get(category);
    }

    public WeightedRandomChestContent[] getItems(Random rnd) {
        ArrayList<WeightedRandomChestContent> ret = new ArrayList<WeightedRandomChestContent>();
        for (WeightedRandomChestContent orig : this.contents) {
            WeightedRandomChestContent n;
            Item item = orig.field_76297_b.func_77973_b();
            if (item == null || (n = item.getChestGenBase((ChestGenHooks)this, rnd, orig)) == null) continue;
            ret.add(n);
        }
        return ret.toArray(new WeightedRandomChestContent[ret.size()]);
    }

    public int getCount(Random rand) {
        return this.countMin < this.countMax ? this.countMin + rand.nextInt(this.countMax - this.countMin) : this.countMin;
    }

    public void removeItem(ItemStack item) {
        Iterator<WeightedRandomChestContent> itr = this.contents.iterator();
        while (itr.hasNext()) {
            WeightedRandomChestContent cont = itr.next();
            if (!item.func_77969_a(cont.field_76297_b) && (item.func_77960_j() != Short.MAX_VALUE || item.func_77973_b() != cont.field_76297_b.func_77973_b())) continue;
            itr.remove();
        }
    }

    public ItemStack getOneItem(Random rand) {
        WeightedRandomChestContent[] items = this.getItems(rand);
        WeightedRandomChestContent item = (WeightedRandomChestContent)WeightedRandom.func_76274_a((Random)rand, (WeightedRandom.Item[])items);
        ItemStack[] stacks = ChestGenHooks.generateStacks((Random)rand, (ItemStack)item.field_76297_b, (int)item.field_76295_d, (int)item.field_76296_e);
        return stacks.length > 0 ? stacks[0] : null;
    }

    public static WeightedRandomChestContent[] getItems(String category, Random rnd) {
        return ChestHooks.getInfo(category).getItems(rnd);
    }

    public static int getCount(String category, Random rand) {
        return ChestHooks.getInfo(category).getCount(rand);
    }

    public static void addItem(String category, WeightedRandomChestContent item) {
        ChestHooks.getInfo(category).addItem(item);
    }

    public static void removeItem(String category, ItemStack item) {
        ChestHooks.getInfo(category).removeItem(item);
    }

    public static ItemStack getOneItem(String category, Random rand) {
        return ChestHooks.getInfo(category).getOneItem(rand);
    }

    public ChestHooks(String category) {
        super(category);
    }

    public ChestHooks(String category, List<WeightedRandomChestContent> items, int min, int max) {
        this(category);
        for (WeightedRandomChestContent item : items) {
            this.contents.add(item);
        }
        this.countMin = min;
        this.countMax = max;
    }
}

