/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.LOT;

import com.google.common.base.Predicate;
import com.superdextor.LOT.init.LOTBlocks;
import com.superdextor.LOT.worldgen.GenRainbowBox;
import com.superdextor.LOT.worldgen.GenRainbowFlowers;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockHelper;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class LOTGeneration
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.func_177502_q()) {
            case 1: {
                this.generateEnd(world, random, new BlockPos(chunkX * 16, 64, chunkZ * 16));
                break;
            }
            case 0: {
                this.generateOverworld(world, random, new BlockPos(chunkX * 16, 64, chunkZ * 16));
                break;
            }
            case -1: {
                this.generateNether(world, random, new BlockPos(chunkX * 16, 64, chunkZ * 16));
            }
        }
    }

    private void addNetherrackOre(Block block, World world, Random random, BlockPos pos, int maxX, int maxZ, int maxVeinSize, int chanceToSpawn, int minY, int maxY, Block generateIn) {
        WorldGenMinable mine = new WorldGenMinable(block.func_176223_P(), maxVeinSize, (Predicate)BlockHelper.func_177642_a((Block)Blocks.field_150424_aL));
        for (int i = 0; i < chanceToSpawn; ++i) {
            int x = pos.func_177958_n() + random.nextInt(maxX);
            int y = minY + random.nextInt(maxY - minY);
            int z = pos.func_177952_p() + random.nextInt(maxZ);
            mine.func_180709_b(world, random, new BlockPos(x, y, z));
        }
    }

    private void addStoneOre(Block block, World world, Random random, BlockPos pos, int maxX, int maxZ, int maxVeinSize, int chanceToSpawn, int minY, int maxY, Block generateIn) {
        WorldGenMinable mine = new WorldGenMinable(block.func_176223_P(), maxVeinSize);
        for (int i = 0; i < chanceToSpawn; ++i) {
            int x = pos.func_177958_n() + random.nextInt(maxX);
            int y = minY + random.nextInt(maxY - minY);
            int z = pos.func_177952_p() + random.nextInt(maxZ);
            mine.func_180709_b(world, random, new BlockPos(x, y, z));
        }
    }

    private void generateNether(World world, Random random, BlockPos pos) {
        int x = pos.func_177958_n() + random.nextInt(16);
        int y = 8 + random.nextInt(72);
        int z = pos.func_177952_p() + random.nextInt(16);
        GenRainbowBox rainbowbox = new GenRainbowBox(Blocks.field_150424_aL);
        rainbowbox.func_180709_b(world, random, new BlockPos(x, y, z));
    }

    private void generateOverworld(World world, Random random, BlockPos pos) {
        int x = pos.func_177958_n() + random.nextInt(16);
        int y = 8 + random.nextInt(72);
        int z = pos.func_177952_p() + random.nextInt(16);
        GenRainbowFlowers rainbowflower = new GenRainbowFlowers(14);
        GenRainbowBox rainbowbox = new GenRainbowBox((Block)Blocks.field_150349_c);
        rainbowflower.func_180709_b(world, random, new BlockPos(x, y, z));
        rainbowbox.func_180709_b(world, random, new BlockPos(x, y, z));
        this.addStoneOre(LOTBlocks.copper_ore, world, random, pos, 16, 16, 3 + random.nextInt(9), 24, 0, 89, Blocks.field_150348_b);
        this.addStoneOre(LOTBlocks.ruby_ore, world, random, pos, 16, 16, 3 + random.nextInt(4), 1, 0, 14, Blocks.field_150348_b);
    }

    private void generateEnd(World world, Random random, BlockPos pos) {
        int x = pos.func_177958_n() + random.nextInt(16);
        int y = 8 + random.nextInt(72);
        int z = pos.func_177952_p() + random.nextInt(16);
        GenRainbowBox rainbowbox = new GenRainbowBox(Blocks.field_150377_bs);
        rainbowbox.func_180709_b(world, random, new BlockPos(x, y, z));
    }
}

