/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.LOT.blocks;

import com.superdextor.LOT.LOTConfig;
import com.superdextor.LOT.blocks.BlockRainbowBox;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class RainbowEvent {
    protected int EventID;
    protected final boolean isBadEvent;
    protected Event event;
    protected ItemStack[] items = new ItemStack[10];
    protected Integer[] minItem = new Integer[10];
    protected Integer[] maxItem = new Integer[10];
    protected Class[] entitys = new Class[10];
    protected Random rand = new Random();
    protected String soundEffect;
    protected WorldGenerator build;

    public RainbowEvent(int EventID, boolean isBad, Event event) {
        this.isBadEvent = isBad;
        this.event = event;
        this.addToEventList(EventID);
    }

    protected RainbowEvent addToEventList(int EventID) {
        if (this.isBadEvent) {
            BlockRainbowBox.BadEvents[EventID] = this;
        } else {
            BlockRainbowBox.GoodEvents[EventID] = this;
        }
        return this;
    }

    public Event getEvent() {
        return this.event;
    }

    public RainbowEvent setItem(Item itemIn, int min, int max) {
        this.setItems(new ItemStack(itemIn), min, max);
        return this;
    }

    public RainbowEvent setItems(ItemStack stack, int min, int max) {
        int j = this.items.length;
        for (int k = 0; j > k; ++k) {
            if (this.items[k] != null) continue;
            this.items[k] = stack;
            this.minItem[k] = min;
            this.maxItem[k] = max;
            return this;
        }
        return this;
    }

    public RainbowEvent setEntity(Class entity, int min, int max) {
        int j = this.items.length;
        for (int k = 0; j > k; ++k) {
            if (this.entitys[k] != null) continue;
            this.entitys[k] = entity;
            this.minItem[k] = min;
            this.maxItem[k] = max;
            return this;
        }
        return this;
    }

    public Entity customizeEntity(Entity entity) {
        return entity;
    }

    public ItemStack CustmizeItem(ItemStack stack, int ID) {
        return stack;
    }

    public final RainbowEvent TriggerEvent(World worldIn, BlockPos pos, EntityLivingBase breaker) {
        if (this.soundEffect != null) {
            worldIn.func_72908_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), this.soundEffect, 1.0f, 1.0f);
        }
        if (LOTConfig.RainbowBox > 0) {
            if (this.event == Event.ITEM) {
                this.ItemEvent(worldIn, pos, breaker);
            } else if (this.event == Event.MOB) {
                this.MobEvent(worldIn, pos, breaker);
            } else if (this.event == Event.BUILD) {
                this.BuildEvent(worldIn, pos, breaker);
            } else {
                this.CustomEvent(worldIn, pos, breaker);
            }
        }
        return this;
    }

    public EntityItem DropItem(ItemStack itemStackIn, World world, BlockPos pos) {
        if (itemStackIn.field_77994_a != 0 && itemStackIn.func_77973_b() != null) {
            EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), itemStackIn);
            entityitem.func_174869_p();
            world.func_72838_d((Entity)entityitem);
            return entityitem;
        }
        return null;
    }

    public Entity spawnCreature(World worldIn, String entityID, double x, double y, double z, int number) {
        Entity entity = EntityList.func_75620_a((String)entityID, (World)worldIn);
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            entityliving.field_70759_as = entityliving.field_70177_z;
            entityliving.field_70761_aq = entityliving.field_70177_z;
            entityliving.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)entityliving)), (IEntityLivingData)null);
            entityliving.func_70642_aH();
        }
        entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        worldIn.func_72838_d(this.customizeEntity(entity));
        return entity;
    }

    public RainbowEvent setEventSound(String sound) {
        this.soundEffect = sound;
        return this;
    }

    public RainbowEvent setBuild(WorldGenerator creation) {
        this.build = creation;
        return this;
    }

    protected void ItemEvent(World worldIn, BlockPos pos, EntityLivingBase breaker) {
        int size = this.items.length;
        for (int k = 0; k < size; ++k) {
            ItemStack stackIn = this.items[k];
            if (stackIn == null) continue;
            int i = this.maxItem[k];
            int amount = 0;
            amount = i > 0 ? this.minItem[k] + this.rand.nextInt(i) : 1;
            for (int j = 0; amount > j; ++j) {
                this.DropItem(this.CustmizeItem(stackIn.func_77946_l(), k), worldIn, pos);
            }
        }
    }

    protected void MobEvent(World worldIn, BlockPos pos, EntityLivingBase breaker) {
        int size = this.entitys.length;
        for (int k = 0; k < size; ++k) {
            Class entityIn = this.entitys[k];
            if (entityIn == null) continue;
            int i = this.maxItem[k];
            int amount = 0;
            amount = i > 0 ? this.minItem[k] + this.rand.nextInt(i) : 1;
            for (int j = 0; amount > j; ++j) {
                this.spawnCreature(worldIn, (String)EntityList.field_75626_c.get(entityIn), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), j);
            }
        }
    }

    protected void BuildEvent(World worldIn, BlockPos pos, EntityLivingBase breaker) {
        if (LOTConfig.RainbowBox > 1 && !worldIn.field_72995_K) {
            this.build.func_180709_b(worldIn, this.rand, pos);
        }
    }

    protected void CustomEvent(World worldIn, BlockPos pos, EntityLivingBase breaker) {
    }

    public static enum Event {
        ITEM,
        MOB,
        BUILD,
        CUSTOM;

    }
}

