/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.LOT.items;

import com.superdextor.LOT.entity.EntityBullet;
import com.superdextor.LOT.init.LOTItems;
import com.superdextor.LOT.items.ItemWeapon;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemPistol
extends ItemWeapon {
    private final boolean isGolden;
    private final int shotDelay;
    private final int reloadDelay;

    public ItemPistol(boolean golden, int shotDelay, int reloadDelay) {
        super(12);
        this.isGolden = golden;
        this.shotDelay = shotDelay;
        this.reloadDelay = reloadDelay;
    }

    @Override
    public float getZoomIn() {
        return 0.7f;
    }

    @Override
    public void ShotWeapon(ItemStack stack, EntityPlayer player) {
        int l;
        int k;
        super.ShotWeapon(stack, player);
        World world = player.field_70170_p;
        EntityBullet bullet = new EntityBullet(world, (EntityLivingBase)player, 2.4f, 3.0);
        bullet.setIsCritical(this.isGolden);
        if (this.isGolden) {
            bullet.setDamage(bullet.getDamage() + -0.3);
        }
        if ((k = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)stack)) > 0) {
            bullet.setDamage(bullet.getDamage() + (double)k * 0.5 + 0.5);
        }
        if ((l = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)stack)) > 0) {
            bullet.setKnockbackStrength(l);
        }
        if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)stack) > 0) {
            bullet.func_70015_d(100);
        }
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)bullet);
        }
    }

    @Override
    public int getReloadTime() {
        return this.reloadDelay;
    }

    @Override
    public int getUseDelay() {
        return this.shotDelay;
    }

    @Override
    public Item getReloadItem() {
        return LOTItems.pistol_ammo;
    }

    @Override
    public String getReloadSound() {
        return "lot:reload.pistol";
    }

    @Override
    public String getUseSound() {
        return "lot:shoot.pistol";
    }

    @Override
    public String getCockbackSound() {
        return "lot:reload.pistol";
    }

    @Override
    public int getWeaponDamage() {
        return this.isGolden ? 9 : 10;
    }

    @Override
    public int getWeaponType() {
        return 0;
    }
}

