/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.LOT.items;

import com.superdextor.LOT.LOTAchievements;
import com.superdextor.LOT.LOTMessages;
import com.superdextor.LOT.items.ItemCooldown;
import com.superdextor.thinkbigcore.EffectHelper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWeapon
extends ItemCooldown {
    public ItemWeapon(int maxammo) {
        this.field_77777_bU = 1;
        this.func_77656_e(maxammo);
        this.func_77664_n();
        this.setNoRepair();
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        if (this.getWeaponType() == 0 && this.IsItemUsable(itemStackIn, playerIn)) {
            playerIn.func_71008_a(itemStackIn, this.func_77626_a(itemStackIn));
        } else if (this.getWeaponType() == 1) {
            this.ShotWeapon(itemStackIn, playerIn);
        }
        return itemStackIn;
    }

    public boolean onDroppedByPlayer(ItemStack stack, EntityPlayer player) {
        if (this.getWeaponType() == 0) {
            this.UseWeapon(stack, player);
            return false;
        }
        return true;
    }

    @Override
    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.field_72995_K) {
            if (stack.func_77978_p() == null) {
                stack.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound nbt = stack.func_77978_p();
            if (stack.func_77978_p().func_74764_b("cooldown")) {
                int cooldownIn = nbt.func_74762_e("cooldown");
                if (cooldownIn > 0) {
                    nbt.func_74768_a("cooldown", cooldownIn - 1);
                }
                if (cooldownIn == 5) {
                    if (this.getDamage(stack) >= this.func_77612_l()) {
                        if (this.getReloadSound() != null) {
                            worldIn.func_72956_a(entityIn, this.getReloadSound(), 1.0f, 1.0f);
                        }
                    } else if (this.getCockbackSound() != null) {
                        worldIn.func_72956_a(entityIn, this.getCockbackSound(), 1.0f, 1.0f);
                    }
                }
            }
        }
    }

    public void ShotWeapon(ItemStack stack, EntityPlayer player) {
        World world = player.field_70170_p;
        boolean flag = player.field_71075_bZ.field_75098_d;
        stack.func_77972_a(1, (EntityLivingBase)player);
        if (!flag) {
            this.SetCooldownIn(stack, this.getUseDelay());
        }
        world.func_72956_a((Entity)player, this.getUseSound(), 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + this.getPitch() * 0.5f);
        if (!this.noLightEffect()) {
            EffectHelper.AddLightEffect((World)world, (BlockPos)new BlockPos(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v), (int)2);
        }
    }

    public void UseWeapon(ItemStack stack, EntityPlayer player) {
        World world = player.field_70170_p;
        boolean flag = player.field_71075_bZ.field_75098_d;
        if (this.IsItemUsable(stack, player)) {
            if (this.getDamage(stack) < this.func_77612_l()) {
                this.ShotWeapon(stack, player);
            } else {
                if (flag || player.field_71071_by.func_146028_b(this.getReloadItem())) {
                    player.field_71071_by.func_146026_a(this.getReloadItem());
                    this.setDamage(stack, 0);
                    if (!flag) {
                        this.SetCooldownIn(stack, this.getReloadTime());
                    }
                } else if (!flag) {
                    this.SetCooldownIn(stack, 4);
                }
                world.func_72956_a((Entity)player, "random.click", 1.0f, 1.0f);
            }
        } else {
            world.func_72956_a((Entity)player, "random.click", 1.0f, 1.0f);
            LOTMessages.CooldownMessage((EntityLivingBase)player, "Weapon", this.getCooldownIn(stack));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List tooltip, boolean advanced) {
        tooltip.add(" ");
        if (this.getWeaponType() == 0) {
            tooltip.add(EnumChatFormatting.BLUE + "Press Q to Fire");
            tooltip.add(EnumChatFormatting.BLUE + "Right Click to use Scope");
        } else if (this.getWeaponType() == 1) {
            tooltip.add(EnumChatFormatting.BLUE + "Right Click to Fire");
        }
        tooltip.add(" ");
        if (this.getUseDelay() > 0) {
            tooltip.add(EnumChatFormatting.BLUE + "Weapon Cooldown: " + this.getUseDelay() / 10);
        }
        tooltip.add(EnumChatFormatting.BLUE + "Max Ammo: " + this.func_77612_l());
        if (this.getReloadItem() != null) {
            tooltip.add(EnumChatFormatting.BLUE + "Reload Item: " + this.getReloadItem().func_77658_a().substring(5));
        }
        if (this.getBonus() != null) {
            tooltip.add(EnumChatFormatting.BLUE + "Bonus: " + this.getBonus());
        }
        if (this.getWeaponDamage() > 0) {
            tooltip.add(EnumChatFormatting.BLUE + "+" + this.getWeaponDamage() + " Weapon Damage");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getZoomIn() {
        return 0.0f;
    }

    public int getReloadTime() {
        return 0;
    }

    public int getUseDelay() {
        return 0;
    }

    public Item getReloadItem() {
        return null;
    }

    public String getReloadSound() {
        return null;
    }

    public String getUseSound() {
        return null;
    }

    public String getCockbackSound() {
        return null;
    }

    public int getWeaponDamage() {
        return 0;
    }

    public int getWeaponType() {
        return -1;
    }

    public float getPitch() {
        return 1.0f;
    }

    public String getBonus() {
        return null;
    }

    public boolean noLightEffect() {
        return false;
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        playerIn.func_71064_a((StatBase)LOTAchievements.achievementGuns, 1);
    }
}

