/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.thinkbigcore.bigbook;

import com.google.gson.JsonParseException;
import com.superdextor.thinkbigcore.RecipeHelper;
import com.superdextor.thinkbigcore.bigbook.BookInformation;
import com.superdextor.thinkbigcore.bigbook.InformationItem;
import com.superdextor.thinkbigcore.bigbook.InformationTab;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiUtilRenderComponents;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.event.ClickEvent;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiBigBook
extends GuiScreen {
    private static final ResourceLocation bookGuiTextures = new ResourceLocation("textures/gui/book.png");
    private final EntityPlayer readingPlayer;
    private int updateCount;
    private int bookImageWidth = 192;
    private int bookImageHeight = 192;
    private int currentpageamount = 1;
    private int currPage;
    private List field_175386_A;
    private int field_175387_B = -1;
    private NextPageButton buttonNextPage;
    private NextPageButton buttonPreviousPage;
    private GuiButton buttonBigDone;
    private GuiButton buttonDone;
    private GuiButton buttonBack;
    private BookInformation currentInformation = null;
    private InformationTab currentTab = null;
    private InformationItem currentItem = null;
    private String informationText = "";
    private int mainpageamount = 0;
    private Entity displayEntity = null;
    private EntityItem defaultItemEntity = null;
    private World world = null;
    private float entitySize = 1.0f;
    private boolean requestPostUpdate = false;

    public GuiBigBook(EntityPlayer player) {
        this.readingPlayer = player;
        this.world = player.field_70170_p;
        this.defaultItemEntity = (EntityItem)EntityList.func_75620_a((String)"Item", (World)this.world);
    }

    public void func_73876_c() {
        super.func_73876_c();
        ++this.updateCount;
        if (this.requestPostUpdate) {
            if (this.currentInformation == null) {
                this.buttonBack.field_146125_m = false;
                this.buttonDone.field_146125_m = false;
                this.buttonBigDone.field_146125_m = true;
            } else {
                this.buttonBack.field_146125_m = true;
                this.buttonDone.field_146125_m = true;
                this.buttonBigDone.field_146125_m = false;
            }
        }
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.buttonDone = new GuiButton(0, this.field_146294_l / 2 - 100, 4 + this.bookImageHeight, 98, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.field_146292_n.add(this.buttonDone);
        this.buttonBack = new GuiButton(4, this.field_146294_l / 2 + 2, 4 + this.bookImageHeight, 98, 20, I18n.func_135052_a((String)"gui.back", (Object[])new Object[0]));
        this.field_146292_n.add(this.buttonBack);
        this.buttonBigDone = new GuiButton(0, this.field_146294_l / 2 - 100, 4 + this.bookImageHeight, 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.field_146292_n.add(this.buttonBigDone);
        int i = (this.field_146294_l - this.bookImageWidth) / 2;
        int b0 = 2;
        this.buttonNextPage = new NextPageButton(1, i + 120, b0 + 154, true);
        this.field_146292_n.add(this.buttonNextPage);
        this.buttonPreviousPage = new NextPageButton(2, i + 38, b0 + 154, false);
        this.field_146292_n.add(this.buttonPreviousPage);
        int offset = 0;
        int amount = 0;
        int k = (this.field_146294_l - this.bookImageWidth) / 2;
        for (BookInformation information : BookInformation.informationList) {
            this.field_146292_n.add(new MainButton(this, k + 44, 52 + offset, information, amount / 5));
            if ((offset += 22) >= 110) {
                offset = 0;
            }
            ++amount;
        }
        offset = 0;
        if (amount % 5 == 0) {
            offset = -1;
        }
        this.mainpageamount = amount / 5 + 1 + offset;
        this.updateButtons();
    }

    private void updateButtons() {
        this.currentpageamount = this.currentItem != null ? 0 : (this.currentTab != null ? this.currentTab.pages : (this.currentInformation != null ? this.currentInformation.pages : this.mainpageamount));
        this.buttonNextPage.field_146125_m = this.currentItem == null && this.currPage < this.currentpageamount - 1;
        this.buttonPreviousPage.field_146125_m = this.currentItem == null && this.currPage > 0;
        this.displayEntity = null;
        for (Object butten : this.field_146292_n) {
            if (!(butten instanceof IUpdatableButton)) continue;
            ((IUpdatableButton)butten).update();
        }
        this.requestPostUpdate = true;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            if (button.field_146127_k == 0) {
                this.field_146297_k.func_147108_a((GuiScreen)null);
            } else if (button.field_146127_k == 1) {
                if (this.currPage < this.currentpageamount - 1) {
                    ++this.currPage;
                }
            } else if (button.field_146127_k == 2) {
                if (this.currPage > 0) {
                    --this.currPage;
                }
            } else if (button.field_146127_k == 4) {
                this.informationText = "";
                if (this.currentItem != null) {
                    this.currentItem = null;
                    if (this.currentTab != null && this.currentTab.redirect) {
                        this.currentTab = null;
                    }
                } else if (this.currentTab != null) {
                    this.currentTab = null;
                    if (this.currentInformation != null && this.currentInformation.redirect) {
                        this.currentInformation = null;
                    }
                } else if (this.currentInformation != null) {
                    this.currentInformation = null;
                }
            }
            this.updateButtons();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        RenderHelper.func_74520_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.displayEntity != null) {
            this.drawEntityOnScreen(204, 64, this.displayEntity);
        }
        this.field_146297_k.func_110434_K().func_110577_a(bookGuiTextures);
        int k = (this.field_146294_l - this.bookImageWidth) / 2;
        int b0 = 2;
        this.func_73729_b(k, b0, 0, 0, this.bookImageWidth, this.bookImageHeight);
        String s = I18n.func_135052_a((String)"book.pageIndicator", (Object[])new Object[]{this.currPage + 1, this.currentpageamount});
        if (this.field_175387_B != this.currPage) {
            try {
                IChatComponent ichatcomponent = IChatComponent.Serializer.func_150699_a((String)this.informationText);
                this.field_175386_A = ichatcomponent != null ? GuiUtilRenderComponents.func_178908_a((IChatComponent)ichatcomponent, (int)68, (FontRenderer)this.field_146289_q, (boolean)true, (boolean)true) : null;
            }
            catch (JsonParseException jsonparseexception) {
                this.field_175386_A = null;
            }
            this.field_175387_B = this.currPage;
        }
        int l = this.field_146289_q.func_78256_a(s);
        if (this.currentpageamount > 1) {
            this.field_146289_q.func_78276_b(s, k - l + this.bookImageWidth - 44, b0 + 16, 0);
        }
        if (this.field_175386_A == null) {
            this.field_146289_q.func_78279_b(this.informationText, k + 36, b0 + 64, 116, 0);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        IChatComponent ichatcomponent;
        if (mouseButton == 0 && this.func_175276_a(ichatcomponent = this.func_175385_b(mouseX, mouseY))) {
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected boolean func_175276_a(IChatComponent p_175276_1_) {
        ClickEvent clickevent;
        ClickEvent clickEvent = clickevent = p_175276_1_ == null ? null : p_175276_1_.func_150256_b().func_150235_h();
        if (clickevent == null) {
            return false;
        }
        if (clickevent.func_150669_a() == ClickEvent.Action.CHANGE_PAGE) {
            String s = clickevent.func_150668_b();
            try {
                int i = Integer.parseInt(s) - 1;
                if (i >= 0 && i < this.currentpageamount && i != this.currPage) {
                    this.currPage = i;
                    this.updateButtons();
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }
        boolean flag = super.func_175276_a(p_175276_1_);
        if (flag && clickevent.func_150669_a() == ClickEvent.Action.RUN_COMMAND) {
            this.field_146297_k.func_147108_a((GuiScreen)null);
        }
        return flag;
    }

    public IChatComponent func_175385_b(int p_175385_1_, int p_175385_2_) {
        if (this.field_175386_A == null) {
            return null;
        }
        int k = p_175385_1_ - (this.field_146294_l - this.bookImageWidth) / 2 - 36;
        int l = p_175385_2_ - 2 - 16 - 16;
        if (k >= 0 && l >= 0) {
            int i1 = Math.min(128 / this.field_146289_q.field_78288_b, this.field_175386_A.size());
            if (k <= 116 && l < this.field_146297_k.field_71466_p.field_78288_b * i1 + i1) {
                int j1 = l / this.field_146297_k.field_71466_p.field_78288_b;
                if (j1 >= 0 && j1 < this.field_175386_A.size()) {
                    IChatComponent ichatcomponent = (IChatComponent)this.field_175386_A.get(j1);
                    int k1 = 0;
                    for (IChatComponent ichatcomponent1 : ichatcomponent) {
                        if (!(ichatcomponent1 instanceof ChatComponentText) || (k1 += this.field_146297_k.field_71466_p.func_78256_a(((ChatComponentText)ichatcomponent1).func_150265_g())) <= k) continue;
                        return ichatcomponent1;
                    }
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public void drawEntityOnScreen(int x, int y, Entity entity) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)50.0f);
        GlStateManager.func_179152_a((float)this.entitySize, (float)this.entitySize, (float)this.entitySize);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)this.updateCount, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_147940_a(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f);
        rendermanager.func_178633_a(true);
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public static interface IUpdatableButton {
        public void update();
    }

    @SideOnly(value=Side.CLIENT)
    static class ItemButton
    extends GuiButton
    implements IUpdatableButton {
        private final ItemStack icon;
        private final GuiBigBook bigbook;
        private final InformationTab tab;
        private final int displayPage;
        private final BookInformation information;
        private final InformationItem item;
        private boolean IsInited = false;
        private ItemStack[] craftingrecipe;
        private EntityItem entity;

        public ItemButton(GuiBigBook bigbook, int x, int y, BookInformation information, InformationTab tab, InformationItem item, int page) {
            super(3, x, y, 96, 16, item.name);
            this.icon = item.icon;
            this.bigbook = bigbook;
            this.tab = tab;
            this.displayPage = page;
            this.information = information;
            this.item = item;
            this.craftingrecipe = RecipeHelper.getRecipe(this.icon);
            if (this.craftingrecipe != null) {
                for (int k = 0; k < this.craftingrecipe.length; ++k) {
                    if (this.craftingrecipe[k] == null || this.craftingrecipe[k].func_77973_b() == null || this.craftingrecipe[k].func_77960_j() != Short.MAX_VALUE) continue;
                    this.craftingrecipe[k].func_77964_b(0);
                    this.craftingrecipe[k].func_151001_c("variant");
                }
            }
        }

        public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
            if (this.field_146125_m) {
                this.bigbook.field_146296_j.func_180450_b(this.icon, this.field_146128_h, this.field_146129_i - 6);
                this.bigbook.field_146289_q.func_78279_b(this.field_146126_j, this.field_146128_h + 22, this.field_146129_i, 116, 0);
            } else if (this.bigbook.currentItem == this.item) {
                this.bigbook.informationText = this.item.information;
                if (!this.IsInited) {
                    if (this.item.entity == null) {
                        this.bigbook.defaultItemEntity.func_92058_a(this.icon);
                        this.bigbook.displayEntity = (Entity)this.bigbook.defaultItemEntity;
                        this.bigbook.entitySize = 80.0f;
                    } else {
                        this.bigbook.displayEntity = EntityList.func_75620_a((String)((String)EntityList.field_75626_c.get(this.item.entity)), (World)this.bigbook.world);
                        this.bigbook.entitySize = 50.0f - ((GuiBigBook)this.bigbook).displayEntity.field_70131_O * 12.0f;
                    }
                    this.IsInited = true;
                }
            }
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            boolean flag;
            boolean bl = flag = this.field_146124_l && this.field_146125_m && mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            if (!flag) {
                return false;
            }
            this.bigbook.currentInformation = this.information;
            this.bigbook.currentTab = this.tab;
            this.bigbook.currentItem = this.item;
            return true;
        }

        @Override
        public void update() {
            this.field_146125_m = this.bigbook.currentInformation == this.information && this.bigbook.currentTab == this.tab && this.bigbook.currentItem == null && this.bigbook.currPage == this.displayPage;
            this.IsInited = false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class TabButton
    extends GuiButton
    implements IUpdatableButton {
        private final ItemStack icon;
        private final GuiBigBook bigbook;
        private final InformationTab tab;
        private final int displayPage;
        private final BookInformation information;

        public TabButton(GuiBigBook bigbook, int x, int y, BookInformation information, InformationTab tab, int page) {
            super(3, x, y, 96, 16, tab.name);
            this.icon = tab.icon;
            this.bigbook = bigbook;
            this.tab = tab;
            this.displayPage = page;
            this.information = information;
            int offset = 0;
            int amount = 0;
            for (InformationItem item : tab.information) {
                bigbook.field_146292_n.add(new ItemButton(bigbook, x, 52 + offset, information, tab, item, amount / 5));
                if ((offset += 22) >= 110) {
                    offset = 0;
                }
                ++amount;
            }
            offset = 0;
            if (amount % 5 == 0) {
                offset = -1;
            }
            tab.pages = amount / 5 + 1 + offset;
        }

        public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
            if (this.field_146125_m) {
                this.bigbook.field_146296_j.func_180450_b(this.icon, this.field_146128_h, this.field_146129_i - 6);
                this.bigbook.field_146289_q.func_78279_b(this.field_146126_j, this.field_146128_h + 22, this.field_146129_i, 116, 0);
            }
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            boolean flag;
            boolean bl = flag = this.field_146124_l && this.field_146125_m && mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            if (!flag) {
                return false;
            }
            this.bigbook.currentInformation = this.information;
            this.bigbook.currentTab = this.tab;
            if (!this.tab.redirect) {
                this.bigbook.currentItem = null;
            } else {
                this.bigbook.currentItem = this.tab.information.get(0);
            }
            return true;
        }

        @Override
        public void update() {
            this.field_146125_m = this.bigbook.currentInformation == this.information && this.bigbook.currentTab == null && this.bigbook.currPage == this.displayPage;
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class MainButton
    extends GuiButton
    implements IUpdatableButton {
        private final ItemStack icon;
        private final GuiBigBook bigbook;
        private final BookInformation information;
        private final int displayPage;

        public MainButton(GuiBigBook bigbook, int x, int y, BookInformation information, int page) {
            super(3, x, y, 96, 16, information.name);
            this.icon = information.icon;
            this.bigbook = bigbook;
            this.information = information;
            this.displayPage = page;
            int offset = 0;
            int amount = 0;
            for (InformationTab tab : information.tabs) {
                bigbook.field_146292_n.add(new TabButton(bigbook, x, 52 + offset, information, tab, amount / 5));
                if ((offset += 22) >= 110) {
                    offset = 0;
                }
                ++amount;
            }
            offset = 0;
            if (amount % 5 == 0) {
                offset = -1;
            }
            information.pages = amount / 5 + 1 + offset;
        }

        public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
            if (this.field_146125_m) {
                this.bigbook.field_146296_j.func_180450_b(this.icon, this.field_146128_h, this.field_146129_i - 6);
                this.bigbook.field_146289_q.func_78279_b(this.field_146126_j, this.field_146128_h + 22, this.field_146129_i, 116, 0);
            }
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            boolean flag;
            boolean bl = flag = this.field_146124_l && this.field_146125_m && mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            if (!flag) {
                return false;
            }
            this.bigbook.currentInformation = this.information;
            if (!this.information.redirect) {
                this.bigbook.currentTab = null;
            } else {
                this.bigbook.currentTab = this.information.tabs.get(0);
            }
            this.bigbook.currentItem = null;
            return true;
        }

        @Override
        public void update() {
            this.field_146125_m = this.bigbook.currentInformation == null && this.bigbook.currPage == this.displayPage;
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class NextPageButton
    extends GuiButton {
        private final boolean field_146151_o;
        private static final String __OBFID = "CL_00000745";

        public NextPageButton(int p_i46316_1_, int p_i46316_2_, int p_i46316_3_, boolean p_i46316_4_) {
            super(p_i46316_1_, p_i46316_2_, p_i46316_3_, 23, 13, "");
            this.field_146151_o = p_i46316_4_;
        }

        public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
            if (this.field_146125_m) {
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(bookGuiTextures);
                int k = 0;
                int l = 192;
                if (flag) {
                    k += 23;
                }
                if (!this.field_146151_o) {
                    l += 13;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, k, l, 23, 13);
            }
        }
    }
}

