/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.thinkbigcore.items;

import com.superdextor.thinkbigcore.items.IEntityUsable;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCustomBow
extends ItemBow
implements IEntityUsable {
    protected final int drawbackSpeed;
    protected final Item ammo;
    protected final String modelName;
    protected final int zoomDelay;
    protected final float maxZoom;
    protected final double damage;
    protected final float speed;

    public ItemCustomBow(String modelName, int durability, Item ammo, int drawbackSpeed, double damage, float speed, int zoomDelay, float maxZoom) {
        this.field_77777_bU = 1;
        this.func_77656_e(durability);
        this.drawbackSpeed = drawbackSpeed;
        this.ammo = ammo;
        this.modelName = modelName;
        this.zoomDelay = zoomDelay;
        this.maxZoom = maxZoom;
        this.damage = damage;
        this.speed = speed;
    }

    public ItemCustomBow(String modelName) {
        this(modelName, 384, Items.field_151032_g, 0, 1.0, 1.0f, 20, 0.8f);
    }

    public ModelResourceLocation getModel(ItemStack stack, EntityPlayer player, int useRemaining) {
        int i = stack.func_77988_m() - player.func_71052_bv();
        int k = 12 - this.drawbackSpeed;
        int j = 18 - this.drawbackSpeed;
        if (k < 2) {
            k = 2;
        }
        if (j < 4) {
            j = 4;
        }
        if (i >= this.func_77626_a(stack)) {
            return new ModelResourceLocation(this.modelName, "inventory");
        }
        if (i >= j) {
            return new ModelResourceLocation(this.modelName + "_pulling_2", "inventory");
        }
        if (i > k) {
            return new ModelResourceLocation(this.modelName + "_pulling_1", "inventory");
        }
        if (i > 0) {
            return new ModelResourceLocation(this.modelName + "_pulling_0", "inventory");
        }
        return null;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityPlayer playerIn, int timeLeft) {
        boolean flag;
        int j = this.func_77626_a(stack) - timeLeft;
        ArrowLooseEvent event = new ArrowLooseEvent(playerIn, stack, j);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        j = event.charge;
        boolean bl = flag = playerIn.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)stack) > 0;
        if (flag || playerIn.field_71071_by.func_146028_b(this.ammo)) {
            float f = (float)j / (20.0f - (float)this.drawbackSpeed);
            if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
                return;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            EntityArrow entityarrow = new EntityArrow(worldIn, (EntityLivingBase)playerIn, f * (this.speed * 2.0f));
            if (f == 1.0f) {
                entityarrow.func_70243_d(true);
            }
            stack.func_77972_a(1, (EntityLivingBase)playerIn);
            worldIn.func_72956_a((Entity)playerIn, "random.bow", 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            if (flag) {
                entityarrow.field_70251_a = 2;
            } else {
                playerIn.field_71071_by.func_146026_a(this.ammo);
            }
            this.finalizeArrow(entityarrow, stack, worldIn);
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 72000 - this.drawbackSpeed;
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        ArrowNockEvent event = new ArrowNockEvent(playerIn, itemStackIn);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return event.result;
        }
        if (playerIn.field_71075_bZ.field_75098_d || playerIn.field_71071_by.func_146028_b(this.ammo)) {
            playerIn.func_71008_a(itemStackIn, this.func_77626_a(itemStackIn));
        }
        return itemStackIn;
    }

    @Override
    public boolean onRangedAttack(EntityLiving entity, EntityLivingBase target, ItemStack stack, boolean playSFX) {
        World world = entity.field_70170_p;
        EntityArrow entityarrow = new EntityArrow(world, (EntityLivingBase)entity, target, 1.6f, (float)(14 - world.func_175659_aa().func_151525_a() * 4));
        if (playSFX) {
            entity.func_85030_a("random.bow", 1.0f, 1.0f / (entity.func_70681_au().nextFloat() * 0.4f + 0.8f));
        }
        this.finalizeArrow(entityarrow, stack, world);
        return true;
    }

    @Override
    public boolean onMeleeAttack(EntityLiving entity, EntityLivingBase target, ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public String getModelName() {
        return this.modelName;
    }

    @SideOnly(value=Side.CLIENT)
    public int getZoomDelay() {
        return this.zoomDelay;
    }

    @SideOnly(value=Side.CLIENT)
    public float getMaxZoom() {
        return this.maxZoom;
    }

    protected void finalizeArrow(EntityArrow arrow, ItemStack stack, World world) {
        int l;
        int k = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)stack);
        if (k > 0) {
            arrow.func_70239_b(arrow.func_70242_d() + (double)k * 0.5 + 0.5);
        }
        if ((l = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)stack)) > 0) {
            arrow.func_70240_a(l);
        }
        if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)stack) > 0) {
            arrow.func_70015_d(100);
        }
        arrow.func_70239_b(arrow.func_70242_d() * this.damage);
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)arrow);
        }
    }
}

