/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.thinkbigcore.helpers;

import com.superdextor.thinkbigcore.ThinkBigConfig;
import com.superdextor.thinkbigcore.ThinkBigCore;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import org.apache.logging.log4j.LogManager;

public class EntityHelper {
    public static Map classToIDMapping = new HashMap();
    public static final BiomeGenBase[] defaultBiomes = new BiomeGenBase[]{BiomeGenBase.field_76787_r, BiomeGenBase.field_150583_P, BiomeGenBase.field_150582_Q, BiomeGenBase.field_150577_O, BiomeGenBase.field_150584_S, BiomeGenBase.field_150579_T, BiomeGenBase.field_76769_d, BiomeGenBase.field_76786_s, BiomeGenBase.field_76770_e, BiomeGenBase.field_76783_v, BiomeGenBase.field_150580_W, BiomeGenBase.field_76767_f, BiomeGenBase.field_76777_m, BiomeGenBase.field_76775_o, BiomeGenBase.field_76774_n, BiomeGenBase.field_76782_w, BiomeGenBase.field_150574_L, BiomeGenBase.field_76792_x, BiomeGenBase.field_150578_U, BiomeGenBase.field_150581_V, BiomeGenBase.field_150589_Z, BiomeGenBase.field_150608_ab, BiomeGenBase.field_150607_aa, BiomeGenBase.field_76772_c, BiomeGenBase.field_150585_R, BiomeGenBase.field_150588_X, BiomeGenBase.field_150587_Y, BiomeGenBase.field_150576_N, BiomeGenBase.field_76780_h, BiomeGenBase.field_76768_g, BiomeGenBase.field_76784_u};

    public static final void createEntity(Class entityClass, String entityName) {
        EntityHelper.createEntity(entityClass, entityName, null, 0, 0, 0, null, 0, 0);
    }

    public static final void createEntity(Class entityClass, String entityName, EnumCreatureType type, int probability, int minSpawn, int maxSpawn, BiomeGenBase[] biome, int solidColor, int spotColor) {
        int randomId = EntityRegistry.findGlobalUniqueEntityId();
        EntityRegistry.registerGlobalEntityID((Class)entityClass, (String)entityName, (int)randomId);
        EntityRegistry.registerModEntity((Class)entityClass, (String)entityName, (int)randomId, (Object)ThinkBigCore.modInstance, (int)60, (int)1, (boolean)true);
        if (biome != null) {
            EntityRegistry.addSpawn((String)entityName, (int)probability, (int)minSpawn, (int)maxSpawn, (EnumCreatureType)type, (BiomeGenBase[])biome);
        }
        classToIDMapping.put(entityClass, randomId);
        if (solidColor != 0 || spotColor != 0) {
            EntityList.field_75627_a.put(randomId, new EntityList.EntityEggInfo(randomId, solidColor, spotColor));
        }
    }

    public static void initExtraEggs() {
        if (ThinkBigConfig.extraSpawnEggs) {
            EntityHelper.addToEggList(97, 15135474, 15440668);
            EntityHelper.addToEggList(99, 0xD4D9D9, 8420202);
            EntityHelper.addToEggList(53, 44975, 7969893);
            EntityHelper.addToEggList(63, 2956851, 14495203);
            EntityHelper.addToEggList(64, 0x4F4F4F, 0x949494);
        }
    }

    public static void addToEggList(int ID, int solidColor, int spotColor) {
        if (EntityList.field_75627_a.get(ID) == null) {
            EntityList.field_75627_a.put(ID, new EntityList.EntityEggInfo(ID, solidColor, spotColor));
        } else {
            LogManager.getLogger().warn("Tryed to add a Entity that all ready existed! Entity ID == " + ID);
        }
    }
}

