/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.LOT.entity;

import com.superdextor.LOT.LOTAchievements;
import com.superdextor.LOT.LOTConfig;
import com.superdextor.LOT.LOTDamageSource;
import com.superdextor.LOT.items.LOTItems;
import com.superdextor.thinkbigcore.helpers.EffectHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityProjectile
extends EntityThrowable {
    private PotionEffect potionIn = null;
    private float damage = 4.0f;
    private Item droppedItem = null;
    private boolean noKnockback = false;
    private int ticksInGround = 0;

    public EntityProjectile(World worldIn) {
        super(worldIn);
    }

    public EntityProjectile(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityProjectile(World worldIn, EntityLivingBase throwerIn) {
        super(worldIn, throwerIn);
    }

    public EntityProjectile setRock() {
        this.setProjectileType(0);
        this.setDamage(4.0f);
        this.setDroppedItem(LOTItems.rock);
        return this;
    }

    public EntityProjectile setWater() {
        this.setProjectileType(1);
        this.setNoKnockback();
        this.setDamage(2.0f);
        return this;
    }

    public EntityProjectile setFlame() {
        this.setProjectileType(2);
        this.setNoKnockback();
        this.setDamage(5.0f);
        return this;
    }

    public EntityProjectile setInk() {
        this.setProjectileType(3);
        this.setNoKnockback();
        this.setDamage(2.0f);
        return this;
    }

    public EntityProjectile setHeart() {
        this.setProjectileType(4);
        this.setDamage(4.0f);
        return this;
    }

    public EntityProjectile setIronHook(boolean dropItem) {
        this.setProjectileType(5);
        this.setDamage(5.0f);
        if (dropItem) {
            this.setDroppedItem(LOTItems.iron_hook);
        }
        return this;
    }

    public EntityProjectile setDynamite() {
        this.setProjectileType(6);
        this.setDamage(11.0f);
        return this;
    }

    public EntityProjectile setSmokeGrenade() {
        this.setProjectileType(7);
        this.setDamage(0.0f);
        this.setNoKnockback();
        return this;
    }

    public EntityProjectile setShrapnelGrenade() {
        this.setProjectileType(8);
        this.setDamage(0.0f);
        this.setNoKnockback();
        return this;
    }

    public void func_70071_h_() {
        if (!this.field_174854_a) {
            super.func_70071_h_();
        } else if (!this.field_70170_p.field_72995_K) {
            ++this.ticksInGround;
            if (this.ticksInGround > 400) {
                this.func_70106_y();
            }
        }
        switch (this.getProjectileType()) {
            case 1: {
                for (int i = 0; i < 8; ++i) {
                    EffectHelper.spawnParticle((World)this.field_70170_p, (EffectHelper.EnumParticleBook)EffectHelper.EnumParticleBook.WATER_SPLASH, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)0.0, (double)0.0, (double)0.0);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < 8; ++i) {
                    EffectHelper.spawnParticle((World)this.field_70170_p, (EffectHelper.EnumParticleBook)EffectHelper.EnumParticleBook.FLAME, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)0.0, (double)0.0, (double)0.0);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < 8; ++i) {
                    EffectHelper.spawnParticle((World)this.field_70170_p, (EffectHelper.EnumParticleBook)EffectHelper.EnumParticleBook.SMOKE_NORMAL, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)0.0, (double)0.0, (double)0.0);
                }
                break;
            }
            case 4: {
                EffectHelper.spawnParticle((World)this.field_70170_p, (EffectHelper.EnumParticleBook)EffectHelper.EnumParticleBook.VILLAGER_HAPPY, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)0.0, (double)0.0, (double)0.0);
                break;
            }
            case 7: {
                if (this.field_70173_aa % 4 == 0) {
                    EffectHelper.playSoundAtEntity((Entity)this, (EffectHelper.SoundBook)EffectHelper.SoundBook.block_fire_extinguish, (float)0.4f, (float)1.5f);
                }
                for (int x = 0; x < 30; ++x) {
                    EffectHelper.spawnParticle((World)this.field_70170_p, (EffectHelper.EnumParticleBook)EffectHelper.EnumParticleBook.SMOKE_LARGE, (double)this.field_70165_t, (double)(this.field_70163_u + 0.5), (double)this.field_70161_v, (double)((-0.5 + (double)this.field_70146_Z.nextFloat()) * 0.4), (double)((-0.5 + (double)this.field_70146_Z.nextFloat()) * 0.3), (double)((-0.5 + (double)this.field_70146_Z.nextFloat()) * 0.4));
                }
                break;
            }
            case 8: {
                if (this.field_70173_aa % 7 == 0) {
                    EffectHelper.spawnParticle((World)this.field_70170_p, (EffectHelper.EnumParticleBook)EffectHelper.EnumParticleBook.SMOKE_NORMAL, (double)this.field_70165_t, (double)(this.field_70163_u + 0.5), (double)this.field_70161_v, (double)0.0, (double)-0.01, (double)0.0);
                }
                if (this.field_70170_p.field_72995_K || this.field_70173_aa <= 90) break;
                for (int i = 0; i < 10 + this.field_70146_Z.nextInt(6); ++i) {
                    EntityArrow entity = new EntityArrow(this.field_70170_p);
                    entity.func_70107_b(this.field_70165_t + (-0.5 + this.field_70146_Z.nextDouble()), this.field_70163_u + 1.4, this.field_70161_v + (-0.5 + this.field_70146_Z.nextDouble()));
                    entity.field_70250_c = this.func_85052_h();
                    NBTTagCompound data = entity.getEntityData();
                    data.func_74777_a("life", (short)1199);
                    entity.func_70037_a(data);
                    this.field_70170_p.func_72838_d((Entity)entity);
                }
                this.field_70170_p.func_72885_a((Entity)this.func_85052_h(), this.field_70165_t, this.field_70163_u + 1.1, this.field_70161_v, 1.8f, false, LOTConfig.griefing);
                this.func_70106_y();
                break;
            }
        }
    }

    protected void func_70184_a(MovingObjectPosition result) {
        int type = this.getProjectileType();
        this.field_174854_a = true;
        if (result.field_72308_g != null && this.getProjectileType() != 7) {
            Entity entity = result.field_72308_g;
            switch (type) {
                case 1: {
                    if (entity instanceof EntityEnderman || entity instanceof EntityBlaze) {
                        entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.func_85052_h()), this.getDamage() * 2.0f);
                        break;
                    }
                    entity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), this.getDamage());
                    break;
                }
                case 2: {
                    if (entity.func_70045_F()) break;
                    entity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), 0.0f);
                    entity.func_70015_d((int)this.getDamage());
                    entity.func_70097_a(DamageSource.field_76372_a, this.getDamage() * 0.6f);
                    break;
                }
                case 3: {
                    boolean flag = true;
                    if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
                        flag = false;
                    }
                    if (entity instanceof EntityLivingBase && flag) {
                        ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 5, 0));
                        ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 80, 0));
                        ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 88, 0));
                    }
                    entity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), this.getDamage());
                    break;
                }
                case 4: {
                    if (entity == null || !(entity instanceof EntityLivingBase)) break;
                    ((EntityLivingBase)entity).func_70691_i(this.getDamage());
                    EffectHelper.playSoundAtEntity((Entity)this, (EffectHelper.SoundBook)EffectHelper.SoundBook.entity_player_levelup, (float)0.5f, (float)1.0f);
                    if (this.func_85052_h() == null || !(this.func_85052_h() instanceof EntityPlayer) || !(this.func_85052_h().func_110143_aJ() < 1.0f)) break;
                    ((EntityPlayer)this.func_85052_h()).func_71064_a((StatBase)LOTAchievements.lifeSaver, 1);
                    break;
                }
                case 5: {
                    entity.field_70181_x += 0.3 - this.field_70181_x;
                    if (entity.field_70181_x < 0.1) {
                        entity.field_70181_x = 0.1;
                    }
                    if (entity.field_70181_x > 1.1) {
                        entity.field_70181_x = 1.1;
                    }
                    entity.field_70159_w += -this.field_70159_w;
                    entity.field_70179_y += -this.field_70179_y;
                    entity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), this.getDamage());
                    break;
                }
                case 6: {
                    entity.func_70097_a(LOTDamageSource.causeDynamiteDamage((Entity)this, (Entity)this.func_85052_h()), this.getDamage());
                }
                default: {
                    entity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), this.getDamage());
                }
            }
            if (!this.hasKnockback()) {
                entity.field_70133_I = false;
            }
            if (this.getPotionEffect() != null) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(this.getPotionEffect()));
            }
        } else if (!this.field_70170_p.field_72995_K && this.getDroppedItem() != null) {
            this.func_145779_a(this.getDroppedItem(), 1);
        }
        switch (type) {
            case 1: {
                for (int i = 0; i < 8; ++i) {
                    EffectHelper.spawnParticle((World)this.field_70170_p, (EffectHelper.EnumParticleBook)EffectHelper.EnumParticleBook.WATER_SPLASH, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)0.0, (double)0.0, (double)0.0);
                }
                break;
            }
            case 2: {
                EffectHelper.AddLightEffect((World)this.field_70170_p, (int)((int)this.field_70165_t), (int)((int)this.field_70163_u), (int)((int)this.field_70161_v), (int)1);
                EffectHelper.spawnParticle((World)this.field_70170_p, (EffectHelper.EnumParticleBook)EffectHelper.EnumParticleBook.LAVA, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)0.0, (double)0.0, (double)0.0);
                break;
            }
            case 4: {
                EffectHelper.AddLightEffect((World)this.field_70170_p, (int)((int)this.field_70165_t), (int)((int)this.field_70163_u), (int)((int)this.field_70161_v), (int)1);
                break;
            }
            case 6: {
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72885_a((Entity)this.func_85052_h(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.3f, false, LOTConfig.griefing);
                }
                EffectHelper.AddLightEffect((World)this.field_70170_p, (int)((int)this.field_70165_t), (int)((int)this.field_70163_u), (int)((int)this.field_70161_v), (int)1);
                break;
            }
        }
        if (!this.field_70170_p.field_72995_K && this.getProjectileType() != 7 && this.getProjectileType() != 8) {
            this.func_70106_y();
        }
    }

    protected float func_70185_h() {
        return this.getProjectileType() == 4 ? 0.05f : super.func_70185_h();
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(13, (Object)new Byte(0));
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public void setPotionEffect(PotionEffect potionIn) {
        this.potionIn = potionIn;
    }

    public void setDroppedItem(Item droppedItem) {
        this.droppedItem = droppedItem;
    }

    public void setProjectileType(int type) {
        if (type >= 0 && type < 9) {
            this.field_70180_af.func_75692_b(13, (Object)((byte)type));
        }
    }

    public void setNoKnockback() {
        this.noKnockback = true;
    }

    public float getDamage() {
        return this.damage;
    }

    public PotionEffect getPotionEffect() {
        return this.potionIn;
    }

    public Item getDroppedItem() {
        return this.droppedItem;
    }

    public int getProjectileType() {
        return this.field_70180_af.func_75683_a(13);
    }

    public boolean hasKnockback() {
        return !this.noKnockback;
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_150297_b("ProjectileType", 99)) {
            this.setProjectileType(tagCompund.func_74771_c("ProjectileType"));
        }
        if (tagCompund.func_150297_b("Damage", 99)) {
            this.setDamage(tagCompund.func_74771_c("Damage"));
        }
        if (tagCompund.func_150297_b("PotionID", 99) && tagCompund.func_150297_b("PotionDuration", 99) && tagCompund.func_150297_b("PotionAmplifier", 99)) {
            this.setPotionEffect(new PotionEffect((int)tagCompund.func_74771_c("PotionID"), tagCompund.func_74762_e("PotionDuration"), tagCompund.func_74762_e("PotionAmplifier")));
        }
        if (tagCompund.func_150297_b("Item", 99)) {
            this.setDroppedItem(Item.func_150899_d((int)tagCompund.func_74762_e("Item")));
        }
        if (tagCompund.func_150297_b("NoKnockback", 99) && tagCompund.func_74767_n("NoKnockback")) {
            this.setNoKnockback();
        }
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74774_a("ProjectileType", (byte)this.getProjectileType());
        tagCompound.func_74774_a("Damage", (byte)this.getDamage());
        if (this.getPotionEffect() != null) {
            tagCompound.func_74774_a("PotionID", (byte)this.getPotionEffect().func_76456_a());
            tagCompound.func_74768_a("PotionDuration", this.getPotionEffect().func_76459_b());
            tagCompound.func_74768_a("PotionAmplifier", this.getPotionEffect().func_76458_c());
        }
        tagCompound.func_74768_a("Item", Item.func_150891_b((Item)this.getDroppedItem()));
        tagCompound.func_74757_a("NoKnockback", !this.hasKnockback());
    }
}

