/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.LOT.inventory.gui;

import com.superdextor.LOT.network.LOTNetwork;
import com.superdextor.LOT.network.SyncRainbowbowOutputMessage;
import com.superdextor.LOT.rainbowbox.EventID;
import com.superdextor.LOT.rainbowbox.RainbowEvent;
import com.superdextor.LOT.rainbowbox.RainbowMinigame;
import com.superdextor.LOT.rainbowbox.RgameBowNArrow;
import com.superdextor.LOT.rainbowbox.RgameTapThatCreeper;
import com.superdextor.thinkbigcore.ThinkBigConfig;
import com.superdextor.thinkbigcore.helpers.ChatHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiRainbowMinigame
extends GuiScreen {
    public static final ResourceLocation backgroundtextures = new ResourceLocation("lot:textures/gui/minigame.png");
    public final World worldObj;
    public final EntityPlayer thePlayer;
    public final BlockPos selfPosition;
    protected final Random rand;
    public RainbowMinigame minigame;
    public int xSize = 176;
    public int ySize = 166;
    protected int xSideSize = 80;
    protected int ySideSize = 130;
    public final RainbowMinigame[] minigameList = new RainbowMinigame[]{new RgameBowNArrow(this), new RgameTapThatCreeper(this)};
    private final boolean repeatEventdefault;

    public GuiRainbowMinigame(World worldIn, EntityPlayer playerIn, BlockPos posIn, boolean selectGame) {
        this.worldObj = worldIn;
        this.thePlayer = playerIn;
        this.selfPosition = posIn;
        this.rand = playerIn.func_70681_au();
        this.repeatEventdefault = Keyboard.areRepeatEventsEnabled();
        Keyboard.enableRepeatEvents((boolean)true);
        if (!selectGame) {
            if (this.minigameList.length < 1) {
                this.field_146297_k.func_147108_a((GuiScreen)null);
                if (this.field_146297_k.field_71462_r == null) {
                    this.field_146297_k.func_71381_h();
                }
            } else if (this.minigameList.length < 2) {
                this.minigame = this.minigameList[0];
            } else {
                int i = this.rand.nextInt(this.minigameList.length);
                this.minigame = this.minigameList[i];
            }
        }
    }

    public void func_73866_w_() {
        if (this.minigame != null) {
            int i = (this.field_146294_l - this.xSize) / 2;
            int j = (this.field_146295_m - this.ySize) / 2;
            this.minigame.setWorldPos(i + 8, j + 20, 160, 122);
            this.minigame.initButtons(this.field_146292_n);
        }
    }

    public void func_73876_c() {
        if (this.minigame != null) {
            this.minigame.update();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        RenderHelper.func_74520_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(backgroundtextures);
        int mainX = this.getGuiRenderOffset("x");
        int mainY = this.getGuiRenderOffset("y");
        this.func_73729_b(mainX, mainY, 0, 0, this.xSize, this.ySize);
        if (this.minigame != null) {
            int ctrX = (this.field_146294_l - this.xSize) / 2 + (int)((double)this.xSize * 1.1);
            int ctrY = (this.field_146295_m - this.ySideSize) / 2;
            int infoX = (this.field_146294_l - this.xSize) / 2 - (int)((double)this.xSize * 0.6);
            int infoY = (this.field_146295_m - this.ySideSize) / 2;
            this.func_73729_b(ctrX, ctrY, 176, 18, this.xSideSize, this.ySideSize);
            this.func_73729_b(infoX, infoY, 176, 18, this.xSideSize, this.ySideSize);
            this.minigame.drawControlPannel(this.field_146296_j, ctrX, ctrY);
            this.minigame.drawHelpPannel(this.field_146296_j, infoX, infoY);
            this.minigame.draw(this.field_146296_j, mainX, mainY);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_146282_l() throws IOException {
        char c0 = Keyboard.getEventCharacter();
        if (Keyboard.getEventKey() == 0 && c0 >= ' ' || Keyboard.getEventKeyState()) {
            this.func_73869_a(c0, Keyboard.getEventKey());
        }
        this.field_146297_k.func_152348_aa();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1 || keyCode == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.minigame.getResults();
            this.close(this.minigame.luckFromGame);
        }
        if (this.minigame != null && this.minigame.isRunning) {
            this.minigame.actionInput(keyCode, 0);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.minigame != null && this.minigame.isRunning) {
            this.minigame.mouseClicked(mouseX, mouseY, mouseButton);
        }
    }

    public RenderItem getRenderItem() {
        return this.field_146296_j;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public int getGuiRenderOffset(String s) {
        if (s == "y") {
            return (this.field_146295_m - this.ySize) / 2;
        }
        return (this.field_146294_l - this.xSize) / 2;
    }

    public void close(float luck) {
        this.field_146297_k.func_147108_a((GuiScreen)null);
        if (this.field_146297_k.field_71462_r == null) {
            this.field_146297_k.func_71381_h();
        }
        this.triggerOutout(luck);
        Keyboard.enableRepeatEvents((boolean)this.repeatEventdefault);
    }

    private void triggerOutout(float luck) {
        ArrayList<RainbowEvent> list = new ArrayList<RainbowEvent>();
        RainbowEvent mainEvent = RainbowEvent.uselessEvent;
        for (EventID event : RainbowEvent.events) {
            if (event == null) continue;
            boolean flag = false;
            if (event.luck == luck) {
                flag = true;
            } else if (event.luck == luck - 0.1f || this.rand.nextBoolean() && event.luck == luck + 0.1f) {
                flag = true;
            } else if (this.rand.nextBoolean() && event.luck == luck - 0.2f || this.rand.nextFloat() < 0.35f && event.luck == luck + 0.2f) {
                flag = true;
            }
            if (!flag) continue;
            list.add(event.event);
        }
        if (list.size() > 0) {
            int j = this.rand.nextInt(list.size());
            mainEvent = (RainbowEvent)list.get(j);
        }
        if (ThinkBigConfig.debugMode) {
            ChatHelper.printDebugMessage((EntityPlayer)this.thePlayer, (String)("Tryed to trigged an Event from a Luck Value of " + luck));
        }
        LOTNetwork.sendToServer(new SyncRainbowbowOutputMessage(mainEvent.EventID, this.selfPosition));
        this.worldObj.func_175698_g(this.selfPosition);
    }
}

