/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.LOT.items;

import com.superdextor.LOT.LOTSounds;
import com.superdextor.LOT.entity.EntityProjectile;
import com.superdextor.LOT.items.ItemWeapon;
import com.superdextor.LOT.items.LOTItems;
import com.superdextor.LOT.items.WeaponMaterial;
import com.superdextor.thinkbigcore.helpers.EffectHelper;
import com.superdextor.thinkbigcore.utility.SoundEffect;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class ItemSprayer
extends ItemWeapon {
    private final int type;

    public ItemSprayer(WeaponMaterial material, int type) {
        super(material);
        this.type = type;
    }

    @Override
    protected void createBullet(ItemStack stack, EntityPlayer player) {
        World world = player.field_70170_p;
        stack.func_77972_a(1, (EntityLivingBase)player);
        if (this.type == 0) {
            EntityProjectile ink = new EntityProjectile(world, (EntityLivingBase)player).setInk();
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)ink);
            }
            player.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 15, 1));
        } else if (this.type == 1) {
            EntityProjectile flame = new EntityProjectile(world, (EntityLivingBase)player).setFlame();
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)flame);
            }
            player.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 15, 2));
        } else {
            EntityProjectile water = new EntityProjectile(world, (EntityLivingBase)player).setWater();
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)water);
            }
        }
    }

    @Override
    protected Item getAmmo() {
        return this.type == 0 ? LOTItems.ink_tank : (this.type == 1 ? LOTItems.flamethrower_tank : LOTItems.watergun_bottle);
    }

    @Override
    protected SoundEffect getReloadSound() {
        return LOTSounds.weapon_minigun_reload;
    }

    @Override
    protected SoundEffect getShootSound() {
        return this.type == 0 ? new SoundEffect(EffectHelper.SoundBook.block_fire_extinguish) : (this.type == 1 ? new SoundEffect(EffectHelper.SoundBook.entity_blaze_shoot) : new SoundEffect(EffectHelper.SoundBook.block_water_ambient));
    }

    @Override
    public String getBonus() {
        return this.type == 0 ? "Blind your Enemies" : (this.type == 1 ? "Toast your Enemies" : "Extra Damage dealt to Endermen, Blazes");
    }

    @Override
    protected boolean hasFlash() {
        return this.type == 1;
    }
}

