/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.LOT.items;

import com.superdextor.LOT.LOTAchievements;
import com.superdextor.LOT.LOTMessages;
import com.superdextor.LOT.entity.EntityBullet;
import com.superdextor.LOT.items.ItemCooldown;
import com.superdextor.LOT.items.WeaponMaterial;
import com.superdextor.thinkbigcore.helpers.ChatHelper;
import com.superdextor.thinkbigcore.helpers.EffectHelper;
import com.superdextor.thinkbigcore.helpers.InventoryHelper;
import com.superdextor.thinkbigcore.utility.SoundEffect;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.world.World;

public class ItemWeapon
extends ItemCooldown {
    public final WeaponMaterial material;

    public ItemWeapon(WeaponMaterial materialIn) {
        this.material = materialIn;
        this.field_77777_bU = 1;
        this.func_77656_e(materialIn.capacity);
        this.func_77664_n();
        this.setNoRepair();
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        if ((this.getAction() == WeaponMaterial.FireAction.DEFAULT || this.getAction() == WeaponMaterial.FireAction.SIMIFIRE) && this.IsItemUsable(itemStackIn, playerIn)) {
            playerIn.func_71008_a(itemStackIn, this.func_77626_a(itemStackIn));
        } else if (this.getAction() == WeaponMaterial.FireAction.HOLD) {
            this.UseWeapon(itemStackIn, playerIn);
        }
        return itemStackIn;
    }

    public boolean onDroppedByPlayer(ItemStack stack, EntityPlayer player) {
        if (this.getAction() == WeaponMaterial.FireAction.DEFAULT) {
            this.UseWeapon(stack, player);
            return false;
        }
        return true;
    }

    @Override
    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.field_72995_K && isSelected) {
            if (this.getAction() == WeaponMaterial.FireAction.SIMIFIRE && entityIn instanceof EntityPlayer && ((EntityPlayer)entityIn).func_71052_bv() > 0) {
                this.UseWeapon(stack, (EntityPlayer)entityIn);
            }
            if (stack.func_77978_p() == null) {
                stack.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound nbt = stack.func_77978_p();
            if (stack.func_77978_p().func_74764_b("cooldown")) {
                int cooldownIn = nbt.func_74762_e("cooldown");
                if (cooldownIn > 0) {
                    nbt.func_74768_a("cooldown", cooldownIn - 1);
                }
                if (cooldownIn == 5) {
                    if (this.getDamage(stack) >= this.func_77612_l()) {
                        if (this.getReloadSound() != null) {
                            EffectHelper.playSoundAtEntity((Entity)entityIn, (SoundEffect)this.getReloadSound(), (float)this.getVolume(2), (float)this.getPitch(2));
                        }
                    } else if (this.getCockbackSound() != null) {
                        EffectHelper.playSoundAtEntity((Entity)entityIn, (SoundEffect)this.getCockbackSound(), (float)this.getVolume(1), (float)this.getPitch(1));
                    }
                }
            }
        }
    }

    public void ShotWeapon(ItemStack stack, EntityPlayer player) {
        World world = player.field_70170_p;
        boolean flag = player.field_71075_bZ.field_75098_d;
        stack.func_77972_a(1, (EntityLivingBase)player);
        if (!flag) {
            this.SetCooldownIn(stack, this.getShotDelay());
        }
        EffectHelper.playSoundAtEntity((Entity)player, (SoundEffect)this.getShootSound(), (float)this.getVolume(0), (float)this.getPitch(0));
        if (!world.field_72995_K) {
            this.createBullet(stack, player);
        }
        if (this.hasFlash()) {
            EffectHelper.AddLightEffect((World)world, (int)((int)player.field_70165_t), (int)((int)(player.field_70163_u + 1.0)), (int)((int)player.field_70161_v), (int)2);
        }
    }

    protected void createBullet(ItemStack stack, EntityPlayer player) {
        World world = player.field_70170_p;
        EntityBullet bullet = new EntityBullet(world, (EntityLivingBase)player, 2.4f, this.getDamage());
        int l = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)stack);
        if (l > 0) {
            bullet.func_70239_b(bullet.func_70242_d() + (double)l * 0.5 + 0.5);
        }
        if ((l = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)stack)) > 0) {
            bullet.func_70240_a(l);
        }
        if ((l = EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)stack)) > 0) {
            bullet.func_70015_d(100);
        }
        world.func_72838_d((Entity)bullet);
    }

    public void UseWeapon(ItemStack stack, EntityPlayer player) {
        World world = player.field_70170_p;
        boolean flag = player.field_71075_bZ.field_75098_d;
        if (this.IsItemUsable(stack, player)) {
            if (this.getDamage(stack) < this.func_77612_l()) {
                this.ShotWeapon(stack, player);
            } else {
                ItemStack ammo = InventoryHelper.hasItem((InventoryPlayer)player.field_71071_by, (Item)this.getAmmo());
                if (flag || ammo != null) {
                    if (!flag) {
                        --ammo.field_77994_a;
                        if (ammo.field_77994_a == 0) {
                            ammo = null;
                        }
                    }
                    this.setDamage(stack, 0);
                    if (!flag) {
                        this.SetCooldownIn(stack, this.getReloadDelay());
                    }
                } else if (!flag) {
                    this.SetCooldownIn(stack, 4);
                }
                EffectHelper.playSoundAtEntity((Entity)player, (EffectHelper.SoundBook)EffectHelper.SoundBook.block_lever_click, (float)1.0f, (float)1.0f);
            }
        } else {
            player.func_71034_by();
            EffectHelper.playSoundAtEntity((Entity)player, (EffectHelper.SoundBook)EffectHelper.SoundBook.block_lever_click, (float)1.0f, (float)1.0f);
            LOTMessages.CooldownMessage((EntityLivingBase)player, this.func_77658_a().substring(5).toUpperCase(), this.getCooldownIn(stack));
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List tooltip, boolean advanced) {
        tooltip.add(" ");
        if (this.getAction() == WeaponMaterial.FireAction.DEFAULT) {
            tooltip.add(ChatHelper.ColorBook.BLUE + "Press 'drop-key' to Fire");
            tooltip.add(ChatHelper.ColorBook.BLUE + "Right Click to Scope");
        } else {
            tooltip.add(ChatHelper.ColorBook.BLUE + "Right Click to Fire");
        }
        tooltip.add(" ");
        if (this.getShotDelay() > 0) {
            tooltip.add(ChatHelper.ColorBook.BLUE.toString() + this.getShotDelay() / 10 + " Attack Speed");
        }
        tooltip.add(ChatHelper.ColorBook.BLUE + "Maximum Ammo " + this.func_77612_l());
        if (this.getAmmo() != null) {
            tooltip.add(ChatHelper.ColorBook.BLUE + "Reload Item " + this.getAmmo().func_77653_i(new ItemStack(this.getAmmo())));
        }
        if (this.getBonus() != null) {
            tooltip.add(ChatHelper.ColorBook.BLUE + "Bonus: " + this.getBonus());
        }
        if (this.getDamage() > 0.0f) {
            tooltip.add(ChatHelper.ColorBook.BLUE + "+" + (int)this.getDamage() + " Weapon Damage");
        }
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        playerIn.func_71064_a((StatBase)LOTAchievements.guns, 1);
    }

    public float getZoom() {
        return this.material.zoom;
    }

    protected float getVolume(int operation) {
        return 1.0f;
    }

    protected float getPitch(int operation) {
        return 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + 0.5f;
    }

    protected WeaponMaterial.FireAction getAction() {
        return this.material.action;
    }

    protected SoundEffect getShootSound() {
        return this.material.shootSound;
    }

    protected SoundEffect getCockbackSound() {
        return this.material.cockbackSound;
    }

    protected SoundEffect getReloadSound() {
        return this.material.reloadSound;
    }

    protected boolean hasFlash() {
        return this.material.weaponFlash;
    }

    protected int getShotDelay() {
        return this.material.shotDelay;
    }

    protected int getReloadDelay() {
        return this.material.reloadTime;
    }

    protected float getDamage() {
        return this.material.damage;
    }

    protected Item getAmmo() {
        return this.material.ammo;
    }

    protected String getBonus() {
        return this.material.bonusEffect;
    }
}

