/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.LOT.proxy;

import com.superdextor.LOT.blocks.LOTBlocks;
import com.superdextor.LOT.entity.EntityBullet;
import com.superdextor.LOT.entity.EntityCoalGolem;
import com.superdextor.LOT.entity.EntityDiamondGolem;
import com.superdextor.LOT.entity.EntityEmeraldGolem;
import com.superdextor.LOT.entity.EntityGoldGolem;
import com.superdextor.LOT.entity.EntityLapisGolem;
import com.superdextor.LOT.entity.EntityProjectile;
import com.superdextor.LOT.entity.EntityRedstoneGolem;
import com.superdextor.LOT.entity.EntityZombieSkeleton;
import com.superdextor.LOT.items.ItemNeedle;
import com.superdextor.LOT.items.ItemSoda;
import com.superdextor.LOT.items.LOTItems;
import com.superdextor.LOT.proxy.CommonProxy;
import com.superdextor.LOT.render.RenderBullet;
import com.superdextor.LOT.render.RenderCoalGolem;
import com.superdextor.LOT.render.RenderDiamondGolem;
import com.superdextor.LOT.render.RenderEmeraldGolem;
import com.superdextor.LOT.render.RenderGoldGolem;
import com.superdextor.LOT.render.RenderLapisGolem;
import com.superdextor.LOT.render.RenderProjectile;
import com.superdextor.LOT.render.RenderRedstoneGolem;
import com.superdextor.LOT.render.RenderZombieSkeleton;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit() {
        RenderingRegistry.registerEntityRenderingHandler(EntityBullet.class, (IRenderFactory)new BulletRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityDiamondGolem.class, (IRenderFactory)new DiamondGolemRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityEmeraldGolem.class, (IRenderFactory)new EmeraldGolemRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityGoldGolem.class, (IRenderFactory)new GoldGolemRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityLapisGolem.class, (IRenderFactory)new LapisGolemRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityRedstoneGolem.class, (IRenderFactory)new RedstoneGolemRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityCoalGolem.class, (IRenderFactory)new CoalGolemRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityProjectile.class, (IRenderFactory)new ProjectileRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityZombieSkeleton.class, (IRenderFactory)new ZombieSkeletonRenderer());
    }

    @Override
    public void Init() {
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        this.registerNeedleModels();
        this.registerSodaModels();
        this.registerAnvilModels();
    }

    @Override
    public EntityPlayer getPlayerEntity(MessageContext ctx) {
        return ctx.side.isClient() ? Minecraft.func_71410_x().field_71439_g : super.getPlayerEntity(ctx);
    }

    private void registerNeedleModels() {
        ItemNeedle.Type[] typeList = ItemNeedle.Type.values();
        int i = typeList.length;
        ResourceLocation[] needleTypes = new ResourceLocation[i];
        ResourceLocation[] antidoteTypes = new ResourceLocation[i];
        for (int j = 0; j < i; ++j) {
            ItemNeedle.Type type = typeList[j];
            needleTypes[j] = new ResourceLocation("lot", type.getUnlocalizedName() + "_needle");
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(LOTItems.fullneedle, type.getMetadata(), new ModelResourceLocation("lot:" + type.getUnlocalizedName() + "_needle", "inventory"));
            antidoteTypes[j] = new ResourceLocation("lot", type.getUnlocalizedName() + "_antidote");
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(LOTItems.antidote, type.getMetadata(), new ModelResourceLocation("lot:" + type.getUnlocalizedName() + "_antidote", "inventory"));
        }
        ModelBakery.registerItemVariants((Item)LOTItems.fullneedle, (ResourceLocation[])needleTypes);
        ModelBakery.registerItemVariants((Item)LOTItems.antidote, (ResourceLocation[])antidoteTypes);
    }

    private void registerSodaModels() {
        ItemSoda.Type[] typeList = ItemSoda.Type.values();
        int i = typeList.length;
        ResourceLocation[] sodaTypes = new ResourceLocation[i];
        for (int j = 0; j < i; ++j) {
            ItemSoda.Type type = typeList[j];
            sodaTypes[j] = new ResourceLocation("lot", type.getUnlocalizedName() + "_soda");
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(LOTItems.soda, type.getMetadata(), new ModelResourceLocation("lot:" + type.getUnlocalizedName() + "_soda", "inventory"));
        }
        ModelBakery.registerItemVariants((Item)LOTItems.soda, (ResourceLocation[])sodaTypes);
    }

    private void registerAnvilModels() {
        ResourceLocation[] goldAnvilTypes = new ResourceLocation[3];
        ResourceLocation[] obsidianAnvilTypes = new ResourceLocation[3];
        String[] types = new String[]{"intact", "slightly_damaged", "very_damaged"};
        for (int j = 0; j < 3; ++j) {
            goldAnvilTypes[j] = new ResourceLocation("lot", "golden_anvil_" + types[j]);
            obsidianAnvilTypes[j] = new ResourceLocation("lot", "obsidian_anvil_" + types[j]);
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(Item.func_150898_a((Block)LOTBlocks.golden_anvil), j, new ModelResourceLocation("lot:golden_anvil_" + types[j], "inventory"));
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(Item.func_150898_a((Block)LOTBlocks.obsidian_anvil), j, new ModelResourceLocation("lot:obsidian_anvil_" + types[j], "inventory"));
        }
        ModelBakery.registerItemVariants((Item)Item.func_150898_a((Block)LOTBlocks.golden_anvil), (ResourceLocation[])goldAnvilTypes);
        ModelBakery.registerItemVariants((Item)Item.func_150898_a((Block)LOTBlocks.obsidian_anvil), (ResourceLocation[])obsidianAnvilTypes);
    }

    private class ZombieSkeletonRenderer
    implements IRenderFactory<EntityZombieSkeleton> {
        private ZombieSkeletonRenderer() {
        }

        public Render createRenderFor(RenderManager manager) {
            return new RenderZombieSkeleton(manager);
        }
    }

    private class ProjectileRenderer
    implements IRenderFactory<EntityProjectile> {
        private ProjectileRenderer() {
        }

        public Render createRenderFor(RenderManager manager) {
            RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
            return new RenderProjectile(manager, renderItem);
        }
    }

    private class BulletRenderer
    implements IRenderFactory<EntityBullet> {
        private BulletRenderer() {
        }

        public Render createRenderFor(RenderManager manager) {
            return new RenderBullet(manager);
        }
    }

    private class CoalGolemRenderer
    implements IRenderFactory<EntityCoalGolem> {
        private CoalGolemRenderer() {
        }

        public Render createRenderFor(RenderManager manager) {
            return new RenderCoalGolem(manager);
        }
    }

    private class RedstoneGolemRenderer
    implements IRenderFactory<EntityRedstoneGolem> {
        private RedstoneGolemRenderer() {
        }

        public Render createRenderFor(RenderManager manager) {
            return new RenderRedstoneGolem(manager);
        }
    }

    private class LapisGolemRenderer
    implements IRenderFactory<EntityLapisGolem> {
        private LapisGolemRenderer() {
        }

        public Render createRenderFor(RenderManager manager) {
            return new RenderLapisGolem(manager);
        }
    }

    private class GoldGolemRenderer
    implements IRenderFactory<EntityGoldGolem> {
        private GoldGolemRenderer() {
        }

        public Render createRenderFor(RenderManager manager) {
            return new RenderGoldGolem(manager);
        }
    }

    private class EmeraldGolemRenderer
    implements IRenderFactory<EntityEmeraldGolem> {
        private EmeraldGolemRenderer() {
        }

        public Render createRenderFor(RenderManager manager) {
            return new RenderEmeraldGolem(manager);
        }
    }

    private class DiamondGolemRenderer
    implements IRenderFactory<EntityDiamondGolem> {
        private DiamondGolemRenderer() {
        }

        public Render createRenderFor(RenderManager manager) {
            return new RenderDiamondGolem(manager);
        }
    }
}

