/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.LOT.rainbowbox;

import com.superdextor.LOT.LOTConfig;
import com.superdextor.LOT.blocks.LOTBlocks;
import com.superdextor.LOT.enchantments.LOTEnchantments;
import com.superdextor.LOT.entity.EntityBullet;
import com.superdextor.LOT.entity.EntityCoalGolem;
import com.superdextor.LOT.entity.EntityDiamondGolem;
import com.superdextor.LOT.entity.EntityEmeraldGolem;
import com.superdextor.LOT.entity.EntityGoldGolem;
import com.superdextor.LOT.entity.EntityLapisGolem;
import com.superdextor.LOT.entity.EntityRedstoneGolem;
import com.superdextor.LOT.entity.EntityZombieSkeleton;
import com.superdextor.LOT.items.LOTItems;
import com.superdextor.LOT.rainbowbox.EventID;
import com.superdextor.LOT.worldgen.CreateAnvilTrap;
import com.superdextor.LOT.worldgen.CreateLavaTrap;
import com.superdextor.LOT.worldgen.CreateRainbowTemple;
import com.superdextor.LOT.worldgen.CreateRandChest;
import com.superdextor.thinkbigcore.helpers.ChatHelper;
import com.superdextor.thinkbigcore.helpers.EffectHelper;
import com.superdextor.thinkbigcore.utility.SoundEffect;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class RainbowEvent {
    public int EventID;
    protected Event event;
    protected ItemStack[] items = new ItemStack[10];
    protected Integer[] minItem = new Integer[10];
    protected Integer[] maxItem = new Integer[10];
    protected Class[] entitys = new Class[10];
    protected Random rand = new Random();
    protected SoundEffect soundEffect;
    protected WorldGenerator build;
    protected boolean triggerAtPlayer = false;
    private static int nextId;
    public static final ArrayList<EventID> events;
    public static final RainbowEvent uselessEvent;
    public static final RainbowEvent spongeEvent;
    public static final RainbowEvent sockEvent;
    public static final RainbowEvent bucketEvent;
    public static final RainbowEvent giantEvent;
    public static final RainbowEvent rainbowMenEvent;
    public static final RainbowEvent chickenEvent;
    public static final RainbowEvent torchEvent;
    public static final RainbowEvent rocketEvent;
    public static final RainbowEvent henryEvent;
    public static final RainbowEvent lavaEvent;
    public static final RainbowEvent explosivesEvent;
    public static final RainbowEvent materialEvent;
    public static final RainbowEvent lapisEvent;
    public static final RainbowEvent dustEvent;
    public static final RainbowEvent stoneEvent;
    public static final RainbowEvent watergunEvent;
    public static final RainbowEvent weaponEvent;
    public static final RainbowEvent foodEvent;
    public static final RainbowEvent food2Event;
    public static final RainbowEvent medicEvent;
    public static final RainbowEvent sunglassesEvent;
    public static final RainbowEvent golemEvent;
    public static final RainbowEvent rainbowTempleEvent;
    public static final RainbowEvent chestEvent;
    public static final RainbowEvent EnchEvent;
    public static final RainbowEvent hammerEvent;
    public static final RainbowEvent anvilEvent;

    public RainbowEvent(Event type) {
        this.EventID = nextId++;
        this.event = type;
    }

    public static void register() {
        RainbowEvent.register(uselessEvent, 0.3f);
        RainbowEvent.register(spongeEvent, 0.4f);
        RainbowEvent.register(sockEvent, 0.3f);
        RainbowEvent.register(bucketEvent, 0.4f);
        RainbowEvent.register(giantEvent, 0.0f);
        RainbowEvent.register(rainbowMenEvent, 0.1f);
        RainbowEvent.register(chickenEvent, 0.2f);
        RainbowEvent.register(torchEvent, 0.2f);
        RainbowEvent.register(rocketEvent, 0.0f);
        RainbowEvent.register(henryEvent, 0.1f);
        RainbowEvent.register(lavaEvent, 0.2f);
        RainbowEvent.register(explosivesEvent, 0.6f);
        RainbowEvent.register(materialEvent, 0.9f);
        RainbowEvent.register(lapisEvent, 0.7f);
        RainbowEvent.register(dustEvent, 0.5f);
        RainbowEvent.register(stoneEvent, 0.5f);
        RainbowEvent.register(watergunEvent, 0.6f);
        RainbowEvent.register(weaponEvent, 0.8f);
        RainbowEvent.register(foodEvent, 0.5f);
        RainbowEvent.register(food2Event, 0.6f);
        RainbowEvent.register(medicEvent, 0.7f);
        RainbowEvent.register(sunglassesEvent, 0.3f);
        RainbowEvent.register(chestEvent, 0.7f);
        RainbowEvent.register(EnchEvent, 0.9f);
        RainbowEvent.register(hammerEvent, 0.7f);
        RainbowEvent.register(anvilEvent, 0.3f);
        ChatHelper.printDebugMessage(null, (String)"LOT successfully loaded all RainbowEvents");
    }

    private static void register(RainbowEvent e, float luck) {
        events.add(new EventID(e, e.EventID, luck));
    }

    public Event getEvent() {
        return this.event;
    }

    public static RainbowEvent getEventByID(int id) {
        for (EventID event : events) {
            if (event.id != id) continue;
            return event.event;
        }
        return null;
    }

    public RainbowEvent setItem(Item itemIn, int min, int max) {
        this.setItems(new ItemStack(itemIn), min, max);
        return this;
    }

    public RainbowEvent setItems(ItemStack stack, int min, int max) {
        int j = this.items.length;
        for (int k = 0; j > k; ++k) {
            if (this.items[k] != null) continue;
            this.items[k] = stack;
            this.minItem[k] = min;
            this.maxItem[k] = max;
            return this;
        }
        return this;
    }

    public RainbowEvent setTriggerAtPlayer() {
        this.triggerAtPlayer = true;
        return this;
    }

    public RainbowEvent setEntity(Class entity, int min, int max) {
        int j = this.items.length;
        for (int k = 0; j > k; ++k) {
            if (this.entitys[k] != null) continue;
            this.entitys[k] = entity;
            this.minItem[k] = min;
            this.maxItem[k] = max;
            return this;
        }
        return this;
    }

    public Entity customizeEntity(Entity entity) {
        return entity;
    }

    public ItemStack CustmizeItem(ItemStack stack, int ID) {
        return stack;
    }

    public final RainbowEvent TriggerEvent(World worldIn, BlockPos posIn, EntityLivingBase breaker) {
        BlockPos pos;
        BlockPos blockPos = pos = this.triggerAtPlayer ? new BlockPos(breaker.field_70165_t, breaker.field_70163_u, breaker.field_70161_v) : posIn;
        if (this.soundEffect != null) {
            EffectHelper.playSound((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (SoundEffect)this.soundEffect, (float)1.0f, (float)1.0f);
        }
        if (LOTConfig.rainbowBoxMode > 0) {
            if (this.event == Event.ITEM) {
                this.ItemEvent(worldIn, pos, breaker);
            } else if (this.event == Event.MOB) {
                this.MobEvent(worldIn, pos, breaker);
            } else if (this.event == Event.BUILD) {
                this.BuildEvent(worldIn, pos, breaker);
            } else {
                this.CustomEvent(worldIn, pos, breaker);
            }
        }
        return this;
    }

    public EntityItem DropItem(ItemStack itemStackIn, World world, BlockPos pos) {
        if (itemStackIn.field_77994_a != 0 && itemStackIn.func_77973_b() != null) {
            EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), itemStackIn);
            entityitem.func_174867_a(30);
            world.func_72838_d((Entity)entityitem);
            return entityitem;
        }
        return null;
    }

    public Entity spawnCreature(World worldIn, String entityID, double x, double y, double z, int number) {
        Entity entity = EntityList.func_75620_a((String)entityID, (World)worldIn);
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            entityliving.field_70759_as = entityliving.field_70177_z;
            entityliving.field_70761_aq = entityliving.field_70177_z;
            entityliving.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)entityliving)), (IEntityLivingData)null);
            entityliving.func_70642_aH();
        }
        entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        worldIn.func_72838_d(this.customizeEntity(entity));
        return entity;
    }

    public RainbowEvent setEventSound(SoundEffect sound) {
        this.soundEffect = sound;
        return this;
    }

    public RainbowEvent setBuild(WorldGenerator creation) {
        this.build = creation;
        return this;
    }

    protected void ItemEvent(World worldIn, BlockPos pos, EntityLivingBase breaker) {
        int size = this.items.length;
        for (int k = 0; k < size; ++k) {
            ItemStack stackIn = this.items[k];
            if (stackIn == null) continue;
            int i = this.maxItem[k];
            int amount = 0;
            amount = i > 0 ? this.minItem[k] + this.rand.nextInt(i) : 1;
            for (int j = 0; amount > j; ++j) {
                this.DropItem(this.CustmizeItem(stackIn.func_77946_l(), k), worldIn, pos);
            }
        }
    }

    protected void MobEvent(World worldIn, BlockPos pos, EntityLivingBase breaker) {
        int size = this.entitys.length;
        for (int k = 0; k < size; ++k) {
            Class entityIn = this.entitys[k];
            if (entityIn == null) continue;
            int i = this.maxItem[k];
            int amount = 0;
            amount = i > 0 ? this.minItem[k] + this.rand.nextInt(i) : 1;
            for (int j = 0; amount > j; ++j) {
                this.spawnCreature(worldIn, (String)EntityList.field_75626_c.get(entityIn), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), j);
            }
        }
    }

    protected void BuildEvent(World worldIn, BlockPos pos, EntityLivingBase breaker) {
        if (LOTConfig.rainbowBoxMode > 1 && !worldIn.field_72995_K) {
            this.build.func_180709_b(worldIn, this.rand, pos);
        }
    }

    protected void CustomEvent(World worldIn, BlockPos pos, EntityLivingBase breaker) {
    }

    static {
        events = new ArrayList();
        uselessEvent = new RainbowEvent(Event.ITEM).setItem(Items.field_151055_y, 1, 0).setItem(LOTItems.wooden_helmet, 0, 2).setItem(LOTItems.wooden_chestplate, 0, 2).setItem(LOTItems.wooden_leggings, 0, 2).setItem(LOTItems.wooden_boots, 0, 2);
        spongeEvent = new RainbowEvent(Event.ITEM).setItems(new ItemStack(Blocks.field_150360_v), 1, 0);
        sockEvent = new RainbowEvent(Event.ITEM).setItems(new ItemStack(LOTItems.socks, 1, 47).func_151001_c("Old Socks"), 1, 0);
        bucketEvent = new RainbowEvent(Event.ITEM).setItem(LOTItems.copper_bucket, 2, 4).setItem(LOTItems.copper_water_bucket, 1, 2);
        giantEvent = new RainbowEvent(Event.MOB).setEntity(EntityGiantZombie.class, 1, 0);
        rainbowMenEvent = new RainbowEvent(Event.MOB){

            @Override
            public Entity customizeEntity(Entity entity) {
                ItemStack hand = new ItemStack(LOTItems.rainbow_dust);
                ItemStack feet = new ItemStack(LOTItems.lapis_boots);
                ItemStack leggs = new ItemStack(LOTItems.emerald_leggings);
                ItemStack body = new ItemStack((Item)Items.field_151171_ah);
                ItemStack head = new ItemStack(LOTBlocks.rainbox);
                hand.func_77966_a(Enchantment.field_180314_l, 3);
                hand.func_77966_a(LOTEnchantments.EnchantmentToxic, 1);
                feet.func_77966_a(Enchantment.field_180310_c, 1);
                leggs.func_77966_a(Enchantment.field_180310_c, 1);
                body.func_77966_a(Enchantment.field_180310_c, 1);
                head.func_77966_a(Enchantment.field_180310_c, 1);
                String name = ChatHelper.ColorBook.RED + "R" + ChatHelper.ColorBook.GOLD + "a" + ChatHelper.ColorBook.YELLOW + "i" + ChatHelper.ColorBook.GREEN + "n" + ChatHelper.ColorBook.BLUE + "b" + ChatHelper.ColorBook.DARK_PURPLE + "o" + ChatHelper.ColorBook.DARK_RED + "w" + ChatHelper.ColorBook.RED + "M" + ChatHelper.ColorBook.GOLD + "a" + ChatHelper.ColorBook.YELLOW + "n";
                entity.func_70062_b(0, hand);
                entity.func_70062_b(1, feet);
                entity.func_70062_b(2, leggs);
                entity.func_70062_b(3, body);
                entity.func_70062_b(4, head);
                entity.func_96094_a(name);
                return entity;
            }
        }.setEntity(EntityZombieSkeleton.class, 5, 5);
        chickenEvent = new RainbowEvent(Event.MOB){

            @Override
            public Entity customizeEntity(Entity entity) {
                ItemStack body = new ItemStack((Item)Items.field_151027_R);
                body.func_77966_a(Enchantment.field_92091_k, 100);
                entity.func_70062_b(3, body);
                ((EntityLiving)entity).func_96120_a(3, 0.0f);
                String name = "Sir Clucks";
                switch (this.rand.nextInt(4)) {
                    case 0: {
                        name = "KFC";
                        break;
                    }
                    case 1: {
                        name = "Smexy Chick'";
                        break;
                    }
                    case 2: {
                        name = "Eat Me";
                    }
                }
                entity.func_96094_a(name);
                return entity;
            }
        }.setEntity(EntityChicken.class, 1, 0);
        torchEvent = new RainbowEvent(Event.ITEM).setItems(new ItemStack(LOTBlocks.torch_off), 3, 6).setItems(new ItemStack(Blocks.field_150478_aa), 1, 3);
        rocketEvent = new RainbowEvent(Event.MOB){

            @Override
            public Entity customizeEntity(Entity entity) {
                if (entity instanceof EntityBullet) {
                    EntityBullet entitybullet = (EntityBullet)entity;
                    entitybullet.func_70243_d(true);
                    entitybullet.isExplosive = true;
                    entitybullet.explosivepower = 3 + this.rand.nextInt(3);
                    entitybullet.weight = 0.1;
                }
                return entity;
            }

            @Override
            public Entity spawnCreature(World worldIn, String entityID, double x, double y, double z, int number) {
                Entity entity = EntityList.func_75620_a((String)entityID, (World)worldIn);
                int offsetY = number * 10 + this.rand.nextInt(13);
                entity.func_70012_b(x, y + (double)offsetY + 15.0, z, MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                worldIn.func_72838_d(this.customizeEntity(entity));
                return entity;
            }
        }.setTriggerAtPlayer().setEntity(EntityBullet.class, 4, 8);
        henryEvent = new RainbowEvent(Event.MOB){

            @Override
            public Entity customizeEntity(Entity entity) {
                ItemStack hand = new ItemStack(LOTItems.ruby_sword);
                ItemStack feet = new ItemStack(LOTItems.ruby_boots);
                ItemStack leggs = new ItemStack(LOTItems.ruby_leggings);
                ItemStack body = new ItemStack(LOTItems.ruby_chestplate);
                ItemStack head = new ItemStack(LOTItems.ruby_helmet);
                hand.func_77966_a(LOTEnchantments.EnchantmentToxic, 1);
                feet.func_77966_a(Enchantment.field_180310_c, 1);
                leggs.func_77966_a(Enchantment.field_180310_c, 1);
                body.func_77966_a(Enchantment.field_180310_c, 1);
                head.func_77966_a(Enchantment.field_180310_c, 1);
                entity.func_70062_b(0, hand);
                entity.func_70062_b(1, feet);
                entity.func_70062_b(2, leggs);
                entity.func_70062_b(3, body);
                entity.func_70062_b(4, head);
                entity.func_96094_a("" + ChatHelper.ColorBook.RED + ChatHelper.ColorBook.BOLD + "Henry");
                return entity;
            }
        }.setEntity(EntityZombie.class, 1, 0);
        lavaEvent = new RainbowEvent(Event.BUILD).setBuild(new CreateLavaTrap());
        explosivesEvent = new RainbowEvent(Event.ITEM).setItem(LOTItems.dynamite, 3, 8).setItem(LOTItems.shrapnel_grenade, 2, 5).setItem(LOTItems.smoke_grenade, 2, 6);
        materialEvent = new RainbowEvent(Event.ITEM).setItem(Items.field_151042_j, 6, 7).setItem(Items.field_151043_k, 5, 7).setItem(Items.field_151166_bC, 4, 6).setItem(Items.field_151045_i, 3, 5).setItem(LOTItems.copper_ingot, 7, 13).setItem(LOTItems.ruby, 0, 2);
        lapisEvent = new RainbowEvent(Event.ITEM).setItem(LOTItems.lapis_helmet, 1, 0).setItem(LOTItems.lapis_chestplate, 0, 2).setItem(LOTItems.lapis_leggings, 0, 2).setItem(LOTItems.lapis_boots, 0, 2).setItem(LOTItems.lapis_sword, 1, 0).setItem(LOTItems.lapis_axe, 0, 2).setItem(LOTItems.lapis_pickaxe, 1, 0).setItem(LOTItems.lapis_shovel, 0, 2).setItems(new ItemStack(Items.field_151100_aR, 1, 4), 5, 13).setItems(new ItemStack(LOTBlocks.lapis_torch), 0, 6);
        dustEvent = new RainbowEvent(Event.ITEM).setItem(LOTItems.rainbow_dust, 7, 13).setItem(Items.field_151137_ax, 4, 12).setItem(Items.field_151114_aO, 5, 7).setItem(Items.field_151016_H, 6, 8);
        stoneEvent = new RainbowEvent(Event.ITEM).setItem(LOTItems.cobblestone_helmet, 1, 0).setItem(LOTItems.cobblestone_chestplate, 0, 2).setItem(LOTItems.cobblestone_leggings, 0, 2).setItem(LOTItems.cobblestone_boots, 0, 2).setItem(Items.field_151052_q, 1, 0).setItem(Items.field_151049_t, 0, 2).setItem(Items.field_151050_s, 1, 0).setItem(Items.field_151051_r, 0, 2).setItems(new ItemStack(Blocks.field_150347_e), 5, 13).setItem(LOTItems.rock, 0, 6);
        watergunEvent = new RainbowEvent(Event.ITEM).setItem(LOTItems.watergun, 1, 0).setItem(LOTItems.watergun_bottle, 0, 4);
        weaponEvent = new RainbowEvent(Event.ITEM).setItem(LOTItems.knife, 1, 0).setItem(LOTItems.pistol, 1, 0).setItem(LOTItems.golden_pistol, 0, 2).setItem(LOTItems.pistol_clip, 2, 5).setItem(LOTItems.golden_pistol_clip, 2, 3).setItem(LOTItems.shotgun, 0, 2).setItem(LOTItems.shotgun_ammo, 0, 3);
        foodEvent = new RainbowEvent(Event.ITEM).setItem(Items.field_151034_e, 4, 7).setItem(Items.field_151172_bF, 7, 13).setItem(Items.field_151174_bG, 5, 13).setItem(Items.field_151120_aE, 5, 8).setItem(Items.field_151127_ba, 0, 6);
        food2Event = new RainbowEvent(Event.ITEM).setItem(LOTItems.toast, 5, 8).setItem(LOTItems.mints, 3, 8).setItem(Items.field_151106_aX, 5, 12).setItems(new ItemStack(LOTItems.soda, 1, 0), 0, 3).setItems(new ItemStack(LOTItems.soda, 1, 1), 0, 3).setItems(new ItemStack(LOTItems.soda, 1, 2), 0, 3);
        medicEvent = new RainbowEvent(Event.ITEM).setItem(LOTItems.needle, 5, 9).setItems(new ItemStack(LOTItems.antidote, 1, 0), 0, 3).setItems(new ItemStack(LOTItems.antidote, 1, 2), 0, 3).setItems(new ItemStack(LOTItems.antidote, 1, 3), 0, 3).setItems(new ItemStack(LOTItems.antidote, 1, 5), 0, 3).setItems(new ItemStack(LOTItems.fullneedle, 1, 8), 0, 3).setItem(LOTItems.medpack, 1, 3);
        sunglassesEvent = new RainbowEvent(Event.ITEM).setItem(LOTItems.sunglasses, 1, 0);
        golemEvent = new RainbowEvent(Event.MOB){

            @Override
            public Entity spawnCreature(World worldIn, String entityID, double x, double y, double z, int number) {
                String ID = entityID;
                switch (this.rand.nextInt(8)) {
                    case 0: {
                        ID = (String)EntityList.field_75626_c.get(EntityLapisGolem.class);
                        break;
                    }
                    case 1: {
                        ID = (String)EntityList.field_75626_c.get(EntityGoldGolem.class);
                        break;
                    }
                    case 2: {
                        ID = (String)EntityList.field_75626_c.get(EntityCoalGolem.class);
                        break;
                    }
                    case 3: {
                        ID = (String)EntityList.field_75626_c.get(EntityDiamondGolem.class);
                        break;
                    }
                    case 4: {
                        ID = (String)EntityList.field_75626_c.get(EntityEmeraldGolem.class);
                        break;
                    }
                    case 5: {
                        ID = (String)EntityList.field_75626_c.get(EntityDiamondGolem.class);
                        break;
                    }
                    case 6: {
                        ID = (String)EntityList.field_75626_c.get(EntityRedstoneGolem.class);
                        break;
                    }
                    case 7: {
                        ID = (String)EntityList.field_75626_c.get(EntityLapisGolem.class);
                    }
                }
                return super.spawnCreature(worldIn, ID, x, y, z, number);
            }
        }.setEntity(EntityIronGolem.class, 1, 0);
        rainbowTempleEvent = new RainbowEvent(Event.BUILD).setBuild(new CreateRainbowTemple());
        chestEvent = new RainbowEvent(Event.BUILD).setBuild(new CreateRandChest());
        EnchEvent = new RainbowEvent(Event.ITEM){

            @Override
            public ItemStack CustmizeItem(ItemStack stack, int ID) {
                ItemStack newstack = stack;
                switch (this.rand.nextInt(10)) {
                    case 0: {
                        newstack.func_150996_a(Items.field_151056_x);
                        break;
                    }
                    case 1: {
                        newstack.func_150996_a(Items.field_151046_w);
                        break;
                    }
                    case 2: {
                        newstack.func_150996_a(Items.field_151047_v);
                        break;
                    }
                    case 3: {
                        newstack.func_150996_a(Items.field_151012_L);
                        break;
                    }
                    case 4: {
                        newstack.func_150996_a((Item)Items.field_151161_ac);
                        break;
                    }
                    case 5: {
                        newstack.func_150996_a((Item)Items.field_151163_ad);
                        break;
                    }
                    case 6: {
                        newstack.func_150996_a((Item)Items.field_151173_ae);
                        break;
                    }
                    case 7: {
                        newstack.func_150996_a((Item)Items.field_151175_af);
                        break;
                    }
                    case 8: {
                        newstack.func_150996_a(LOTItems.diamond_hammer);
                    }
                }
                EnchantmentHelper.func_77504_a((Random)this.rand, (ItemStack)newstack, (int)30);
                return newstack;
            }
        }.setItem(Items.field_151048_u, 1, 0);
        hammerEvent = new RainbowEvent(Event.ITEM){

            @Override
            public ItemStack CustmizeItem(ItemStack stack, int ID) {
                ItemStack newstack = stack;
                switch (this.rand.nextInt(8)) {
                    case 0: {
                        newstack.func_150996_a(LOTItems.iron_hammer);
                        break;
                    }
                    case 1: {
                        newstack.func_150996_a(LOTItems.stone_hammer);
                        break;
                    }
                    case 2: {
                        newstack.func_150996_a(LOTItems.diamond_hammer);
                        break;
                    }
                    case 3: {
                        newstack.func_150996_a(LOTItems.copper_hammer);
                        break;
                    }
                    case 4: {
                        newstack.func_150996_a(LOTItems.emerald_hammer);
                        break;
                    }
                    case 5: {
                        newstack.func_150996_a(LOTItems.lapis_hammer);
                        break;
                    }
                    case 6: {
                        newstack.func_150996_a(LOTItems.ruby_hammer);
                    }
                }
                return newstack;
            }
        }.setItem(LOTItems.golden_hammer, 1, 0);
        anvilEvent = new RainbowEvent(Event.BUILD).setBuild(new CreateAnvilTrap()).setTriggerAtPlayer();
    }

    public static enum Event {
        ITEM,
        MOB,
        BUILD,
        CUSTOM;

    }
}

