/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.LOT.rainbowbox;

import com.superdextor.LOT.inventory.gui.GuiRainbowMinigame;
import com.superdextor.thinkbigcore.helpers.ChatHelper;
import com.superdextor.thinkbigcore.helpers.EffectHelper;
import com.superdextor.thinkbigcore.utility.SoundEffect;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public abstract class RainbowMinigame {
    public final String gameName;
    public boolean isRunning = false;
    public int score = 0;
    public final int points4Win;
    public final int points4Luck;
    public int time;
    public final int totalTime;
    protected CopyOnWriteArrayList<Entity> entitys = new CopyOnWriteArrayList();
    public float luckFromGame = 0.0f;
    protected GuiRainbowMinigame gui;
    protected Minecraft mc;
    protected final FontRenderer fontRendererObj;
    protected final Random rand = new Random();
    protected int worldPosX;
    protected int worldPosY = 0;
    protected int worldWidth;
    protected int worldHeight = 0;
    private int gameStartDelay = -90;
    private int gameCloseDelay = -60;
    protected String gameState = "init";
    protected boolean youWon = false;

    public RainbowMinigame(GuiRainbowMinigame guiIn, String name, int totalTime, int points4Win, int p4l) {
        this.gui = guiIn;
        this.mc = Minecraft.func_71410_x();
        this.fontRendererObj = this.mc.field_71466_p;
        this.gameName = ChatHelper.ColorBook.WHITE.toString() + ChatHelper.ColorBook.BOLD.toString() + name;
        this.totalTime = totalTime;
        this.points4Win = points4Win;
        this.points4Luck = p4l;
    }

    public final void setWorldPos(int x, int y, int w, int h) {
        this.worldPosX = x;
        this.worldPosY = y;
        this.worldWidth = w;
        this.worldHeight = h;
    }

    public void start() {
        this.isRunning = true;
        this.gameState = "running";
    }

    public abstract void initButtons(List<GuiButton> var1);

    public void getResults() {
        this.gameState = "postInit";
        if (this.score >= this.points4Win) {
            this.youWon = true;
            this.luckFromGame = 0.5f + this.Score2Luck();
            if (this.luckFromGame > 1.0f) {
                this.luckFromGame = 1.0f;
            }
        } else {
            this.luckFromGame = 0.0f + this.Score2Luck();
            this.youWon = false;
            if (this.luckFromGame > 0.4f) {
                this.luckFromGame = 0.4f;
            }
        }
        if (this.luckFromGame < 0.1f) {
            this.luckFromGame = 0.1f;
        }
    }

    public void end(String state) {
        this.isRunning = false;
        this.gameState = state;
    }

    public void close() {
        this.gui.close(this.luckFromGame);
    }

    public void update() {
        if (this.isRunning) {
            ++this.time;
            if (this.getTime() < 0) {
                this.end("time");
                --this.time;
            }
        } else if (this.gameStartDelay < 1 && this.gameState == "init") {
            ++this.gameStartDelay;
            if (this.gameStartDelay > -1) {
                this.start();
            }
        } else if (this.gameCloseDelay > 0 && this.gameState != "postInit") {
            this.getResults();
        } else {
            ++this.gameCloseDelay;
            if (this.gameCloseDelay > 70) {
                this.close();
            }
        }
        if (this.isRunning && !this.entitys.isEmpty()) {
            for (Entity entity : this.entitys) {
                entity.update();
            }
        }
    }

    protected float Score2Luck() {
        int j = this.score / this.points4Luck;
        return (float)j * 0.1f;
    }

    public void draw(RenderItem renderer, int x, int y) {
        this.fontRendererObj.func_175065_a(this.gameName, (float)(x + this.gui.xSize / 2 - this.fontRendererObj.func_78256_a(this.gameName) / 2), (float)(7 + y), 0x404040, true);
        this.fontRendererObj.func_175065_a(ChatHelper.ColorBook.YELLOW.toString() + "Points: " + this.score, (float)(x + 14), (float)(y + this.gui.ySize - 22), 0x404040, true);
        this.fontRendererObj.func_175065_a(ChatHelper.ColorBook.YELLOW.toString() + "Time: " + this.getTime(), (float)(x + 13), (float)(y + this.gui.ySize - 12), 0x404040, true);
        if (!this.entitys.isEmpty()) {
            for (Entity entity : this.entitys) {
                if (!entity.visable) continue;
                entity.drawEntity(renderer, this.worldPosX + entity.posX, this.worldPosY + entity.posY);
            }
        }
        if (!this.isRunning) {
            String s = "";
            if (this.gameState == "init") {
                if (this.gameStartDelay < -50) {
                    s = ChatHelper.ColorBook.YELLOW.toString() + ChatHelper.ColorBook.BOLD.toString() + "Ready..";
                } else if (this.gameStartDelay < -1) {
                    s = ChatHelper.ColorBook.GREEN.toString() + ChatHelper.ColorBook.BOLD.toString() + "Go!";
                }
            } else if (this.gameState == "time") {
                s = ChatHelper.ColorBook.BLUE.toString() + ChatHelper.ColorBook.BOLD.toString() + "Time!";
            } else if (this.gameState == "game") {
                s = ChatHelper.ColorBook.BLUE.toString() + ChatHelper.ColorBook.BOLD.toString() + "Game!";
            } else if (this.gameCloseDelay != -60) {
                s = this.youWon ? ChatHelper.ColorBook.AQUA.toString() + ChatHelper.ColorBook.BOLD.toString() + "You Win!" : ChatHelper.ColorBook.RED.toString() + ChatHelper.ColorBook.BOLD.toString() + "You Lose.";
            }
            this.fontRendererObj.func_175065_a(s, (float)(x + this.gui.xSize / 2 - this.fontRendererObj.func_78256_a(s) / 2), (float)(y + this.gui.ySize / 2 - 6), 0x404040, true);
        }
    }

    public void drawControlPannel(RenderItem renderer, int x, int y) {
        this.fontRendererObj.func_175065_a(ChatHelper.ColorBook.WHITE.toString() + ChatHelper.ColorBook.BOLD.toString() + "Controls", (float)(x + 14), (float)(y + 6), 0x404040, true);
    }

    public void drawHelpPannel(RenderItem renderer, int x, int y) {
        this.fontRendererObj.func_175065_a(ChatHelper.ColorBook.WHITE.toString() + ChatHelper.ColorBook.BOLD.toString() + "Info", (float)(x + 28), (float)(y + 6), 0x404040, true);
        if (this.points4Win > 0) {
            this.fontRendererObj.func_175065_a(ChatHelper.ColorBook.GOLD.toString() + "pts 4 Win: " + this.points4Win, (float)(x + 6), (float)(y + 17), 0x404040, true);
        }
    }

    public abstract void actionInput(int var1, int var2);

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        for (Entity entity : this.entitys) {
            if (!entity.checkForCollisionWithMouse(mouseX, mouseY)) continue;
            entity.onClicked(mouseX, mouseY, mouseButton);
        }
    }

    public void spawnEntity(Entity e) {
        if (this.isRunning && !this.entitys.contains(e)) {
            this.entitys.add(e);
            e.onSpawn();
        }
    }

    public void removeEntity(Entity e) {
        if (this.isRunning && this.entitys.contains(e)) {
            this.entitys.remove(e);
        }
        e = null;
    }

    public int getTime() {
        return this.totalTime - this.time / 20;
    }

    public class Entity {
        public int posX = 0;
        public int posY = 0;
        public float motionX = 0.0f;
        public float motionY = 0.0f;
        public int width = 16;
        public int height = 16;
        public final ItemStack texture;
        public boolean noStop = false;
        public final RainbowMinigame world;
        public boolean deathOnInpact = false;
        public final int killPoints;
        public boolean playerObject = false;
        public ArrayList<Item> killedByEntityWhitelist = new ArrayList();
        public SoundEffect[] sounds = new SoundEffect[3];
        public boolean isDead = false;
        public boolean visable = true;

        public Entity(RainbowMinigame world, ItemStack t, int kp) {
            this.world = world;
            this.texture = t;
            this.killPoints = kp;
        }

        public Entity(RainbowMinigame world, ItemStack t) {
            this(world, t, 0);
        }

        public void onSpawn() {
            if (this.sounds[0] != null) {
                this.world.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation(this.sounds[0].location), (float)1.0f));
            }
        }

        public Entity(RainbowMinigame world) {
            this(world, new ItemStack(Items.field_151034_e), 0);
        }

        public void update() {
            this.updateMotion();
            this.checkForCollisions();
        }

        protected void updateMotion() {
            this.posX = (int)((float)this.posX + this.motionX);
            this.posY = (int)((float)this.posY + this.motionY);
            if (this.posX < 0) {
                this.posX = 0;
                this.onCollisionWithWall();
            }
            if (this.posX > this.world.worldWidth - this.width) {
                this.posX = this.world.worldWidth - this.width;
                this.onCollisionWithWall();
            }
            if (this.posY < 0) {
                this.posY = 0;
                this.onCollisionWithWall();
            }
            if (this.posY > this.world.worldHeight - this.height) {
                this.posY = this.world.worldHeight - this.height;
                this.onCollisionWithWall();
            }
            if (!this.noStop) {
                this.motionX = this.motionX > 0.1f && this.motionX < -0.1f ? (this.motionX *= 0.8f) : 0.0f;
                this.motionY = this.motionY > 0.1f && this.motionY < -0.1f ? (this.motionY *= 0.8f) : 0.0f;
            }
        }

        protected void checkForCollisions() {
            for (Entity entity : this.world.entitys) {
                if (entity == this) continue;
                this.checkForCollisionWithEntity(entity);
            }
        }

        protected boolean checkForCollisionWithEntity(Entity entity) {
            for (int ex = 0; ex < entity.width; ++ex) {
                for (int ey = 0; ey < entity.height; ++ey) {
                    for (int sx = 0; sx < this.width; ++sx) {
                        for (int sy = 0; sy < this.height; ++sy) {
                            if (entity.posX + ex != this.posX + sx || entity.posY + ey != this.posY + sy) continue;
                            this.onCollisionWithEntity(entity);
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        protected boolean checkForCollisionWithMouse(int mouseX, int mouseY) {
            return mouseX >= this.posX + this.world.worldPosX && mouseY >= this.posY + this.world.worldPosY && mouseX < this.posX + this.world.worldPosX + this.width && mouseY < this.posY + this.world.worldPosY + this.height;
        }

        public void onClicked(int clickedX, int clickedY, int button) {
        }

        public void drawEntity(RenderItem renderer, int x, int y) {
            renderer.func_180450_b(this.texture, x, y);
        }

        public void setPos(int x, int y) {
            this.posX = x;
            this.posY = y;
        }

        public void setSize(int w, int h) {
            this.width = w;
            this.height = h;
        }

        public void setSoundEffects(SoundEffect onSpawn, SoundEffect onDeath, SoundEffect onKilled) {
            this.sounds[0] = onSpawn;
            this.sounds[1] = onDeath;
            this.sounds[2] = onKilled;
        }

        public void setSoundEffects(EffectHelper.SoundBook onSpawn, EffectHelper.SoundBook onDeath, EffectHelper.SoundBook onKilled) {
            this.setSoundEffects(onSpawn == null ? null : new SoundEffect(onSpawn), onDeath == null ? null : new SoundEffect(onDeath), onKilled == null ? null : new SoundEffect(onKilled));
        }

        public void enableNoStop(boolean s) {
            this.noStop = s;
        }

        public void enableDeathOnInpact(boolean d) {
            this.deathOnInpact = d;
        }

        public void setPlayerObject() {
            this.playerObject = true;
        }

        public void addToKilledByWhitelist(Item i) {
            this.killedByEntityWhitelist.add(i);
        }

        public void moveTowardsEntity(Entity target, float speed) {
            float x = target.posX - this.posX;
            float y = target.posY - this.posY;
            if (x > speed) {
                x = speed;
            } else if (x < -speed) {
                x = -speed;
            }
            if (y > speed) {
                y = speed;
            } else if (y < -speed) {
                y = -speed;
            }
            this.motionX = x;
            this.motionY = y;
        }

        public void setMotion(float mX, float mY) {
            this.motionX = mX;
            this.motionY = mY;
        }

        public void addToMotion(float mX, float mY) {
            this.setMotion(this.motionX + mX, this.motionY + mY);
        }

        public void stopMotion() {
            this.motionX = 0.0f;
            this.motionY = 0.0f;
        }

        public void onCollisionWithWall() {
            if (this.deathOnInpact) {
                this.onDeath(false);
            }
        }

        public void onCollisionWithEntity(Entity entity) {
            if (this.deathOnInpact) {
                boolean flag = false;
                if (!this.killedByEntityWhitelist.isEmpty()) {
                    for (Item i : this.killedByEntityWhitelist) {
                        if (entity.texture.func_77973_b() != i) continue;
                        flag = true;
                    }
                }
                if (flag) {
                    entity.onKill(this);
                    this.onDeath(entity.playerObject);
                }
            }
        }

        public void onDeath(boolean playerKill) {
            if (!playerKill && this.sounds[1] != null) {
                this.world.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation(this.sounds[1].location), (float)1.0f));
            }
            if (playerKill) {
                this.world.score += this.killPoints;
                if (this.sounds[2] != null) {
                    this.world.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation(this.sounds[2].location), (float)1.0f));
                }
            }
            this.isDead = true;
            this.world.removeEntity(this);
        }

        public void onKill(Entity victim) {
        }

        public String toString() {
            return this.texture.func_77973_b().func_77658_a() + " @" + this.posX + ", " + this.posY;
        }
    }

    public class CommandButton
    extends GuiButton {
        public int uses;
        private final RenderItem renderItem;
        public final ItemStack icon;
        protected final FontRenderer fontRendererObj;
        public GuiRainbowMinigame gui;
        protected final SoundEffect sound;

        public CommandButton(GuiRainbowMinigame gui, int buttonId, int x, int y, ItemStack icon, int uses, SoundEffect sound) {
            super(buttonId, x + gui.getGuiRenderOffset("x"), y + gui.getGuiRenderOffset("y"), 16, 16, "");
            this.uses = -1;
            this.icon = icon;
            this.gui = gui;
            this.renderItem = gui.getRenderItem();
            this.fontRendererObj = gui.getFontRenderer();
            this.uses = uses;
            this.sound = sound;
        }

        public CommandButton(GuiRainbowMinigame gui, int buttonId, int x, int y, ItemStack icon) {
            this(gui, buttonId, x, y, icon, -1, new SoundEffect(EffectHelper.SoundBook.ui_button_click));
        }

        public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
            this.field_146124_l = this.gui.minigame.isRunning;
            if (this.field_146125_m) {
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(GuiRainbowMinigame.backgroundtextures);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 176, 0, 18, 18);
                this.renderItem.func_180450_b(this.icon, this.field_146128_h + 1, this.field_146129_i + 1);
                if (this.uses >= 0) {
                    this.renderItem.func_180453_a(this.fontRendererObj, this.icon, this.field_146128_h, this.field_146129_i, "" + this.uses);
                } else if (this.uses == 0) {
                    this.renderItem.func_180453_a(this.fontRendererObj, this.icon, this.field_146128_h, this.field_146129_i, ChatHelper.ColorBook.RED.toString() + 0);
                }
            }
        }

        public void func_146113_a(SoundHandler soundHandlerIn) {
            if (this.uses != 0) {
                if (this.uses > 0) {
                    --this.uses;
                }
                this.gui.minigame.actionInput(0, this.field_146127_k);
                soundHandlerIn.func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation(this.sound.location), (float)1.0f));
            } else {
                super.func_146113_a(soundHandlerIn);
            }
        }
    }
}

