/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.LOT.rainbowbox;

import com.superdextor.LOT.inventory.gui.GuiRainbowMinigame;
import com.superdextor.LOT.items.LOTItems;
import com.superdextor.LOT.rainbowbox.RainbowMinigame;
import com.superdextor.thinkbigcore.helpers.ChatHelper;
import com.superdextor.thinkbigcore.helpers.EffectHelper;
import com.superdextor.thinkbigcore.utility.SoundEffect;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class RgameBowNArrow
extends RainbowMinigame {
    protected RainbowMinigame.Entity bow;
    protected RainbowMinigame.CommandButton shootButton;
    protected RainbowMinigame.CommandButton tripleButton;
    protected RainbowMinigame.CommandButton nukeButton;
    protected int arrows = 20;
    protected int triples = 3;
    protected int nukes = 1;
    private int nextSpawn = 20;
    private int nextGroup = -3;
    private int gameOverDelay = -20;

    public RgameBowNArrow(GuiRainbowMinigame guiIn) {
        super(guiIn, "Bow n' Arrow", 60, 800, 250);
    }

    @Override
    public void start() {
        super.start();
        this.bow = new RainbowMinigame.Entity(this, new ItemStack((Item)Items.field_151031_f));
        this.spawnEntity(this.bow);
        this.bow.setPos(this.worldWidth / 2 - this.bow.width / 2, 0);
    }

    @Override
    public void initButtons(List<GuiButton> list) {
        list.clear();
        this.shootButton = new RainbowMinigame.CommandButton(this.gui, 1, 149, 144, new ItemStack(Items.field_151032_g), this.arrows, new SoundEffect(EffectHelper.SoundBook.entity_arrow_shoot));
        ItemStack arrow = new ItemStack(Items.field_151032_g);
        arrow.func_77966_a(Enchantment.field_77347_r, 1);
        this.tripleButton = new RainbowMinigame.CommandButton(this.gui, 2, 131, 144, arrow, this.triples, new SoundEffect(EffectHelper.SoundBook.entity_arrow_shoot));
        this.nukeButton = new RainbowMinigame.CommandButton(this.gui, 3, 113, 144, new ItemStack(LOTItems.zeus_sword), this.nukes, new SoundEffect(EffectHelper.SoundBook.entity_lightning_thunder));
        list.add(this.shootButton);
        list.add(this.tripleButton);
        list.add(this.nukeButton);
    }

    @Override
    public void update() {
        super.update();
        if (this.isRunning) {
            --this.nextSpawn;
            if (this.nextSpawn < 1) {
                if (this.nextGroup > 11) {
                    for (int k = 0; k < this.rand.nextInt(3) + 3; ++k) {
                        this.makeTarget();
                    }
                    this.nextGroup = 0;
                }
                int i = this.makeTarget();
                this.nextSpawn = 8 * i + this.rand.nextInt(6) * 4;
                this.nextGroup += i;
            }
            this.arrows = this.shootButton.uses;
            this.triples = this.tripleButton.uses;
            this.nukes = this.nukeButton.uses;
            if (this.arrows == 0 && this.triples == 0 && this.nukes == 0) {
                boolean flag = true;
                for (RainbowMinigame.Entity entity : this.entitys) {
                    if (!(entity instanceof EntityArrow)) continue;
                    flag = false;
                }
                if (flag) {
                    ++this.gameOverDelay;
                }
                if (this.gameOverDelay > 0) {
                    this.end("game");
                }
            }
        }
    }

    private int makeTarget() {
        Item item;
        int itemLevel = 1;
        if (this.rand.nextFloat() < 0.5f) {
            itemLevel = 2;
            item = this.rand.nextBoolean() ? Items.field_151015_O : Items.field_151044_h;
        } else if (this.rand.nextFloat() < 0.4f) {
            itemLevel = 3;
            item = this.rand.nextBoolean() ? Items.field_151042_j : Items.field_151106_aX;
        } else if (this.rand.nextFloat() < 0.2f) {
            itemLevel = 4;
            item = this.rand.nextBoolean() ? Items.field_151045_i : Items.field_151166_bC;
        } else if (this.rand.nextFloat() < 0.1f) {
            itemLevel = 5;
            item = Items.field_151156_bN;
        } else {
            item = this.rand.nextBoolean() ? Items.field_151055_y : Items.field_151078_bh;
        }
        boolean moveRight = this.rand.nextBoolean();
        float speed = 1.0f + this.rand.nextFloat() * 0.5f + (1.0f + this.rand.nextFloat() * 0.6f) * (float)itemLevel;
        RainbowMinigame.Entity target = new RainbowMinigame.Entity(this, new ItemStack(item), 25 * itemLevel);
        target.addToKilledByWhitelist(Items.field_151032_g);
        target.setPos(moveRight ? 0 : this.worldWidth - target.width, this.worldHeight - target.height - this.rand.nextInt(32));
        target.enableDeathOnInpact(true);
        target.enableNoStop(true);
        target.setMotion(moveRight ? speed : -speed, 0.0f);
        target.setSoundEffects(null, EffectHelper.SoundBook.block_stone_hit, EffectHelper.SoundBook.entity_item_pickup);
        this.spawnEntity(target);
        return itemLevel;
    }

    @Override
    public void actionInput(int keyCode, int customInput) {
        if (this.mc.field_71474_y.field_74370_x.func_151463_i() == keyCode) {
            this.bow.motionX = -2.0f;
        }
        if (this.mc.field_71474_y.field_74366_z.func_151463_i() == keyCode) {
            this.bow.motionX = 2.0f;
        }
        if (customInput == 1) {
            EntityArrow entityarrow = new EntityArrow((RainbowMinigame)this, new ItemStack(Items.field_151032_g));
            entityarrow.setPos(this.bow.posX, this.bow.posY);
            entityarrow.setMotion(0.0f, 8.0f);
            this.spawnEntity(entityarrow);
        }
        if (customInput == 2) {
            float d = -2.0f;
            for (int i = 0; i < 3; ++i) {
                EntityArrow entityarrow = new EntityArrow((RainbowMinigame)this, this.tripleButton.icon);
                entityarrow.setPos(this.bow.posX, this.bow.posY);
                entityarrow.setMotion(d, 8.0f);
                this.spawnEntity(entityarrow);
                d += 2.0f;
            }
        }
        if (customInput == 3) {
            for (RainbowMinigame.Entity e : this.entitys) {
                if (e == this.bow || e.texture.func_77973_b() == Items.field_151032_g) continue;
                e.sounds[2] = new SoundEffect(EffectHelper.SoundBook.entity_creeper_hurt);
                e.onDeath(true);
            }
        }
    }

    @Override
    public void draw(RenderItem renderer, int x, int y) {
        super.draw(renderer, x, y);
    }

    @Override
    public void drawControlPannel(RenderItem renderer, int x, int y) {
        super.drawControlPannel(renderer, x, y);
        String s = "Shoot:";
        String s1 = "STACKS";
        int i = 0;
        this.fontRendererObj.func_175065_a(ChatHelper.ColorBook.GOLD.toString() + s, (float)(x + 7), (float)(y + 24 + 20 * i), 0x404040, true);
        this.fontRendererObj.func_78276_b(ChatHelper.ColorBook.YELLOW.toString() + s1, x + 7, y + 24 + 20 * i + 10, 0x404040);
        s = "MoveLeft:";
        s1 = this.mc.field_71474_y.field_74370_x.func_151464_g();
        i = 1;
        this.fontRendererObj.func_175065_a(ChatHelper.ColorBook.GOLD.toString() + s, (float)(x + 7), (float)(y + 24 + 20 * i), 0x404040, true);
        this.fontRendererObj.func_78276_b(ChatHelper.ColorBook.YELLOW.toString() + s1, x + 7, y + 24 + 20 * i + 10, 0x404040);
        s = "MoveRight:";
        s1 = this.mc.field_71474_y.field_74366_z.func_151464_g();
        i = 2;
        this.fontRendererObj.func_175065_a(ChatHelper.ColorBook.GOLD.toString() + s, (float)(x + 7), (float)(y + 24 + 20 * i), 0x404040, true);
        this.fontRendererObj.func_78276_b(ChatHelper.ColorBook.YELLOW.toString() + s1, x + 7, y + 24 + 20 * i + 10, 0x404040);
    }

    @Override
    public void drawHelpPannel(RenderItem renderer, int x, int y) {
        super.drawHelpPannel(renderer, x, y);
        ItemStack stack = new ItemStack(Items.field_151055_y);
        ItemStack stack2 = new ItemStack(Items.field_151078_bh);
        String pts = "25";
        int i = 0;
        renderer.func_180450_b(stack, x + 5, y + 20 + 20 * i + 10);
        renderer.func_180450_b(stack2, x + 24, y + 20 + 20 * i + 10);
        this.fontRendererObj.func_78276_b(ChatHelper.ColorBook.YELLOW.toString() + " " + pts + " pts", x + 39, y + 20 + 20 * i + 10, 0x404040);
        stack = new ItemStack(Items.field_151015_O);
        stack2 = new ItemStack(Items.field_151044_h);
        pts = "50";
        i = 1;
        renderer.func_180450_b(stack, x + 5, y + 20 + 20 * i + 10);
        renderer.func_180450_b(stack2, x + 24, y + 20 + 20 * i + 10);
        this.fontRendererObj.func_78276_b(ChatHelper.ColorBook.YELLOW.toString() + " " + pts + " pts", x + 39, y + 20 + 20 * i + 10, 0x404040);
        stack = new ItemStack(Items.field_151106_aX);
        stack2 = new ItemStack(Items.field_151042_j);
        pts = "75";
        i = 2;
        renderer.func_180450_b(stack, x + 5, y + 20 + 20 * i + 10);
        renderer.func_180450_b(stack2, x + 24, y + 20 + 20 * i + 10);
        this.fontRendererObj.func_78276_b(ChatHelper.ColorBook.YELLOW.toString() + " " + pts + " pts", x + 39, y + 20 + 20 * i + 10, 0x404040);
        stack = new ItemStack(Items.field_151045_i);
        stack2 = new ItemStack(Items.field_151166_bC);
        pts = "100";
        i = 3;
        renderer.func_180450_b(stack, x + 5, y + 20 + 20 * i + 10);
        renderer.func_180450_b(stack2, x + 24, y + 20 + 20 * i + 10);
        this.fontRendererObj.func_78276_b(ChatHelper.ColorBook.YELLOW.toString() + " " + pts + " pts", x + 39, y + 20 + 20 * i + 10, 0x404040);
        stack2 = new ItemStack(Items.field_151156_bN);
        pts = "125";
        i = 4;
        renderer.func_180450_b(stack2, x + 20, y + 20 + 20 * i + 10);
        this.fontRendererObj.func_78276_b(ChatHelper.ColorBook.YELLOW.toString() + " " + pts + " pts", x + 36, y + 20 + 20 * i + 10, 0x404040);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public class EntityArrow
    extends RainbowMinigame.Entity {
        public EntityArrow(RainbowMinigame world, ItemStack t) {
            super(world, t);
            this.enableNoStop(true);
            this.enableDeathOnInpact(true);
            this.setPlayerObject();
            this.setSoundEffects(null, EffectHelper.SoundBook.entity_arrow_hit, null);
        }

        @Override
        public void onKill(RainbowMinigame.Entity victim) {
            Item entityId = victim.texture.func_77973_b();
            if (entityId == Items.field_151045_i || entityId == Items.field_151166_bC) {
                ++((RgameBowNArrow)this.world).tripleButton.uses;
            }
            if (entityId == Items.field_151156_bN) {
                ++((RgameBowNArrow)this.world).nukeButton.uses;
            }
        }
    }
}

