/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.LOT.worldgen;

import com.superdextor.LOT.blocks.LOTBlocks;
import com.superdextor.LOT.worldgen.GenRainbowBox;
import com.superdextor.LOT.worldgen.GenRainbowFlowers;
import com.superdextor.thinkbigcore.helpers.ChatHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class LOTGeneration
implements IWorldGenerator {
    private GenRainbowBox genRainboxOverworld = new GenRainbowBox(false);
    private GenRainbowFlowers genRainbowFlowers = new GenRainbowFlowers(14);
    private GenRainbowBox genRainboxHell = new GenRainbowBox(true);
    private GenRainbowBox genRainboxVoid = new GenRainbowBox(true);

    public LOTGeneration() {
        ChatHelper.printDebugMessage(null, (String)"LOT successfully loaded it's World Generator");
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.func_177502_q()) {
            case 1: {
                this.generateEnd(world, random, new BlockPos(chunkX * 16, 64, chunkZ * 16));
                break;
            }
            case 0: {
                this.generateOverworld(world, random, new BlockPos(chunkX * 16, 64, chunkZ * 16));
                break;
            }
            case -1: {
                this.generateNether(world, random, new BlockPos(chunkX * 16, 64, chunkZ * 16));
            }
        }
    }

    private void addStoneOre(Block block, World world, Random random, BlockPos pos, int maxX, int maxZ, int maxVeinSize, int chanceToSpawn, int minY, int maxY, Block generateIn) {
        WorldGenMinable mine = new WorldGenMinable(block.func_176223_P(), maxVeinSize);
        for (int i = 0; i < chanceToSpawn; ++i) {
            int x = pos.func_177958_n() + random.nextInt(maxX);
            int y = minY + random.nextInt(maxY - minY);
            int z = pos.func_177952_p() + random.nextInt(maxZ);
            mine.func_180709_b(world, random, new BlockPos(x, y, z));
        }
    }

    private void generateNether(World world, Random random, BlockPos pos) {
        int x = pos.func_177958_n() + random.nextInt(16);
        int y = 8 + random.nextInt(72);
        int z = pos.func_177952_p() + random.nextInt(16);
        this.genRainboxHell.func_180709_b(world, random, new BlockPos(x, y, z));
    }

    private void generateOverworld(World world, Random random, BlockPos pos) {
        int x = pos.func_177958_n() + random.nextInt(16);
        int y = 8 + random.nextInt(72);
        int z = pos.func_177952_p() + random.nextInt(16);
        this.genRainbowFlowers.func_180709_b(world, random, new BlockPos(x, y, z));
        this.genRainboxOverworld.func_180709_b(world, random, new BlockPos(x, y, z));
        this.addStoneOre(LOTBlocks.copper_ore, world, random, pos, 16, 16, 3 + random.nextInt(9), 24, 0, 89, Blocks.field_150348_b);
        this.addStoneOre(LOTBlocks.ruby_ore, world, random, pos, 16, 16, 3 + random.nextInt(4), 1, 0, 14, Blocks.field_150348_b);
    }

    private void generateEnd(World world, Random random, BlockPos pos) {
        int x = pos.func_177958_n() + random.nextInt(16);
        int y = 8 + random.nextInt(72);
        int z = pos.func_177952_p() + random.nextInt(16);
        this.genRainboxVoid.func_180709_b(world, random, new BlockPos(x, y, z));
    }
}

