/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.magical_torches.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerConfig {
    private static final Logger LOGGER = LogManager.getLogger(ServerConfig.class);
    private static final String MOD_NAME = ModLoadingContext.get().getActiveContainer().getModInfo().getDisplayName();
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec CONFIG;
    private static final ForgeConfigSpec.IntValue ALONE_TORCH_RANGE;
    private static final ForgeConfigSpec.IntValue BAT_TORCH_RANGE;
    private static final ForgeConfigSpec.IntValue SMALL_TORCH_RANGE;
    private static final ForgeConfigSpec.IntValue MEDIUM_TORCH_RANGE;
    private static final ForgeConfigSpec.IntValue GRAND_TORCH_RANGE;
    private static final ForgeConfigSpec.IntValue MEGA_TORCH_RANGE;
    private static final ForgeConfigSpec.ConfigValue<List<String>> HOSTILE_BLOCKED_ENTITIES;
    private static final ForgeConfigSpec.IntValue SOUND_MUFFLING_TORCH_RANGE;
    private static final ForgeConfigSpec.ConfigValue<List<String>> SOUND_MUFFLING_TORCH_TO_MUFFLE_SOUNDS;
    private static final ForgeConfigSpec.IntValue CHICKEN_EGG_TORCH_RANGE;
    private static final ForgeConfigSpec.BooleanValue SHOULD_INVERT_CHICKEN_EGG_BLOCKING;
    private static List<ResourceLocation> hostileBlockedEntities;
    private static List<SoundSource> soundMufflingTorchToMuffleSounds;

    private static List<String> buildBlockedEntities() {
        ArrayList<String> entities = new ArrayList<String>();
        Registry.f_122826_.forEach(entityType -> {
            if (entityType.m_20674_() == MobCategory.MONSTER) {
                entities.add(Objects.requireNonNull(entityType.getRegistryName()).toString());
            }
        });
        return entities;
    }

    private static String buildSoundCategories() {
        return Arrays.stream(SoundSource.values()).map(Enum::name).collect(Collectors.joining(", "));
    }

    public static void analyseAndPrintConfig() {
        ServerConfig.loadHostileBlockedEntities();
        ServerConfig.loadSoundMufflingTorchToMuffleSounds();
        ServerConfig.printConfig();
    }

    private static void loadHostileBlockedEntities() {
        List hostileBlockedEntitiesValue = (List)HOSTILE_BLOCKED_ENTITIES.get();
        ArrayList<ResourceLocation> hostile_blocked_entities = new ArrayList<ResourceLocation>();
        boolean changed = false;
        for (int i = 0; i < hostileBlockedEntitiesValue.size(); ++i) {
            ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)((String)hostileBlockedEntitiesValue.get(i)));
            if (resourceLocation == null || Registry.f_122826_.m_6612_(resourceLocation).isEmpty()) {
                hostileBlockedEntitiesValue.remove(i);
                --i;
                changed = true;
                continue;
            }
            hostile_blocked_entities.add(resourceLocation);
        }
        if (changed) {
            HOSTILE_BLOCKED_ENTITIES.set((Object)hostileBlockedEntitiesValue);
        }
        hostileBlockedEntities = hostile_blocked_entities;
    }

    private static void loadSoundMufflingTorchToMuffleSounds() {
        soundMufflingTorchToMuffleSounds = ((List)SOUND_MUFFLING_TORCH_TO_MUFFLE_SOUNDS.get()).stream().map(SoundSource::valueOf).collect(Collectors.toList());
    }

    private static void printConfig() {
        LOGGER.info("Loading \"{}\" Server Config", (Object)MOD_NAME);
        LOGGER.info("{} = {}", (Object)ALONE_TORCH_RANGE.getPath(), ALONE_TORCH_RANGE.get());
        LOGGER.info("{} = {}", (Object)BAT_TORCH_RANGE.getPath(), BAT_TORCH_RANGE.get());
        LOGGER.info("{} = {}", (Object)SMALL_TORCH_RANGE.getPath(), SMALL_TORCH_RANGE.get());
        LOGGER.info("{} = {}", (Object)MEDIUM_TORCH_RANGE.getPath(), MEDIUM_TORCH_RANGE.get());
        LOGGER.info("{} = {}", (Object)GRAND_TORCH_RANGE.getPath(), GRAND_TORCH_RANGE.get());
        LOGGER.info("{} = {}", (Object)MEGA_TORCH_RANGE.getPath(), MEGA_TORCH_RANGE.get());
        LOGGER.info("{} = {}", (Object)HOSTILE_BLOCKED_ENTITIES.getPath(), HOSTILE_BLOCKED_ENTITIES.get());
        LOGGER.info("{} = {}", (Object)SOUND_MUFFLING_TORCH_RANGE.getPath(), SOUND_MUFFLING_TORCH_RANGE.get());
        LOGGER.info("{} = {}", (Object)SOUND_MUFFLING_TORCH_TO_MUFFLE_SOUNDS.getPath(), SOUND_MUFFLING_TORCH_TO_MUFFLE_SOUNDS.get());
        LOGGER.info("{} = {}", (Object)CHICKEN_EGG_TORCH_RANGE.getPath(), CHICKEN_EGG_TORCH_RANGE.get());
        LOGGER.info("{} = {}", (Object)SHOULD_INVERT_CHICKEN_EGG_BLOCKING.getPath(), SHOULD_INVERT_CHICKEN_EGG_BLOCKING.get());
        LOGGER.info("\"{}\" Server Config loaded", (Object)MOD_NAME);
    }

    public static int getAloneTorchRange() {
        return (Integer)ALONE_TORCH_RANGE.get();
    }

    public static int getBatTorchRange() {
        return (Integer)BAT_TORCH_RANGE.get();
    }

    public static List<ResourceLocation> getHostileBlockedEntities() {
        return hostileBlockedEntities;
    }

    public static int getSmallTorchRange() {
        return (Integer)SMALL_TORCH_RANGE.get();
    }

    public static int getMediumTorchRange() {
        return (Integer)MEDIUM_TORCH_RANGE.get();
    }

    public static int getGrandTorchRange() {
        return (Integer)GRAND_TORCH_RANGE.get();
    }

    public static int getMegaTorchRange() {
        return (Integer)MEGA_TORCH_RANGE.get();
    }

    public static int getSoundMufflingTorchRange() {
        return (Integer)SOUND_MUFFLING_TORCH_RANGE.get();
    }

    public static List<SoundSource> getSoundMufflingTorchToMuffleSounds() {
        return soundMufflingTorchToMuffleSounds;
    }

    public static boolean getShouldInvertChickenEggBlocking() {
        return (Boolean)SHOULD_INVERT_CHICKEN_EGG_BLOCKING.get();
    }

    public static int getChickenEggTorchRange() {
        return (Integer)CHICKEN_EGG_TORCH_RANGE.get();
    }

    static {
        hostileBlockedEntities = new ArrayList<ResourceLocation>();
        soundMufflingTorchToMuffleSounds = new ArrayList<SoundSource>();
        BUILDER.comment("Config for the spawn blocking torches").push("spawn_blockers");
        ALONE_TORCH_RANGE = BUILDER.comment("Range of the alone torch.").defineInRange("alone_torch_range", 64, 0, Integer.MAX_VALUE);
        BAT_TORCH_RANGE = BUILDER.comment("Range of the bat torch.").defineInRange("bat_torch_range", 64, 0, Integer.MAX_VALUE);
        BUILDER.comment("Config for hostile mob spawn blocking torches").push("hostile");
        SMALL_TORCH_RANGE = BUILDER.comment("Range of the small torch.").defineInRange("small_torch_range", 16, 0, Integer.MAX_VALUE);
        MEDIUM_TORCH_RANGE = BUILDER.comment("Range of the medium torch.").defineInRange("medium_torch_range", 32, 0, Integer.MAX_VALUE);
        GRAND_TORCH_RANGE = BUILDER.comment("Range of the grand torch.").defineInRange("grand_torch_range", 64, 0, Integer.MAX_VALUE);
        MEGA_TORCH_RANGE = BUILDER.comment("Range of the mega torch.").defineInRange("mega_torch_range", 128, 0, Integer.MAX_VALUE);
        HOSTILE_BLOCKED_ENTITIES = BUILDER.comment("Entities blocked by hostile mob spawn blocking torches").define("blocked_entities", ServerConfig.buildBlockedEntities());
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.comment("Config for the sound muffling torches").push("sound_mufflers");
        SOUND_MUFFLING_TORCH_RANGE = BUILDER.comment("Range of the sound muffling torch.").defineInRange("sound_muffling_torch_range", 64, 0, Integer.MAX_VALUE);
        SOUND_MUFFLING_TORCH_TO_MUFFLE_SOUNDS = BUILDER.comment(new String[]{"Sound categories that shall be muffled by the sound muffling torch", "Available Sound Categories: " + ServerConfig.buildSoundCategories()}).define("sound_muffling_torch_to_muffle_sounds", Stream.of(SoundSource.HOSTILE, SoundSource.NEUTRAL, SoundSource.BLOCKS, SoundSource.RECORDS).map(Enum::name).collect(Collectors.toList()), o -> {
            Object values$temp = o;
            if (values$temp instanceof List) {
                List values = (List)values$temp;
                List avaiableValues = Arrays.stream(SoundSource.values()).map(Enum::name).collect(Collectors.toList());
                for (Object value : values) {
                    if (value instanceof String && avaiableValues.contains((String)value)) continue;
                    return false;
                }
                return true;
            }
            return false;
        });
        BUILDER.pop();
        BUILDER.comment("Config for the chicken egg torch").push("chicken_egg_torch");
        CHICKEN_EGG_TORCH_RANGE = BUILDER.comment("Range of the chicken egg torch.").defineInRange("range", 16, 0, Integer.MAX_VALUE);
        SHOULD_INVERT_CHICKEN_EGG_BLOCKING = BUILDER.comment(new String[]{"If 'false' chicken egg spawning is allowed and is blocked by chicken egg torches.", "If 'true' chicken egg spawning is disabled and is enabled by chicken egg torches."}).define("should_invert_chicken_egg_blocking", false);
        BUILDER.pop();
        CONFIG = BUILDER.build();
    }
}

