/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.magical_torches.elements.blocks.torches.spawn_blocking;

import de.geheimagentnr1.magical_torches.config.ServerConfig;
import de.geheimagentnr1.magical_torches.elements.blocks.BlockRenderTypeInterface;
import de.geheimagentnr1.magical_torches.elements.blocks.ModBlocks;
import de.geheimagentnr1.magical_torches.elements.blocks.torches.spawn_blocking.SpawnBlockingTorch;
import de.geheimagentnr1.magical_torches.elements.capabilities.spawn_blocking.spawn_blockers.BatTorchSpawnBlocker;
import de.geheimagentnr1.magical_torches.helpers.TranslationKeyHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BatTorch
extends SpawnBlockingTorch
implements BlockRenderTypeInterface {
    public static final String registry_name = "bat_torch";
    private static final VoxelShape STANDING_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0), (VoxelShape)Block.m_49796_((double)6.0, (double)7.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0));
    private static final VoxelShape HANGING_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), (VoxelShape)Block.m_49796_((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0));

    public BatTorch() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(3.5f).m_60918_(SoundType.f_56762_), registry_name, BatTorchSpawnBlocker.registry_name, BatTorchSpawnBlocker::new);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61435_, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public RenderType getRenderType() {
        return RenderType.m_110463_();
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61435_) != false ? HANGING_SHAPE : STANDING_SHAPE;
    }

    @Override
    protected MutableComponent getInformation() {
        return new TranslatableComponent(TranslationKeyHelper.buildTooltipTranslationKey("spawn_blocking_bat"), new Object[]{ServerConfig.getAloneTorchRange()});
    }

    private static Direction hangingToDirection(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61435_) != false ? Direction.DOWN : Direction.UP;
    }

    @Nullable
    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        for (Direction direction : context.m_6232_()) {
            BlockState blockstate;
            if (direction.m_122434_() != Direction.Axis.Y || !(blockstate = (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61435_, (Comparable)Boolean.valueOf(direction == Direction.UP))).m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return blockstate;
        }
        return null;
    }

    @Nonnull
    public BlockState m_7417_(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        return BatTorch.hangingToDirection(state).m_122424_() == facing && !state.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7898_(@Nonnull BlockState state, @Nonnull LevelReader level, @Nonnull BlockPos pos) {
        Direction direction = BatTorch.hangingToDirection(state).m_122424_();
        return Block.m_49863_((LevelReader)level, (BlockPos)pos.m_142300_(direction), (Direction)direction.m_122424_());
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61435_});
    }

    @Override
    public Item getBlockItem(Item.Properties properties) {
        return this.createBlockItem(ModBlocks.BAT_TORCH, properties, registry_name);
    }
}

