/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.magical_torches.elements.capabilities.chicken_egg_spawning;

import de.geheimagentnr1.magical_torches.config.ServerConfig;
import de.geheimagentnr1.magical_torches.elements.capabilities.ICapabilityDataFactory;
import de.geheimagentnr1.magical_torches.elements.capabilities.ModCapabilities;
import de.geheimagentnr1.magical_torches.elements.capabilities.spawn_blocking.ISpawnBlockerFactory;
import de.geheimagentnr1.magical_torches.elements.capabilities.spawn_blocking.SpawnBlocker;
import de.geheimagentnr1.magical_torches.helpers.NBTHelper;
import de.geheimagentnr1.magical_torches.helpers.RadiusHelper;
import de.geheimagentnr1.magical_torches.helpers.ResourceLocationBuilder;
import de.geheimagentnr1.magical_torches.helpers.SpawnBlockerHelper;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class ChickenEggSpawningCapability
implements ICapabilitySerializable<ListTag> {
    public static final ResourceLocation registry_name = ResourceLocationBuilder.build("chicken_egg_spawing");
    private final LazyOptional<ChickenEggSpawningCapability> capability = LazyOptional.of(() -> this);
    private TreeSet<SpawnBlocker> spawnBlockers = SpawnBlockerHelper.buildSpawnBlockerTreeSet();
    private static final TreeMap<ResourceLocation, ICapabilityDataFactory<SpawnBlocker>> SPAWN_BLOCKING_REGISTERY = new TreeMap();

    public static void registerChickenEggBlocker(ResourceLocation _registry_name, ISpawnBlockerFactory factory) {
        SPAWN_BLOCKING_REGISTERY.put(_registry_name, factory);
    }

    public boolean shouldBlockChickenEggSpawn(Entity entity) {
        if (entity instanceof ItemEntity && ((ItemEntity)entity).m_32055_().m_41720_() == Items.f_42521_) {
            BlockPos spawn_pos = entity.m_142538_();
            boolean block = false;
            for (SpawnBlocker spawnBlocker : this.spawnBlockers) {
                if (!spawnBlocker.shouldBlockEntity(entity) || !RadiusHelper.isEventInRadiusOfBlock(spawn_pos, spawnBlocker.getPos(), spawnBlocker.getRange())) continue;
                block = true;
                break;
            }
            if (ServerConfig.getShouldInvertChickenEggBlocking()) {
                block = !block;
            }
            return block;
        }
        return false;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ModCapabilities.CHICKEN_EGG_SPAWNING) {
            return this.capability.cast();
        }
        return LazyOptional.empty();
    }

    public ListTag serializeNBT() {
        return NBTHelper.serialize(this.spawnBlockers);
    }

    public void deserializeNBT(ListTag nbt) {
        this.spawnBlockers = NBTHelper.deserialize(nbt, SPAWN_BLOCKING_REGISTERY);
    }

    public void addSpawnBlocker(SpawnBlocker spawnBlocker) {
        this.spawnBlockers.add(spawnBlocker);
    }

    public void removeSpawnBlocker(SpawnBlocker spawnBlocker) {
        this.spawnBlockers.remove(spawnBlocker);
    }
}

