/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.magical_torches.elements.capabilities.sound_muffling;

import de.geheimagentnr1.magical_torches.elements.capabilities.ICapabilityDataFactory;
import de.geheimagentnr1.magical_torches.elements.capabilities.ModCapabilities;
import de.geheimagentnr1.magical_torches.elements.capabilities.sound_muffling.ISoundMufflerFactory;
import de.geheimagentnr1.magical_torches.elements.capabilities.sound_muffling.SoundMuffler;
import de.geheimagentnr1.magical_torches.helpers.NBTHelper;
import de.geheimagentnr1.magical_torches.helpers.ResourceLocationBuilder;
import de.geheimagentnr1.magical_torches.helpers.SoundMufflerHelper;
import de.geheimagentnr1.magical_torches.network.AddSoundMufflerMsg;
import de.geheimagentnr1.magical_torches.network.RemoveSoundMufflerMsg;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class SoundMufflingCapability
implements ICapabilitySerializable<ListTag> {
    public static final ResourceLocation registry_name = ResourceLocationBuilder.build("sound_muffling");
    private final LazyOptional<SoundMufflingCapability> capability = LazyOptional.of(() -> this);
    private TreeSet<SoundMuffler> soundMufflers = SoundMufflerHelper.buildSoundMufflersTreeSet();
    private static final TreeMap<ResourceLocation, ICapabilityDataFactory<SoundMuffler>> SOUND_MUFFLING_REGISTERY = new TreeMap();

    public static void registerSoundMufflers(ResourceLocation _registry_name, ISoundMufflerFactory factory) {
        SOUND_MUFFLING_REGISTERY.put(_registry_name, factory);
    }

    public static SoundMuffler buildSoundMuffler(ResourceLocation soundMufflerRegistryName, BlockPos pos) {
        return SOUND_MUFFLING_REGISTERY.get(soundMufflerRegistryName).build(pos);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ModCapabilities.SOUND_MUFFLING) {
            return this.capability.cast();
        }
        return LazyOptional.empty();
    }

    public ListTag serializeNBT() {
        return NBTHelper.serialize(this.soundMufflers);
    }

    public void deserializeNBT(ListTag nbt) {
        this.soundMufflers = NBTHelper.deserialize(nbt, SOUND_MUFFLING_REGISTERY);
    }

    public void addSoundMuffler(ResourceKey<Level> dimension, SoundMuffler soundMuffler) {
        this.soundMufflers.add(soundMuffler);
        AddSoundMufflerMsg.sendToAll(dimension.m_135782_(), soundMuffler);
    }

    public void removeSoundMuffler(ResourceKey<Level> dimension, SoundMuffler soundMuffler) {
        this.soundMufflers.remove(soundMuffler);
        RemoveSoundMufflerMsg.sendToAll(dimension.m_135782_(), soundMuffler);
    }

    public TreeSet<SoundMuffler> getSoundMufflers() {
        return this.soundMufflers;
    }
}

