/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.magical_torches.elements.capabilities.spawn_blocking;

import de.geheimagentnr1.magical_torches.elements.capabilities.ICapabilityDataFactory;
import de.geheimagentnr1.magical_torches.elements.capabilities.ModCapabilities;
import de.geheimagentnr1.magical_torches.elements.capabilities.spawn_blocking.ISpawnBlockerFactory;
import de.geheimagentnr1.magical_torches.elements.capabilities.spawn_blocking.SpawnBlocker;
import de.geheimagentnr1.magical_torches.helpers.NBTHelper;
import de.geheimagentnr1.magical_torches.helpers.RadiusHelper;
import de.geheimagentnr1.magical_torches.helpers.ResourceLocationBuilder;
import de.geheimagentnr1.magical_torches.helpers.SpawnBlockerHelper;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class SpawnBlockingCapability
implements ICapabilitySerializable<ListTag> {
    public static final ResourceLocation registry_name = ResourceLocationBuilder.build("spawn_blocking");
    private final LazyOptional<SpawnBlockingCapability> capability = LazyOptional.of(() -> this);
    private TreeSet<SpawnBlocker> spawnBlockers = SpawnBlockerHelper.buildSpawnBlockerTreeSet();
    private static final TreeMap<ResourceLocation, ICapabilityDataFactory<SpawnBlocker>> SPAWN_BLOCKING_REGISTERY = new TreeMap();

    public static void registerSpawnBlocker(ResourceLocation _registry_name, ISpawnBlockerFactory factory) {
        SPAWN_BLOCKING_REGISTERY.put(_registry_name, factory);
    }

    public boolean shouldBlockEntitySpawn(Entity entity) {
        BlockPos spawn_pos = entity.m_142538_();
        for (SpawnBlocker spawnBlocker : this.spawnBlockers) {
            if (!spawnBlocker.shouldBlockEntity(entity) || !RadiusHelper.isEventInRadiusOfBlock(spawn_pos, spawnBlocker.getPos(), spawnBlocker.getRange())) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ModCapabilities.SPAWN_BLOCKING) {
            return this.capability.cast();
        }
        return LazyOptional.empty();
    }

    public ListTag serializeNBT() {
        return NBTHelper.serialize(this.spawnBlockers);
    }

    public void deserializeNBT(ListTag nbt) {
        this.spawnBlockers = NBTHelper.deserialize(nbt, SPAWN_BLOCKING_REGISTERY);
    }

    public void addSpawnBlocker(SpawnBlocker spawnBlocker) {
        this.spawnBlockers.add(spawnBlocker);
    }

    public void removeSpawnBlocker(SpawnBlocker spawnBlocker) {
        this.spawnBlockers.remove(spawnBlocker);
    }
}

