/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.magical_torches.handlers;

import de.geheimagentnr1.magical_torches.config.SoundMufflersHolder;
import de.geheimagentnr1.magical_torches.elements.capabilities.ModCapabilities;
import de.geheimagentnr1.magical_torches.elements.capabilities.chicken_egg_spawning.ChickenEggSpawningCapability;
import de.geheimagentnr1.magical_torches.elements.capabilities.sound_muffling.SoundMuffler;
import de.geheimagentnr1.magical_torches.elements.capabilities.sound_muffling.SoundMufflingCapability;
import de.geheimagentnr1.magical_torches.elements.capabilities.spawn_blocking.SpawnBlockingCapability;
import de.geheimagentnr1.magical_torches.helpers.RadiusHelper;
import de.geheimagentnr1.magical_torches.network.InitSoundMufflersMsg;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="magical_torches", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventHandler {
    @SubscribeEvent
    public static void handlePlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        Player player2 = player;
        if (player2 instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player2;
            InitSoundMufflersMsg.sendToPlayer(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void handleWorldAttachCapabilityEvent(AttachCapabilitiesEvent<Level> event) {
        event.addCapability(ChickenEggSpawningCapability.registry_name, (ICapabilityProvider)new ChickenEggSpawningCapability());
        event.addCapability(SpawnBlockingCapability.registry_name, (ICapabilityProvider)new SpawnBlockingCapability());
        event.addCapability(SoundMufflingCapability.registry_name, (ICapabilityProvider)new SoundMufflingCapability());
    }

    private static void blockSpawning(Level world, EntityEvent event, Entity entity) {
        world.getCapability(ModCapabilities.SPAWN_BLOCKING).ifPresent(capability -> {
            if (capability.shouldBlockEntitySpawn(entity)) {
                event.setResult(Event.Result.DENY);
            }
        });
    }

    @SubscribeEvent
    public static void handleCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getResult() == Event.Result.ALLOW || event.isSpawner()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            return;
        }
        ForgeEventHandler.blockSpawning(entity.m_20193_(), (EntityEvent)event, entity);
    }

    @SubscribeEvent
    public static void handleEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (event.getResult() == Event.Result.ALLOW) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            return;
        }
        Level level = event.getWorld();
        level.getCapability(ModCapabilities.CHICKEN_EGG_SPAWNING).ifPresent(capability -> {
            if (capability.shouldBlockChickenEggSpawn(entity)) {
                event.setCanceled(true);
            }
        });
        if (!event.isCanceled()) {
            ForgeEventHandler.blockSpawning(level, (EntityEvent)event, entity);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void handlePlaySoundEvent(PlaySoundEvent event) {
        if (event.getResult() == Event.Result.ALLOW) {
            return;
        }
        SoundInstance sound = event.getSound();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            BlockPos sound_pos = new BlockPos(sound.m_7772_(), sound.m_7780_(), sound.m_7778_());
            SoundMufflersHolder.getDimensionSoundMufflers((ResourceKey<Level>)level.m_46472_()).ifPresent(soundMufflers -> {
                for (SoundMuffler soundMuffler : soundMufflers) {
                    if (!soundMuffler.shouldMuffleSound(sound) || !RadiusHelper.isEventInRadiusOfBlock(sound_pos, soundMuffler.getPos(), soundMuffler.getRange())) continue;
                    event.setResultSound(null);
                    event.setResult(Event.Result.DENY);
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void handleLogoutEvent(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        SoundMufflersHolder.clear();
    }
}

