/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.magical_torches.helpers;

import de.geheimagentnr1.magical_torches.elements.capabilities.CapabilityData;
import de.geheimagentnr1.magical_torches.elements.capabilities.ICapabilityDataFactory;
import java.util.Comparator;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class NBTHelper {
    private static final String registryNameName = "registry_name";
    private static final String xName = "x";
    private static final String yName = "y";
    private static final String zName = "z";

    public static <T extends CapabilityData> ListTag serialize(TreeSet<T> capabilityDatas) {
        ListTag nbt = new ListTag();
        for (CapabilityData capabilityData : capabilityDatas) {
            BlockPos pos = capabilityData.getPos();
            CompoundTag compoundNBT = new CompoundTag();
            compoundNBT.m_128359_(registryNameName, capabilityData.getRegistryName().toString());
            compoundNBT.m_128405_(xName, pos.m_123341_());
            compoundNBT.m_128405_(yName, pos.m_123342_());
            compoundNBT.m_128405_(zName, pos.m_123343_());
            nbt.add((Object)compoundNBT);
        }
        return nbt;
    }

    public static <T extends CapabilityData> TreeSet<T> deserialize(ListTag nbt, TreeMap<ResourceLocation, ICapabilityDataFactory<T>> capabilityDataRegistery) {
        TreeSet<CapabilityData> capabilityDatas = new TreeSet<CapabilityData>(Comparator.comparing(CapabilityData::getPos));
        for (Tag inbt : nbt) {
            String registry_name_string;
            ResourceLocation registry_name;
            CompoundTag compoundNBT;
            Tag tag = inbt;
            if (!(tag instanceof CompoundTag) || !(compoundNBT = (CompoundTag)tag).m_128425_(registryNameName, 8) || (registry_name = ResourceLocation.m_135820_((String)(registry_name_string = compoundNBT.m_128461_(registryNameName)))) == null || !compoundNBT.m_128425_(xName, 3) || !compoundNBT.m_128425_(yName, 3) || !compoundNBT.m_128425_(zName, 3)) continue;
            BlockPos pos = new BlockPos(compoundNBT.m_128451_(xName), compoundNBT.m_128451_(yName), compoundNBT.m_128451_(zName));
            ICapabilityDataFactory<T> factory = capabilityDataRegistery.get(registry_name);
            if (factory == null) continue;
            capabilityDatas.add((CapabilityData)factory.build(pos));
        }
        return capabilityDatas;
    }
}

