/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.magical_torches.network;

import de.geheimagentnr1.magical_torches.config.SoundMufflersHolder;
import de.geheimagentnr1.magical_torches.elements.capabilities.ModCapabilities;
import de.geheimagentnr1.magical_torches.elements.capabilities.sound_muffling.SoundMuffler;
import de.geheimagentnr1.magical_torches.elements.capabilities.sound_muffling.SoundMufflingCapability;
import de.geheimagentnr1.magical_torches.helpers.SoundMufflerHelper;
import de.geheimagentnr1.magical_torches.network.Network;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public class InitSoundMufflersMsg {
    private final TreeMap<ResourceKey<Level>, TreeSet<SoundMuffler>> soundMufflers;

    private InitSoundMufflersMsg(TreeMap<ResourceKey<Level>, TreeSet<SoundMuffler>> _soundMufflers) {
        this.soundMufflers = _soundMufflers;
    }

    static InitSoundMufflersMsg decode(FriendlyByteBuf buffer) {
        TreeMap<ResourceKey<Level>, TreeSet<SoundMuffler>> dimensionSoundMufflers = SoundMufflerHelper.buildDimensionSoundMufflersTreeMap();
        int dimensionCount = buffer.readInt();
        for (int i = 0; i < dimensionCount; ++i) {
            ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)buffer.m_130281_());
            TreeSet<SoundMuffler> soundMufflers = SoundMufflerHelper.buildSoundMufflersTreeSet();
            dimensionSoundMufflers.put((ResourceKey<Level>)dimension, soundMufflers);
            int soundMufflersCount = buffer.readInt();
            for (int j = 0; j < soundMufflersCount; ++j) {
                soundMufflers.add(SoundMufflingCapability.buildSoundMuffler(buffer.m_130281_(), buffer.m_130135_()));
            }
        }
        return new InitSoundMufflersMsg(dimensionSoundMufflers);
    }

    void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.soundMufflers.size());
        this.soundMufflers.forEach((dimension, soundMufflersSet) -> {
            buffer.m_130085_(Objects.requireNonNull(dimension.m_135782_()));
            buffer.writeInt(soundMufflersSet.size());
            soundMufflersSet.forEach(soundMuffler -> {
                buffer.m_130085_(soundMuffler.getRegistryName());
                buffer.m_130064_(soundMuffler.getPos());
            });
        });
    }

    public static void sendToPlayer(ServerPlayer player) {
        TreeMap<ResourceKey<Level>, TreeSet<SoundMuffler>> dimensionSoundMufflers = SoundMufflerHelper.buildDimensionSoundMufflersTreeMap();
        Objects.requireNonNull(player.m_20194_()).m_129785_().forEach(serverLevel -> {
            TreeSet<SoundMuffler> soundMufflers = SoundMufflerHelper.buildSoundMufflersTreeSet();
            dimensionSoundMufflers.put(serverLevel.m_46472_(), soundMufflers);
            serverLevel.getCapability(ModCapabilities.SOUND_MUFFLING).ifPresent(soundMufflingCapability -> soundMufflers.addAll(soundMufflingCapability.getSoundMufflers()));
        });
        Network.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new InitSoundMufflersMsg(dimensionSoundMufflers));
    }

    static void handle(InitSoundMufflersMsg initSoundMufflersMsg, Supplier<NetworkEvent.Context> contextSupplier) {
        SoundMufflersHolder.setDimensionSoundMufflers(initSoundMufflersMsg.soundMufflers);
        contextSupplier.get().setPacketHandled(true);
    }
}

