/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.magical_torches.network;

import de.geheimagentnr1.magical_torches.config.SoundMufflersHolder;
import de.geheimagentnr1.magical_torches.elements.capabilities.sound_muffling.SoundMuffler;
import de.geheimagentnr1.magical_torches.elements.capabilities.sound_muffling.SoundMufflingCapability;
import de.geheimagentnr1.magical_torches.helpers.SoundMufflerHelper;
import de.geheimagentnr1.magical_torches.network.Network;
import java.util.TreeSet;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public class RemoveSoundMufflerMsg {
    private final ResourceLocation dimensionRegistryName;
    private final ResourceLocation soundMufflerRegistryName;
    private final BlockPos pos;

    private RemoveSoundMufflerMsg(ResourceLocation _dimensionRegistryName, ResourceLocation _soundMufflerRegistryName, BlockPos _pos) {
        this.dimensionRegistryName = _dimensionRegistryName;
        this.soundMufflerRegistryName = _soundMufflerRegistryName;
        this.pos = _pos;
    }

    static RemoveSoundMufflerMsg decode(FriendlyByteBuf buffer) {
        return new RemoveSoundMufflerMsg(buffer.m_130281_(), buffer.m_130281_(), buffer.m_130135_());
    }

    void encode(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.dimensionRegistryName);
        buffer.m_130085_(this.soundMufflerRegistryName);
        buffer.m_130064_(this.pos);
    }

    public static void sendToAll(ResourceLocation dimension, SoundMuffler soundMuffler) {
        Network.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new RemoveSoundMufflerMsg(dimension, soundMuffler.getRegistryName(), soundMuffler.getPos()));
    }

    static void handle(RemoveSoundMufflerMsg removeSoundMufflerMsg, Supplier<NetworkEvent.Context> contextSupplier) {
        ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)removeSoundMufflerMsg.dimensionRegistryName);
        TreeSet<SoundMuffler> list = SoundMufflersHolder.getDimensionSoundMufflers((ResourceKey<Level>)dimension).orElse(SoundMufflerHelper.buildSoundMufflersTreeSet());
        list.remove(SoundMufflingCapability.buildSoundMuffler(removeSoundMufflerMsg.soundMufflerRegistryName, removeSoundMufflerMsg.pos));
        SoundMufflersHolder.getDimensionSoundMufflers().put((ResourceKey<Level>)dimension, list);
        contextSupplier.get().setPacketHandled(true);
    }
}

