/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.lifecycle;

import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2735;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.server.MinecraftServer;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.item.MapAtlasItem;
import pepjebs.mapatlases.networking.MapAtlasesInitAtlasS2CPacket;
import pepjebs.mapatlases.networking.MapAtlasesOpenGUIC2SPacket;
import pepjebs.mapatlases.utils.MapAtlasesAccessUtils;

public class MapAtlasesServerLifecycleEvents {
    private static final HashMap<String, Integer> lastMapCreationSize = new HashMap();
    private static final int NEW_MAP_CENTER_DISTANCE = 90;

    public static void openGuiEvent(MinecraftServer server, class_3222 player, class_3244 _handler, class_2540 buf, PacketSender _responseSender) {
        MapAtlasesOpenGUIC2SPacket p = new MapAtlasesOpenGUIC2SPacket();
        p.method_11053(buf);
        server.execute(() -> {
            class_1799 atlas = p.atlas;
            int atlasIdx = player.field_7514.field_7547.size();
            for (int i = 0; i < player.field_7514.field_7547.size(); ++i) {
                if (((class_1799)player.field_7514.field_7547.get(i)).method_7909() != atlas.method_7909() || ((class_1799)player.field_7514.field_7547.get(i)).method_7969() == null || atlas.method_7969() == null || ((class_1799)player.field_7514.field_7547.get(i)).method_7969().toString().compareTo(atlas.method_7969().toString()) != 0) continue;
                atlasIdx = i;
                break;
            }
            if (atlasIdx < class_1661.method_7368()) {
                player.field_7514.field_7545 = atlasIdx;
                player.field_13987.method_14364((class_2596)new class_2735(atlasIdx));
                player.method_17355((class_3908)((MapAtlasItem)atlas.method_7909()));
                player.method_14220().method_8396(null, player.method_24515(), MapAtlasesMod.ATLAS_OPEN_SOUND_EVENT, class_3419.field_15248, 1.0f, 1.0f);
            }
        });
    }

    public static void mapAtlasPlayerJoin(class_3244 serverPlayNetworkHandler, PacketSender _responseSender, MinecraftServer _server) {
        class_3222 player = serverPlayNetworkHandler.field_14140;
        class_1799 atlas = player.field_7514.field_7547.stream().filter(is -> is.method_7929(new class_1799((class_1935)MapAtlasesMod.MAP_ATLAS))).findAny().orElse(class_1799.field_8037);
        if (atlas.method_7960()) {
            return;
        }
        List<class_22> mapStates = MapAtlasesAccessUtils.getAllMapStatesFromAtlas((class_1937)player.method_14220(), atlas);
        for (class_22 state : mapStates) {
            state.method_102((class_1657)player, atlas);
            state.method_101((class_1657)player);
            class_2540 packetByteBuf = new class_2540(Unpooled.buffer());
            new MapAtlasesInitAtlasS2CPacket(state).method_11052(packetByteBuf);
            player.field_13987.method_14364((class_2596)new class_2658(MapAtlasesInitAtlasS2CPacket.MAP_ATLAS_INIT, packetByteBuf));
            MapAtlasesMod.LOGGER.info("Server Sent MapState: " + state.method_76());
        }
    }

    public static void mapAtlasServerTick(MinecraftServer server) {
        for (class_3222 player : server.method_3760().method_14571()) {
            int lastMapSize;
            class_1799 atlas = player.field_7514.field_7547.stream().filter(is -> is.method_7929(new class_1799((class_1935)MapAtlasesMod.MAP_ATLAS))).findAny().orElse(class_1799.field_8037);
            if (atlas.method_7960()) continue;
            List<class_22> mapStates = MapAtlasesAccessUtils.getAllMapStatesFromAtlas((class_1937)player.method_14220(), atlas);
            int playX = player.method_24515().method_10263();
            int playZ = player.method_24515().method_10260();
            int minDist = Integer.MAX_VALUE;
            int scale = -1;
            for (class_22 state : mapStates) {
                state.method_102((class_1657)player, atlas);
                ((class_1806)class_1802.field_8204).method_7998((class_1937)player.method_14220(), (class_1297)player, state);
                class_1799 map = MapAtlasesAccessUtils.createMapItemStackFromStrId(state.method_76());
                class_2596 p = null;
                for (int tries = 0; p == null && tries < 10; ++tries) {
                    p = state.method_100(map, (class_1922)player.method_14220(), (class_1657)player);
                }
                if (p != null) {
                    class_2540 packetByteBuf = new class_2540(Unpooled.buffer());
                    try {
                        p.method_11052(packetByteBuf);
                        player.field_13987.method_14364((class_2596)new class_2658(MapAtlasesInitAtlasS2CPacket.MAP_ATLAS_SYNC, packetByteBuf));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                int mapCX = state.field_116;
                int mapCZ = state.field_115;
                minDist = Math.min(minDist, (int)Math.hypot(playX - mapCX, playZ - mapCZ));
                scale = state.field_119;
            }
            if (atlas.method_7969() == null) continue;
            List mapIds = Arrays.stream(atlas.method_7969().method_10561("maps")).boxed().collect(Collectors.toList());
            int mapSize = mapIds.size();
            int emptyCount = MapAtlasesAccessUtils.getEmptyMapCountFromItemStack(atlas);
            if (!lastMapCreationSize.containsKey(player.method_5477().getString())) {
                lastMapCreationSize.put(player.method_5477().getString(), -1);
            }
            if ((lastMapSize = lastMapCreationSize.get(player.method_5477().getString()).intValue()) == mapSize || minDist == -1 || scale == -1 || minDist <= 90 * (1 << scale) || emptyCount <= 0) continue;
            atlas.method_7969().method_10569("empty", atlas.method_7969().method_10550("empty") - 1);
            class_1799 newMap = class_1806.method_8005((class_1937)player.method_14220(), (int)class_3532.method_15357((double)player.method_23317()), (int)class_3532.method_15357((double)player.method_23321()), (byte)((byte)scale), (boolean)true, (boolean)false);
            lastMapCreationSize.put(player.method_5477().getString(), mapIds.size());
            mapIds.add(class_1806.method_8003((class_1799)newMap));
            atlas.method_7969().method_10572("maps", mapIds);
            player.method_14220().method_8396(null, player.method_24515(), MapAtlasesMod.ATLAS_CREATE_MAP_SOUND_EVENT, class_3419.field_15248, 1.0f, 1.0f);
        }
    }
}

