/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.screen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_20;
import net.minecraft.class_22;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_465;
import pepjebs.mapatlases.client.ui.MapAtlasesHUD;
import pepjebs.mapatlases.screen.MapAtlasesAtlasOverviewScreenHandler;
import pepjebs.mapatlases.utils.MapAtlasesAccessUtils;

public class MapAtlasesAtlasOverviewScreen
extends class_465<class_1703> {
    private static final int ZOOM_BUCKET = 4;
    private static final int PAN_BUCKET = 25;
    private final class_1799 atlas;
    public Map<Integer, List<Integer>> idsToCenters;
    private int mouseXOffset = 0;
    private int mouseYOffset = 0;
    private int zoomValue = 4;
    private Map<Integer, List<Double>> zoomMapping;

    public MapAtlasesAtlasOverviewScreen(class_1703 handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
        this.atlas = MapAtlasesAccessUtils.getAtlasFromItemStacks((List<class_1799>)inventory.field_7547);
        this.idsToCenters = ((MapAtlasesAtlasOverviewScreenHandler)handler).idsToCenters;
        this.zoomMapping = new HashMap<Integer, List<Double>>(){
            {
                this.put(1, Arrays.asList(1.0, 1.29));
                this.put(3, Arrays.asList(55.0, 0.43));
                this.put(5, Arrays.asList(33.0, 0.26));
                this.put(7, Arrays.asList(24.0, 0.19));
            }
        };
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        this.method_2389(matrices, delta, mouseX, mouseY);
    }

    protected void method_2389(class_4587 matrices, float delta, int mouseX, int mouseY) {
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            return;
        }
        int zoomLevel = this.round(this.zoomValue, 4) / 4;
        zoomLevel = Math.max(zoomLevel, 0);
        zoomLevel = Math.min(zoomLevel, this.zoomMapping.size() - 1);
        int loopBegin = -1 * zoomLevel;
        int loopEnd = zoomLevel + 1;
        zoomLevel = 2 * zoomLevel + 1;
        List<Double> zoomingInfo = this.zoomMapping.get(zoomLevel);
        int mapTextureTranslate = zoomingInfo.get(0).intValue();
        float mapTextureScale = zoomingInfo.get(1).floatValue();
        double y = (double)(this.field_22790 - this.field_2779) / 2.0;
        double x = (double)(this.field_22789 - this.field_2792) / 2.0;
        this.field_22787.method_1531().method_22813(MapAtlasesHUD.MAP_CHKRBRD);
        MapAtlasesAtlasOverviewScreen.method_25290((class_4587)matrices, (int)((int)x), (int)((int)y), (float)0.0f, (float)0.0f, (int)180, (int)180, (int)180, (int)180);
        List<class_22> mapStates = MapAtlasesAccessUtils.getAllMapStatesFromAtlas((class_1937)this.field_22787.field_1687, this.atlas);
        class_22 activeState = MapAtlasesAccessUtils.getActiveAtlasMapState(this.field_22787.field_1724.field_6002, this.atlas);
        if (activeState == null) {
            if (!mapStates.isEmpty()) {
                activeState = mapStates.get(0);
            } else {
                return;
            }
        }
        int activeMapId = MapAtlasesAccessUtils.getMapIntFromState(activeState);
        int activeXCenter = this.idsToCenters.get(activeMapId).get(0);
        int activeZCenter = this.idsToCenters.get(activeMapId).get(1);
        activeXCenter += this.round(this.mouseXOffset, 25) / 25 * (1 << activeState.field_119) * -128;
        activeZCenter += this.round(this.mouseYOffset, 25) / 25 * (1 << activeState.field_119) * -128;
        for (int i = loopBegin; i < loopEnd; ++i) {
            for (int j = loopBegin; j < loopEnd; ++j) {
                double mapTextY = (double)(this.field_22790 - this.field_2779) / 2.0 + 8.0;
                double mapTextX = (double)(this.field_22789 - this.field_2792) / 2.0 + 8.0;
                int reqXCenter = activeXCenter + j * (1 << activeState.field_119) * 128;
                int reqZCenter = activeZCenter + i * (1 << activeState.field_119) * 128;
                class_22 state = mapStates.stream().filter(m -> this.idsToCenters.get(MapAtlasesAccessUtils.getMapIntFromState(m)).get(0) == reqXCenter && this.idsToCenters.get(MapAtlasesAccessUtils.getMapIntFromState(m)).get(1) == reqZCenter).findFirst().orElse(null);
                if (state == null) continue;
                class_4597.class_4598 vcp = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
                matrices.method_22903();
                matrices.method_22904(mapTextX += (double)(mapTextureTranslate * (j + loopEnd - 1)), mapTextY += (double)(mapTextureTranslate * (i + loopEnd - 1)), 0.0);
                matrices.method_22905(mapTextureScale, mapTextureScale, 0.0f);
                Iterator it = state.field_117.entrySet().iterator();
                ArrayList removed = new ArrayList();
                if (state.method_76().compareTo(activeState.method_76()) != 0) {
                    while (it.hasNext()) {
                        Map.Entry e = it.next();
                        if (((class_20)e.getValue()).method_93() != class_20.class_21.field_86 && ((class_20)e.getValue()).method_93() != class_20.class_21.field_87) continue;
                        it.remove();
                        removed.add(e);
                    }
                }
                this.field_22787.field_1773.method_3194().method_1773(matrices, (class_4597)vcp, state, false, Integer.parseInt("0000000011110000", 2));
                vcp.method_22993();
                matrices.method_22909();
                for (Map.Entry entry : removed) {
                    state.field_117.put(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0) {
            this.mouseXOffset = (int)((double)this.mouseXOffset + deltaX);
            this.mouseYOffset = (int)((double)this.mouseYOffset + deltaY);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        this.zoomValue = (int)((double)this.zoomValue + -1.0 * amount);
        this.zoomValue = Math.max(this.zoomValue, -4);
        this.zoomValue = Math.min(this.zoomValue, this.zoomMapping.size() * 4);
        return true;
    }

    private int round(int num, int mod) {
        int t = num % mod;
        if (t < (int)Math.floor((double)mod / 2.0)) {
            return num - t;
        }
        return num + mod - t;
    }
}

