/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.menucompanions.client.storage;

import com.fuzs.menucompanions.client.element.MenuEntityElement;
import com.fuzs.menucompanions.client.storage.MenuEntryBuilder;
import com.fuzs.menucompanions.client.storage.entry.EntityMenuEntry;
import com.fuzs.menucompanions.client.storage.entry.PropertyFlag;
import com.fuzs.puzzleslib_mc.config.json.JsonConfigFileUtil;
import com.fuzs.puzzleslib_mc.util.PuzzlesLibUtil;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;

public class MenuEntityProvider {
    private static final List<EntityMenuEntry> MENU_ENTRIES = Lists.newArrayList();
    private static final List<EntityMenuEntry> DEFAULT_MENU_ENTRIES = Lists.newArrayList((Object[])new EntityMenuEntry[]{new MenuEntryBuilder().setType(EntityType.field_200729_aH).setRight().setWeight(31).renderName().build(), new MenuEntryBuilder().setType(EntityType.field_200729_aH).setRight().renderName().setNbt("{ArmorItems:[{Count:1,id:diamond_boots},{Count:1,id:diamond_leggings},{Count:1,id:diamond_chestplate},{Count:1,id:diamond_helmet}]}").build(), new MenuEntryBuilder().setType(EntityType.field_226289_e_).setLeft().setData(PropertyFlag.TICK).setScale(1.6f).setWeight(8).build(), new MenuEntryBuilder().setType(EntityType.field_226289_e_).setLeft().setData(PropertyFlag.TICK).setScale(1.6f).setWeight(7).setNbt("{HasNectar:1}").build(), new MenuEntryBuilder().setType(EntityType.field_226289_e_).setLeft().setData(PropertyFlag.TICK).setScale(1.6f).setNbt("{Anger:1}").build(), new MenuEntryBuilder().setType(EntityType.field_226289_e_).setLeft().setData(PropertyFlag.TICK).setScale(1.6f).setWeight(2).setNbt("{Age:-24000}").build(), new MenuEntryBuilder().setType(EntityType.field_226289_e_).setLeft().setData(PropertyFlag.TICK).setScale(1.6f).setWeight(2).setNbt("{Age:-24000,HasNectar:1}").build()});

    @Nullable
    public static EntityMenuEntry getRandomEntry(MenuEntityElement.MenuSide side) {
        List sidedEntries = MENU_ENTRIES.stream().filter(entry -> entry.isSide(side)).collect(Collectors.toList());
        return PuzzlesLibUtil.getRandomEntry(sidedEntries, EntityMenuEntry::getWeight);
    }

    public static void removeEntry(EntityMenuEntry entry) {
        MENU_ENTRIES.remove(entry);
    }

    public static void serialize(File jsonFile) {
        ImmutableListMultimap defaultsAsMap = Multimaps.index(DEFAULT_MENU_ENTRIES, entry -> entry.getRawType().getRegistryName().func_110623_a());
        for (Map.Entry mapEntry : defaultsAsMap.asMap().entrySet()) {
            int index = 0;
            for (EntityMenuEntry entry2 : (Collection)mapEntry.getValue()) {
                String fileName = String.format("%s%d.json", mapEntry.getKey(), ++index);
                File file = new File(jsonFile, String.join((CharSequence)File.separator, (CharSequence)mapEntry.getKey(), fileName));
                JsonConfigFileUtil.saveToFile(file, entry2.serialize());
            }
        }
    }

    public static void deserialize(FileReader reader) throws NullPointerException {
        JsonElement jsonelement = (JsonElement)JsonConfigFileUtil.GSON.fromJson((Reader)reader, JsonElement.class);
        EntityMenuEntry deserialize = MenuEntryBuilder.deserialize(jsonelement);
        if (deserialize == null) {
            throw new NullPointerException("Couldn't deserialize file");
        }
        MENU_ENTRIES.add(deserialize);
    }

    public static void clear() {
        MENU_ENTRIES.clear();
    }
}

