/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.menucompanions.client.util;

import com.fuzs.menucompanions.MenuCompanions;
import com.fuzs.menucompanions.client.element.MenuEntityElement;
import com.fuzs.menucompanions.client.entity.player.MenuClientPlayerEntity;
import com.fuzs.menucompanions.client.world.MenuClientWorld;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.io.File;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Util;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class CreateEntityUtil {
    private static GameProfile gameProfile;

    @Nullable
    public static Entity loadEntity(EntityType<?> type, CompoundNBT compound, MenuClientWorld worldIn, Function<Entity, Entity> mapper) {
        CompoundNBT compoundnbt = compound.func_74737_b();
        compoundnbt.func_74778_a("id", Objects.requireNonNull(ForgeRegistries.ENTITIES.getKey(type)).toString());
        return CreateEntityUtil.loadEntityAndExecute(compoundnbt, worldIn, mapper);
    }

    @Nullable
    public static Entity loadEntityAndExecute(CompoundNBT compound, MenuClientWorld worldIn, Function<Entity, Entity> mapper) {
        return CreateEntityUtil.loadEntity(compound, worldIn).map(mapper).map(entity -> {
            if (compound.func_150297_b("Passengers", 9)) {
                ListNBT listnbt = compound.func_150295_c("Passengers", 10);
                for (int i = 0; i < listnbt.size(); ++i) {
                    Entity passenger = CreateEntityUtil.loadEntityAndExecute(listnbt.func_150305_b(i), worldIn, mapper);
                    if (passenger == null) continue;
                    passenger.func_184205_a(entity, true);
                    entity.func_184232_k(passenger);
                }
            }
            return entity;
        }).orElse(null);
    }

    private static Optional<Entity> loadEntity(CompoundNBT compound, MenuClientWorld worldIn) {
        if (EntityType.func_220347_a((CompoundNBT)compound).map(entityType -> MenuEntityElement.get().isAllowed((EntityType<?>)entityType) ? entityType : null).isPresent()) {
            try {
                return CreateEntityUtil.loadEntityUnchecked(compound, worldIn);
            }
            catch (RuntimeException runtimeexception) {
                MenuCompanions.LOGGER.warn("Exception loading entity: ", (Throwable)runtimeexception);
                MenuEntityElement.get().addToBlacklist(compound.func_74779_i("id"));
            }
        }
        return Optional.empty();
    }

    public static Optional<Entity> loadEntityUnchecked(CompoundNBT compound, MenuClientWorld worldIn) {
        return Util.func_215077_a(EntityType.func_220347_a((CompoundNBT)compound).map(entityType -> CreateEntityUtil.create(worldIn, entityType)), entity -> {
            block2: {
                try {
                    entity.func_70020_e(compound);
                }
                catch (Exception e) {
                    if (!(entity instanceof MobEntity)) break block2;
                    CreateEntityUtil.readMobData(entity, compound);
                }
            }
        }, () -> {
            String id = compound.func_74779_i("id");
            MenuCompanions.LOGGER.warn("Skipping entity with id {}", (Object)id);
            MenuEntityElement.get().addToBlacklist(id);
        });
    }

    @Nullable
    public static Entity create(MenuClientWorld worldIn, EntityType<?> type) {
        if (type == EntityType.field_200729_aH) {
            assert (gameProfile != null) : "No game profile found";
            return new MenuClientPlayerEntity(worldIn, gameProfile);
        }
        return type.func_200721_a((World)worldIn);
    }

    public static void setGameProfile(String profile) {
        gameProfile = CreateEntityUtil.getGameProfile(profile);
    }

    private static GameProfile getGameProfile(String profile) {
        if (StringUtils.func_151246_b((String)profile)) {
            return Minecraft.func_71410_x().func_110432_I().func_148256_e();
        }
        return CreateEntityUtil.updateGameProfile(new GameProfile(null, profile));
    }

    private static GameProfile updateGameProfile(GameProfile input) {
        GameProfile gameprofile = SkullTileEntity.func_174884_b((GameProfile)input);
        if (gameprofile == input) {
            YggdrasilAuthenticationService yggdrasilauthenticationservice = new YggdrasilAuthenticationService(Minecraft.func_71410_x().func_110437_J(), UUID.randomUUID().toString());
            MinecraftSessionService minecraftsessionservice = yggdrasilauthenticationservice.createMinecraftSessionService();
            GameProfileRepository gameprofilerepository = yggdrasilauthenticationservice.createProfileRepository();
            PlayerProfileCache playerprofilecache = new PlayerProfileCache(gameprofilerepository, new File(Minecraft.func_71410_x().field_71412_D, MinecraftServer.field_152367_a.getName()));
            SkullTileEntity.func_184293_a((PlayerProfileCache)playerprofilecache);
            SkullTileEntity.func_184294_a((MinecraftSessionService)minecraftsessionservice);
            gameprofile = SkullTileEntity.func_174884_b((GameProfile)input);
        }
        return gameprofile;
    }

    public static void onInitialSpawn(Entity entity, IWorld worldIn, boolean noNbt) {
        entity.field_70173_aa = 2;
        entity.field_70145_X = true;
        if (noNbt && entity instanceof MobEntity) {
            try {
                DifficultyInstance difficulty = new DifficultyInstance(Difficulty.HARD, 100000L, 100000L, 1.0f);
                ((MobEntity)entity).func_213386_a(worldIn, difficulty, SpawnReason.COMMAND, null, null);
                if (entity instanceof AgeableEntity && ((AgeableEntity)entity).func_70681_au().nextFloat() <= 0.05f) {
                    ((AgeableEntity)entity).func_70873_a(-24000);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void readMobData(Entity entity, CompoundNBT compound) {
        ListNBT listnbt;
        if (compound.func_150297_b("ArmorItems", 9)) {
            listnbt = compound.func_150295_c("ArmorItems", 10);
            Stream.of(EquipmentSlotType.values()).filter(slot -> slot.func_188453_a() == EquipmentSlotType.Group.ARMOR).forEach(slot -> entity.func_184201_a(slot, ItemStack.func_199557_a((CompoundNBT)listnbt.func_150305_b(slot.func_188454_b()))));
        }
        if (compound.func_150297_b("HandItems", 9)) {
            listnbt = compound.func_150295_c("HandItems", 10);
            Stream.of(EquipmentSlotType.values()).filter(slot -> slot.func_188453_a() == EquipmentSlotType.Group.HAND).forEach(slot -> entity.func_184201_a(slot, ItemStack.func_199557_a((CompoundNBT)listnbt.func_150305_b(slot.func_188454_b()))));
        }
    }
}

