/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.menucompanions.client.world;

import com.fuzs.menucompanions.client.gui.EntityMenuContainer;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.particles.IParticleData;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MenuClientWorld
extends ClientWorld {
    private EntityMenuContainer activeContainer;

    public MenuClientWorld(ClientPlayNetHandler connection, WorldSettings worldSettingsIn, DimensionType dimensionType, IProfiler profiler, WorldRenderer worldRenderer) {
        super(connection, worldSettingsIn, dimensionType, 0, profiler, worldRenderer);
    }

    public void func_184134_a(double x, double y, double z, @Nonnull SoundEvent soundIn, @Nonnull SoundCategory category, float volume, float pitch, boolean distanceDelay) {
    }

    public void func_195594_a(@Nonnull IParticleData particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.func_195590_a(particleData, particleData.func_197554_b().func_197575_f(), x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void func_195590_a(@Nonnull IParticleData particleData, boolean forceAlwaysRender, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.addParticle(particleData, particleData.func_197554_b().func_197575_f() || forceAlwaysRender, false, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void func_195589_b(@Nonnull IParticleData particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.addParticle(particleData, false, true, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void func_217404_b(@Nonnull IParticleData particleData, boolean ignoreRange, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.addParticle(particleData, particleData.func_197554_b().func_197575_f() || ignoreRange, true, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void addParticle(IParticleData particleData, boolean ignoreRange, boolean minimizeLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        try {
            this.addParticleUnchecked(particleData, ignoreRange, minimizeLevel, x, y, z, xSpeed, ySpeed, zSpeed);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Exception while adding particle");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Particle being added");
            crashreportcategory.func_71507_a("ID", (Object)Objects.requireNonNull(ForgeRegistries.PARTICLE_TYPES.getKey((IForgeRegistryEntry)particleData.func_197554_b())));
            crashreportcategory.func_71507_a("Parameters", (Object)particleData.func_197555_a());
            crashreportcategory.func_189529_a("Position", () -> CrashReportCategory.func_85074_a((double)x, (double)y, (double)z));
            throw new ReportedException(crashreport);
        }
    }

    private void addParticleUnchecked(IParticleData particleData, boolean alwaysRender, boolean minimizeLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        ParticleStatus particlestatus = this.calculateParticleLevel(minimizeLevel);
        if (alwaysRender || particlestatus != ParticleStatus.MINIMAL) {
            this.activeContainer.particleManager.addParticle(particleData, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }

    private ParticleStatus calculateParticleLevel(boolean minimiseLevel) {
        ParticleStatus particlestatus = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        if (minimiseLevel && particlestatus == ParticleStatus.MINIMAL && this.field_73012_v.nextInt(10) == 0) {
            particlestatus = ParticleStatus.DECREASED;
        }
        if (particlestatus == ParticleStatus.DECREASED && this.field_73012_v.nextInt(3) == 0) {
            particlestatus = ParticleStatus.MINIMAL;
        }
        return particlestatus;
    }

    public void setActiveContainer(EntityMenuContainer container) {
        this.activeContainer = container;
    }
}

