/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.puzzleslib_mc.config;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ConfigValueData<S extends ForgeConfigSpec.ConfigValue<T>, T, R> {
    final ModConfig.Type configType;
    final S configValue;
    final Consumer<R> syncAction;
    final Function<T, R> valueTransformer;
    final String parentModid;

    ConfigValueData(ModConfig.Type configType, S configValue, Consumer<R> syncAction, Function<T, R> valueTransformer, String parentModid) {
        this.configType = configType;
        this.configValue = configValue;
        this.syncAction = syncAction;
        this.valueTransformer = valueTransformer;
        this.parentModid = parentModid;
    }

    ModConfig.Type getType() {
        return this.configType;
    }

    String getModId() {
        return this.parentModid;
    }

    public void modifyConfigValue(UnaryOperator<T> operator) {
        this.configValue.set(operator.apply(this.getRawValue()));
        this.sync();
    }

    public R getValue() {
        return this.valueTransformer.apply(this.configValue.get());
    }

    public T getRawValue() {
        return (T)this.configValue.get();
    }

    void sync() {
        this.syncAction.accept(this.getValue());
    }
}

