/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.puzzleslib_mc.config.deserialize;

import com.fuzs.puzzleslib_mc.config.deserialize.StringEntryReader;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EntryCollectionBuilder<T extends IForgeRegistryEntry<T>>
extends StringEntryReader<T> {
    public static final Function<String, String> CONFIG_STRING_BUILDER = s -> "Format for every entry is \"<namespace>:<path>" + s + "\". Path may use asterisk as wildcard parameter. Tags are not supported.";
    public static final String CONFIG_STRING = CONFIG_STRING_BUILDER.apply("");

    public EntryCollectionBuilder(IForgeRegistry<T> registry) {
        super(registry);
    }

    public Set<T> buildEntrySet(List<String> locations) {
        return this.buildEntrySet(locations, flag -> true, "");
    }

    public Map<T, double[]> buildEntryMap(List<String> locations) {
        return this.buildEntryMap(locations, (entry, value) -> true, "");
    }

    public Set<T> buildEntrySet(List<String> locations, Predicate<T> condition, String errorMessage) {
        HashSet set = Sets.newHashSet();
        for (String source : locations) {
            this.getEntriesFromRegistry(source.trim()).forEach(entry -> {
                if (condition.test(entry)) {
                    if (this.isNotPresent(set, entry)) {
                        set.add(entry);
                    }
                } else {
                    EntryCollectionBuilder.log(source, errorMessage);
                }
            });
        }
        return set;
    }

    public Map<T, double[]> buildEntryMap(List<String> locations, BiPredicate<T, double[]> condition, String errorMessage) {
        HashMap map = Maps.newHashMap();
        for (String source : locations) {
            String[] splitSource = (String[])Stream.of(source.split(",")).map(String::trim).toArray(String[]::new);
            if (splitSource.length == 0) {
                EntryCollectionBuilder.log(source, "Wrong number of arguments");
                continue;
            }
            List entries = this.getEntriesFromRegistry(splitSource[0]);
            if (entries.isEmpty()) continue;
            double[] values = Stream.of(splitSource).skip(1L).mapToDouble(value -> EntryCollectionBuilder.parseDouble(value, source)).toArray();
            for (IForgeRegistryEntry entry : entries) {
                if (condition.test(entry, values)) {
                    if (!this.isNotPresent(map.keySet(), entry)) continue;
                    map.put(entry, values);
                    continue;
                }
                EntryCollectionBuilder.log(source, errorMessage);
            }
        }
        return map;
    }

    private static double parseDouble(String value, String source) {
        if (value.equalsIgnoreCase(Boolean.TRUE.toString())) {
            return 1.0;
        }
        if (value.equalsIgnoreCase(Boolean.FALSE.toString())) {
            return 0.0;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException ignored) {
            EntryCollectionBuilder.log(source, "Invalid number format");
            return 0.0;
        }
    }
}

