/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.puzzleslib_mc.config.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class JsonSerializationUtil {
    public static final String FILE_FORMAT_STRING = "__file_format";
    public static final String COMMENT_STRING = "__comment";

    public static JsonObject getConfigBase(int fileFormat, String ... comments) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty(FILE_FORMAT_STRING, (Number)fileFormat);
        JsonSerializationUtil.addConfigComment(jsonobject, comments);
        return jsonobject;
    }

    private static void addConfigComment(JsonObject jsonobject, String[] comments) {
        if (comments.length == 1) {
            jsonobject.addProperty(COMMENT_STRING, comments[0]);
        } else if (comments.length > 1) {
            JsonArray jsonarray = new JsonArray();
            Stream.of(comments).forEach(arg_0 -> ((JsonArray)jsonarray).add(arg_0));
            jsonobject.add(COMMENT_STRING, (JsonElement)jsonarray);
        }
    }

    public static int readFileFormat(JsonObject jsonObject) {
        return Optional.ofNullable(jsonObject.get(FILE_FORMAT_STRING)).map(JsonElement::getAsInt).orElse(-1);
    }

    public static Stream<Map.Entry<String, JsonElement>> getJsonElementStream(JsonObject jsonObject) {
        return jsonObject.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(FILE_FORMAT_STRING) && !((String)entry.getKey()).equals(COMMENT_STRING));
    }
}

