/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.menucompanions.client.element;

import com.fuzs.menucompanions.MenuCompanions;
import com.fuzs.menucompanions.MenuCompanionsElements;
import com.fuzs.menucompanions.client.gui.EntityMenuContainer;
import com.fuzs.menucompanions.client.storage.MenuEntityProvider;
import com.fuzs.menucompanions.client.storage.entry.EntityMenuEntry;
import com.fuzs.menucompanions.client.util.ReloadMode;
import com.fuzs.menucompanions.client.world.MenuClientWorld;
import com.fuzs.puzzleslib_mc.config.ConfigManager;
import com.fuzs.puzzleslib_mc.config.json.JsonConfigFileUtil;
import com.fuzs.puzzleslib_mc.element.AbstractElement;
import com.fuzs.puzzleslib_mc.element.side.IClientElement;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDirection;
import net.minecraft.tags.TagRegistryManager;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MenuEntityElement
extends AbstractElement
implements IClientElement {
    private static final ResourceLocation RELOAD_TEXTURES = new ResourceLocation("menucompanions", "textures/gui/reload.png");
    private final Minecraft mc = Minecraft.func_71410_x();
    private final EnumMap<MenuSide, EntityMenuContainer> menuSides = new EnumMap(MenuSide.class);
    private MenuClientWorld renderWorld;
    private int displayTimeCounter;
    private Consumer<UnaryOperator<List<String>>> addToBlacklist;
    public int displayTime;
    private int entitySize;
    private final int[] buttonOffsets = new int[6];
    private boolean playAmbientSounds;
    private boolean hurtEntity;
    private Set<EntityType<?>> entityBlacklist;
    private ReloadMode reloadMode;

    @Override
    public String getDescription() {
        return "Cute little mobs to fill the emptiness of the main menu.";
    }

    @Override
    public void setupClient() {
        Stream.of(MenuSide.values()).filter(side -> side != MenuSide.BOTH).forEach(side -> this.menuSides.put((MenuSide)((Object)side), new EntityMenuContainer(this.mc)));
        this.addListener(this::onGuiInit);
        this.addListener(this::onGuiOpen);
        this.addListener(this::onDrawScreen);
        this.addListener(this::onMouseClicked);
        this.addListener(this::onClientTick);
        this.addListener(this::onRenderNameplate, EventPriority.HIGHEST);
        this.addListener((T evt1) -> {
            if (this.mc.field_71462_r instanceof MainMenuScreen) {
                evt1.setCanceled(true);
            }
        }, EventPriority.HIGHEST);
        this.addListener(evt -> {
            if (this.mc.field_71462_r instanceof MainMenuScreen) {
                evt.setCanceled(false);
            }
        }, EventPriority.LOWEST, true);
    }

    @Override
    public void loadClient() {
        ConfigManager.get().getConfigDataAtPath(this.getRegistryName(), "Entity Blacklist").map(data -> data).ifPresent(data -> {
            this.addToBlacklist = data::modifyConfigValue;
        });
        JsonConfigFileUtil.getAllAndLoad("menucompanions", MenuEntityProvider::serialize, MenuEntityProvider::deserialize, MenuEntityProvider::clear);
        if (this.createRenderWorld()) {
            this.menuSides.values().forEach(container -> container.setWorld(this.renderWorld));
            TagRegistryManager.func_242191_a();
        }
    }

    private boolean createRenderWorld() {
        try {
            GameProfile profileIn = this.mc.func_110432_I().func_148256_e();
            ClientPlayNetHandler clientPlayNetHandler = new ClientPlayNetHandler(this.mc, null, new NetworkManager(PacketDirection.CLIENTBOUND), profileIn);
            ClientWorld.ClientWorldInfo worldInfo = new ClientWorld.ClientWorldInfo(Difficulty.HARD, false, false);
            DimensionType dimensionType = (DimensionType)DynamicRegistries.func_239770_b_().func_230520_a_().func_243576_d(DimensionType.field_236000_d_);
            this.renderWorld = new MenuClientWorld(clientPlayNetHandler, worldInfo, (RegistryKey<World>)World.field_234919_h_, dimensionType, () -> ((Minecraft)this.mc).func_213239_aq(), this.mc.field_71438_f);
        }
        catch (Exception e) {
            MenuCompanions.LOGGER.error("Unable to create rendering world: {}", (Object)e.getMessage());
            this.forceDisable();
            return false;
        }
        return true;
    }

    @Override
    public void setupClientConfig(ForgeConfigSpec.Builder builder) {
        MenuEntityElement.addToConfig(builder.comment("Time in seconds an entity will be shown for. Set to 0 to never change entities.").defineInRange("Display Time", 0, 0, Integer.MAX_VALUE), v -> {
            this.displayTime = v;
        }, v -> v * 20);
        MenuEntityElement.addToConfig(builder.comment("Size of menu companions.").defineInRange("Entity Size", 60, 0, Integer.MAX_VALUE), v -> {
            this.entitySize = v;
        });
        MenuEntityElement.addToConfig(builder.comment("Offset on x-axis from original position on left side.").defineInRange("Left X-Offset", 0, Integer.MIN_VALUE, Integer.MAX_VALUE), v -> {
            this.buttonOffsets[0] = v;
        });
        MenuEntityElement.addToConfig(builder.comment("Offset on y-axis from original position on left side.").defineInRange("Left Y-Offset", 0, Integer.MIN_VALUE, Integer.MAX_VALUE), v -> {
            this.buttonOffsets[1] = v;
        });
        MenuEntityElement.addToConfig(builder.comment("Offset on x-axis from original position on right side.").defineInRange("Right X-Offset", 0, Integer.MIN_VALUE, Integer.MAX_VALUE), v -> {
            this.buttonOffsets[2] = v;
        });
        MenuEntityElement.addToConfig(builder.comment("Offset on y-axis from original position on right side.").defineInRange("Right Y-Offset", 0, Integer.MIN_VALUE, Integer.MAX_VALUE), v -> {
            this.buttonOffsets[3] = v;
        });
        MenuEntityElement.addToConfig(builder.comment("Play ambient sounds when clicking on menu mobs.").define("Play Sounds", true), v -> {
            this.playAmbientSounds = v;
        });
        MenuEntityElement.addToConfig(builder.comment("Hurt entity when clicked and there is no ambient sound to play.").define("Hurt Entity", false), v -> {
            this.hurtEntity = v;
        });
        MenuEntityElement.addToConfig(builder.comment("Blacklist to prevent certain entities form rendering. Problematic entities will be added automatically upon being detected.").define("Entity Blacklist", (Object)ConfigManager.get().getKeyList((IForgeRegistryEntry[])new EntityType[]{EntityType.field_200802_p, EntityType.field_200805_s, EntityType.field_200809_w, EntityType.field_200788_b, EntityType.field_200765_E, EntityType.field_200730_aI})), v -> {
            this.entityBlacklist = v;
        }, v -> MenuEntityElement.deserializeToSet(v, ForgeRegistries.ENTITIES));
        MenuEntityElement.addToConfig(builder.comment("When to show reload button on main menu. By default requires the control key to be pressed.").defineEnum("Reload Button", (Enum)ReloadMode.RIGHT_ALWAYS), v -> {
            this.reloadMode = v;
        });
        MenuEntityElement.addToConfig(builder.comment("Reload button offset on x-axis from original position.").defineInRange("Reload X-Offset", 0, Integer.MIN_VALUE, Integer.MAX_VALUE), v -> {
            this.buttonOffsets[4] = v;
        });
        MenuEntityElement.addToConfig(builder.comment("Reload button offset on y-axis from original position.").defineInRange("Reload Y-Offset", 0, Integer.MIN_VALUE, Integer.MAX_VALUE), v -> {
            this.buttonOffsets[5] = v;
        });
        MenuEntityElement.addToConfig(builder.comment("Which side entities can be shown at.").defineEnum("Entity Side", (Enum)MenuSide.BOTH), v -> {
            this.menuSides.get((Object)MenuSide.LEFT).setEnabled(v != MenuSide.RIGHT);
            this.menuSides.get((Object)MenuSide.RIGHT).setEnabled(v != MenuSide.LEFT);
        });
    }

    private void onGuiInit(GuiScreenEvent.InitGuiEvent.Post evt) {
        if (evt.getGui() instanceof MainMenuScreen && this.reloadMode != ReloadMode.NEVER) {
            this.addReloadButton(evt.getWidgetList(), arg_0 -> ((GuiScreenEvent.InitGuiEvent.Post)evt).addWidget(arg_0));
        }
    }

    private void addReloadButton(List<Widget> widgets, Consumer<Widget> addWidget) {
        Widget parentWidget = this.getReloadParentWidget(widgets);
        if (parentWidget != null) {
            int posX = parentWidget.field_230690_l_ + (this.reloadMode.isLeft() ? -24 + this.buttonOffsets[4] : parentWidget.func_230998_h_() + 4 - this.buttonOffsets[4]);
            int posY = parentWidget.field_230691_m_ - this.buttonOffsets[5];
            addWidget.accept((Widget)new ImageButton(posX, posY, 20, 20, 0, 0, 20, RELOAD_TEXTURES, 32, 64, button -> {
                this.displayTimeCounter = 0;
                JsonConfigFileUtil.getAllAndLoad("menucompanions", MenuEntityProvider::serialize, MenuEntityProvider::deserialize, MenuEntityProvider::clear);
                MenuCompanions.LOGGER.info("Reloaded config files at {}", (Object)"menucompanions");
                this.menuSides.values().forEach(rec$ -> ((EntityMenuContainer)rec$).setUpdateRequired());
            }, (ITextComponent)new TranslationTextComponent("narrator.button.reload")){

                public void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
                    this.field_230694_p_ = MenuEntityElement.this.reloadMode.requiresControl() && Screen.func_231172_r_() || MenuEntityElement.this.reloadMode.isAlways();
                    super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
                }
            });
        }
    }

    @Nullable
    private Widget getReloadParentWidget(List<Widget> widgets) {
        ArrayList leftSide = Lists.newArrayList((Object[])new String[]{"narrator.button.language", "menu.options", "fml.menu.mods", "menu.multiplayer"});
        ArrayList rightSide = Lists.newArrayList((Object[])new String[]{"narrator.button.accessibility", "menu.quit", "menu.online", "menu.multiplayer"});
        for (String key : this.reloadMode.isLeft() ? leftSide : rightSide) {
            Widget parentWidget = this.getWidgetByTranslation(widgets, key);
            if (parentWidget == null) continue;
            return parentWidget;
        }
        return null;
    }

    @Nullable
    private Widget getWidgetByTranslation(List<Widget> widgets, String key) {
        for (Widget widget : widgets) {
            ITextComponent message = widget.func_230458_i_();
            if (!(message instanceof TranslationTextComponent) || !((TranslationTextComponent)message).func_150268_i().equals(key)) continue;
            return widget;
        }
        return null;
    }

    private void onGuiOpen(GuiOpenEvent evt) {
        if (evt.getGui() instanceof MainMenuScreen) {
            this.menuSides.values().forEach(rec$ -> ((EntityMenuContainer)rec$).setUpdateRequired());
        }
    }

    private void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post evt) {
        if (evt.getGui() instanceof MainMenuScreen) {
            this.menuSides.forEach((side, container) -> {
                int sideIndex = side == MenuSide.RIGHT ? 2 : 0;
                int xOffset = (evt.getGui().field_230708_k_ / 2 - 96) / 2 + this.buttonOffsets[sideIndex];
                int posX = sideIndex == 0 ? xOffset : evt.getGui().field_230708_k_ - xOffset;
                int posY = evt.getGui().field_230709_l_ / 4 + 116 - this.buttonOffsets[sideIndex + 1];
                container.render(posX, posY, (float)this.entitySize / 2.0f, -evt.getMouseX(), -evt.getMouseY(), evt.getRenderPartialTicks());
            });
        }
    }

    private void onMouseClicked(GuiScreenEvent.MouseClickedEvent.Post evt) {
        if (evt.getGui() instanceof MainMenuScreen && evt.getButton() == 0) {
            Consumer<EntityMenuContainer> interaction = container -> container.interactWithEntity(this.mc.func_147118_V(), this.playAmbientSounds, this.hurtEntity);
            if (this.clickLeftSide(evt.getGui().field_230708_k_, evt.getGui().field_230709_l_, evt.getMouseX(), evt.getMouseY(), interaction) || this.clickRightSide(evt.getGui().field_230708_k_, evt.getGui().field_230709_l_, evt.getMouseX(), evt.getMouseY(), interaction)) {
                evt.setCanceled(true);
            }
        }
    }

    private boolean clickLeftSide(int width, int height, double mouseX, double mouseY, Consumer<EntityMenuContainer> interaction) {
        int posX = (width / 2 - 96) / 2 - this.entitySize / 2 + this.buttonOffsets[0];
        int posY = height / 4 + 48 + 80 - this.entitySize * 4 / 3 - this.buttonOffsets[1];
        return this.interactAtSide(MenuSide.LEFT, posX, posY, mouseX, mouseY, interaction);
    }

    private boolean clickRightSide(int width, int height, double mouseX, double mouseY, Consumer<EntityMenuContainer> interaction) {
        int posX = width - ((width / 2 - 96) / 2 + this.entitySize / 2 + this.buttonOffsets[2]);
        int posY = height / 4 + 48 + 80 - this.entitySize * 4 / 3 - this.buttonOffsets[3];
        return this.interactAtSide(MenuSide.RIGHT, posX, posY, mouseX, mouseY, interaction);
    }

    private boolean interactAtSide(MenuSide side, int posX, int posY, double mouseX, double mouseY, Consumer<EntityMenuContainer> interaction) {
        if (MenuEntityElement.isPointInRegion(posX, posY, this.entitySize, this.entitySize * 4 / 3, mouseX, mouseY)) {
            interaction.accept(this.menuSides.get((Object)side));
            return true;
        }
        return false;
    }

    private static boolean isPointInRegion(int x, int y, int width, int height, double mouseX, double mouseY) {
        return mouseX >= (double)(x - 1) && mouseX < (double)(x + width + 1) && mouseY >= (double)(y - 1) && mouseY < (double)(y + height + 1);
    }

    private void onClientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END && this.mc.field_71462_r instanceof MainMenuScreen) {
            if (this.displayTime > 0) {
                ++this.displayTimeCounter;
                this.displayTimeCounter %= this.displayTime;
            }
            this.menuSides.entrySet().stream().filter(entry -> this.displayTime > 0 && this.displayTimeCounter == 0 || ((EntityMenuContainer)entry.getValue()).isInvalid()).forEach(entry -> this.setMenuSide((MenuSide)((Object)((Object)entry.getKey()))));
            this.menuSides.values().forEach(EntityMenuContainer::tick);
        }
    }

    private void onRenderNameplate(RenderNameplateEvent evt) {
        if (this.mc.field_71462_r instanceof MainMenuScreen) {
            evt.setResult(Event.Result.DENY);
        }
    }

    private void setMenuSide(MenuSide side) {
        EntityMenuEntry entry;
        EntityMenuContainer container = this.menuSides.get((Object)side);
        if (container.isDisabled()) {
            return;
        }
        while ((entry = MenuEntityProvider.getRandomEntry(side)) != null) {
            Entity entity = entry.create(this.renderWorld);
            if (entity != null) {
                container.createEntity(entity, entry, side == MenuSide.RIGHT);
                return;
            }
            MenuEntityProvider.removeEntry(entry);
        }
        container.setBroken();
    }

    public boolean isAllowed(EntityType<?> type) {
        return this.entityBlacklist == null || !this.entityBlacklist.contains(type);
    }

    public void addToBlacklist(String type) {
        ResourceLocation location = ResourceLocation.func_208304_a((String)type);
        if (location != null && ForgeRegistries.ENTITIES.containsKey(location)) {
            this.addToBlacklist((EntityType)ForgeRegistries.ENTITIES.getValue(location));
        }
    }

    public void addToBlacklist(EntityType<?> type) {
        if (this.addToBlacklist != null && this.isAllowed(type)) {
            this.addToBlacklist.accept(list -> {
                list.add(type.getRegistryName().toString());
                return list;
            });
        }
    }

    public static MenuEntityElement get() {
        return MenuCompanionsElements.MENU_ENTITY.getAs(MenuEntityElement.class);
    }

    public static enum MenuSide {
        LEFT,
        BOTH,
        RIGHT;

    }
}

