/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.menucompanions.client.gui;

import com.fuzs.menucompanions.MenuCompanions;
import com.fuzs.menucompanions.client.element.MenuEntityElement;
import com.fuzs.menucompanions.client.gui.IStateContainer;
import com.fuzs.menucompanions.client.particle.MenuParticleManager;
import com.fuzs.menucompanions.client.storage.entry.EntityMenuEntry;
import com.fuzs.menucompanions.client.world.MenuClientWorld;
import com.fuzs.menucompanions.mixin.client.accessor.IActiveRenderInfoAccessor;
import com.fuzs.menucompanions.mixin.client.accessor.ILivingEntityAccessor;
import com.fuzs.menucompanions.mixin.client.accessor.IMobEntityAccessor;
import com.fuzs.puzzleslib_mc.util.PuzzlesLibUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class EntityMenuContainer
implements IStateContainer {
    private final Minecraft mc;
    private MenuClientWorld world;
    public MenuParticleManager particleManager;
    private IStateContainer.ContainerState containerState = this.getDefaultState();
    private boolean setInitialAngles;
    private Entity entity;
    private Entity[] selfAndPassengers;
    private boolean tick;
    private boolean walking;
    private boolean inLove;
    private float scale;
    private int xOffset;
    private int yOffset;
    private boolean nameplate;
    private boolean particles;
    private float volume;

    public EntityMenuContainer(Minecraft mc) {
        this.mc = mc;
    }

    public void setWorld(MenuClientWorld world) {
        this.world = world;
        this.particleManager = new MenuParticleManager(this.mc, world);
    }

    @Override
    public IStateContainer.ContainerState getState() {
        return this.containerState;
    }

    @Override
    public void setState(IStateContainer.ContainerState containerState) {
        this.containerState = containerState;
    }

    @Override
    public void setEnabled(boolean enable) {
        IStateContainer.super.setEnabled(enable);
        if (this.entity == null) {
            this.setInvalid();
        }
    }

    public void createEntity(@Nonnull Entity entity, @Nonnull EntityMenuEntry entry, boolean isRightSide) {
        this.entity = entity;
        this.copyEntryData(entry, entity, isRightSide);
        this.selfAndPassengers = this.getSelfAndPassengers(entity);
        this.setEnabled(true);
        this.setInitialAngles = true;
    }

    private Entity[] getSelfAndPassengers(Entity entity) {
        Entity[] selfAndPassengers = (Entity[])entity.func_226276_cg_().toArray(Entity[]::new);
        if (!EntityMenuContainer.copyAllEntityData(this.selfAndPassengers, selfAndPassengers)) {
            this.particleManager.clearEffects();
        }
        return selfAndPassengers;
    }

    private void copyEntryData(EntityMenuEntry entry, Entity entity, boolean isRightSide) {
        this.tick = entry.isTick();
        this.walking = entry.isWalking();
        this.inLove = entry.isInLove();
        this.scale = entry.getScale(entity);
        this.xOffset = (isRightSide ? -1 : 1) * entry.getXOffset();
        this.yOffset = -entry.getYOffset();
        this.nameplate = entry.showNameplate();
        this.particles = entry.showParticles();
        this.volume = entry.getSoundVolume();
    }

    public void tick() {
        if (this.isNotEnabled()) {
            return;
        }
        this.world.setActiveContainer(this);
        if (this.particles) {
            this.particleManager.tick();
        }
        for (Entity entity : this.selfAndPassengers) {
            ++entity.field_70173_aa;
            if (entity instanceof LivingEntity) {
                this.updateLimbSwing((LivingEntity)entity, this.walking ? (entity.func_213453_ef() ? 0.18f : 0.6f) : 0.0f);
                this.spawnNectarParticles(entity);
                if (((LivingEntity)entity).field_70737_aN > 0) {
                    --((LivingEntity)entity).field_70737_aN;
                }
                if (this.tick) {
                    PuzzlesLibUtil.runOrElse(entity, safeEntity -> ((LivingEntity)safeEntity).func_70636_d(), safeEntity -> {
                        this.tick = false;
                    });
                }
            }
            this.spawnHeartParticles(entity);
            if (!entity.func_184218_aH()) continue;
            Objects.requireNonNull(entity.func_184187_bx()).func_184232_k(entity);
        }
    }

    private void updateLimbSwing(LivingEntity livingEntity, float amount) {
        livingEntity.field_184618_aE = livingEntity.field_70721_aZ;
        livingEntity.field_70721_aZ += (MathHelper.func_76131_a((float)amount, (float)0.0f, (float)1.0f) - livingEntity.field_70721_aZ) * 0.4f;
        livingEntity.field_184619_aG += livingEntity.field_70721_aZ;
    }

    private void spawnNectarParticles(Entity entity) {
        if (entity instanceof BeeEntity && ((BeeEntity)entity).func_226411_eD_() && this.world.field_73012_v.nextFloat() < 0.05f) {
            for (int i = 0; i < this.world.field_73012_v.nextInt(2) + 1; ++i) {
                double posX = MathHelper.func_219803_d((double)this.world.field_73012_v.nextDouble(), (double)(entity.func_226277_ct_() - 0.3), (double)(entity.func_226277_ct_() + 0.3));
                double posY = entity.func_226283_e_(0.5);
                double posZ = MathHelper.func_219803_d((double)this.world.field_73012_v.nextDouble(), (double)(entity.func_226281_cx_() - 0.3), (double)(entity.func_226281_cx_() + 0.3));
                this.world.func_195594_a((IParticleData)ParticleTypes.field_229430_aj_, posX, posY, posZ, 0.0, 0.0, 0.0);
            }
        }
    }

    private void spawnHeartParticles(Entity entity) {
        if (this.inLove && entity.field_70173_aa % 10 == 0) {
            double speedX = this.world.field_73012_v.nextGaussian() * 0.02;
            double speedY = this.world.field_73012_v.nextGaussian() * 0.02;
            double speedZ = this.world.field_73012_v.nextGaussian() * 0.02;
            this.world.func_195594_a((IParticleData)ParticleTypes.field_197633_z, entity.func_226282_d_(1.0), entity.func_226279_cv_() + 0.5, entity.func_226287_g_(1.0), speedX, speedY, speedZ);
        }
    }

    public void render(int posX, int posY, float scale, float mouseX, float mouseY, float partialTicks) {
        if (this.isNotEnabled()) {
            return;
        }
        ActiveRenderInfo activerenderinfo = this.mc.field_71460_t.func_215316_n();
        this.mc.func_175598_ae().func_229088_a_((World)this.world, activerenderinfo, this.entity);
        ((IActiveRenderInfoAccessor)activerenderinfo).callSetPosition(Vector3d.field_186680_a);
        ((IActiveRenderInfoAccessor)activerenderinfo).callSetDirection(0.0f, 0.0f);
        scale *= this.scale;
        posY += this.yOffset;
        posY = (int)((float)posY - Math.max(0.0f, 0.9f - this.entity.func_213302_cg() / 2.0f) * 30.0f);
        mouseX += (float)(posX += this.xOffset);
        mouseY += (float)posY;
        mouseY -= this.entity.func_70047_e() / 1.62f * 50.0f * this.scale;
        RenderSystem.disableLighting();
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)posX, (float)posY, (float)50.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227862_a_(scale, scale, scale);
        Quaternion quaternionZ = Vector3f.field_229183_f_.func_229187_a_(180.0f);
        Quaternion quaternionX = Vector3f.field_229179_b_.func_229187_a_((float)Math.atan(mouseY / 40.0f) * 20.0f);
        quaternionZ.func_195890_a(quaternionX);
        matrixstack.func_227863_a_(quaternionZ);
        this.renderParticles(matrixstack, partialTicks);
        for (Entity entity : this.selfAndPassengers) {
            Vector3d posVec = entity.func_213303_ch().func_178788_d(this.entity.func_213303_ch());
            double eyeVec = entity.func_226280_cw_() - this.entity.func_226280_cw_();
            if (this.setInitialAngles) {
                EntityMenuContainer.setRotationAngles(entity, mouseX, mouseY + (float)posVec.func_82617_b() * scale);
                this.tick();
            }
            EntityMenuContainer.setRotationAngles(entity, mouseX, mouseY - (float)eyeVec / 1.62f * 50.0f * this.scale);
            EntityMenuContainer.drawEntityOnScreen(matrixstack, posVec.func_82615_a(), posVec.func_82617_b(), posVec.func_82616_c(), partialTicks, entity, (irendertypebuffer, packedLightIn) -> {
                if (this.nameplate) {
                    matrixstack.func_227860_a_();
                    float downscale = 1.0f / this.scale;
                    matrixstack.func_227862_a_(downscale, downscale, downscale);
                    Consumer<Entity> render = safeEntity -> EntityMenuContainer.renderName(matrixstack, irendertypebuffer, packedLightIn, safeEntity, (safeEntity.func_213302_cg() + 0.5f) * this.scale);
                    PuzzlesLibUtil.runOrElse(entity, render, safeEntity -> {
                        this.nameplate = false;
                    });
                    matrixstack.func_227865_b_();
                }
            }, this::setInvalid);
        }
        this.setInitialAngles = false;
        RenderSystem.popMatrix();
    }

    private void renderParticles(MatrixStack matrixstack, float partialTicks) {
        if (this.particles) {
            try {
                matrixstack.func_227860_a_();
                this.particleManager.renderParticles(matrixstack, this.mc.field_71460_t.func_228384_l_(), this.mc.field_71460_t.func_215316_n(), partialTicks);
                matrixstack.func_227865_b_();
            }
            catch (Exception e) {
                MenuCompanions.LOGGER.warn("Exception rendering particle, skipping until reload");
                this.particles = false;
            }
        }
    }

    public void interactWithEntity(SoundHandler handler, boolean playAmbientSounds, boolean hurtEntity) {
        SoundEvent ambientSound;
        if (this.isNotEnabled()) {
            return;
        }
        this.world.setActiveContainer(this);
        List entities = Stream.of(this.selfAndPassengers).filter(entity -> entity instanceof LivingEntity).collect(Collectors.toList());
        if (entities.isEmpty()) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entities.get(this.world.field_73012_v.nextInt(entities.size()));
        if (playAmbientSounds && livingEntity instanceof MobEntity && this.playLivingSound(handler, livingEntity, ambientSound = ((IMobEntityAccessor)livingEntity).callGetAmbientSound(), this.volume)) {
            return;
        }
        if (hurtEntity) {
            if (livingEntity.field_70737_aN == 0) {
                livingEntity.field_70737_aN = 10;
                livingEntity.field_70721_aZ = 1.5f;
                this.spawnDamageParticles(livingEntity);
                SoundEvent hurtSound = ((ILivingEntityAccessor)livingEntity).callGetHurtSound(DamageSource.field_76377_j);
                this.playLivingSound(handler, livingEntity, hurtSound, this.volume);
            }
        } else if (!livingEntity.field_82175_bq) {
            livingEntity.func_184609_a(Hand.MAIN_HAND);
        }
    }

    private boolean playLivingSound(SoundHandler handler, LivingEntity livingEntity, SoundEvent soundEvent, float volume) {
        if (soundEvent != null && !livingEntity.func_174814_R()) {
            float soundVolume = ((ILivingEntityAccessor)livingEntity).callGetSoundVolume() * volume;
            float soundPitch = ((ILivingEntityAccessor)livingEntity).callGetSoundPitch();
            handler.func_147682_a((ISound)new SimpleSound(soundEvent.func_187503_a(), livingEntity.func_184176_by(), soundVolume, soundPitch, false, 0, ISound.AttenuationType.NONE, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_(), true));
            return true;
        }
        return false;
    }

    private void spawnDamageParticles(LivingEntity livingEntity) {
        for (int i = 0; i < this.world.field_73012_v.nextInt(5) + 1; ++i) {
            double posX = livingEntity.func_226277_ct_() + this.world.field_73012_v.nextGaussian() * 0.2;
            double posY = livingEntity.func_226283_e_(0.5);
            double posZ = livingEntity.func_226281_cx_() - 0.3 + this.world.field_73012_v.nextGaussian() * 0.2;
            double xSpeed = this.world.field_73012_v.nextGaussian() * 0.02;
            double zSpeed = this.world.field_73012_v.nextGaussian() * 0.02;
            this.world.func_195594_a((IParticleData)ParticleTypes.field_197615_h, posX, posY, posZ, xSpeed, 0.0, zSpeed);
        }
    }

    private static void setRotationAngles(Entity entity, float mouseX, float mouseY) {
        entity.field_70126_B = entity.field_70177_z;
        entity.field_70127_C = entity.field_70125_A;
        entity.field_70177_z = 180.0f + (float)Math.atan(mouseX / 40.0f) * 40.0f;
        entity.field_70125_A = -((float)Math.atan(mouseY / 40.0f)) * 20.0f;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.field_70760_ar = livingEntity.field_70761_aq;
            livingEntity.field_70758_at = livingEntity.field_70759_as;
            livingEntity.field_70761_aq = 180.0f + (float)Math.atan(mouseX / 40.0f) * 20.0f;
            livingEntity.field_70759_as = entity.field_70177_z;
        }
    }

    private static boolean copyAllEntityData(Entity[] source, @Nonnull Entity[] target) {
        if (source == null) {
            return false;
        }
        boolean successfulForAll = true;
        int bound = Math.min(source.length, target.length);
        for (int i = 0; i < bound; ++i) {
            Pair pair = Pair.of((Object)source[i], (Object)target[i]);
            if (((Entity)pair.getLeft()).func_200600_R() == ((Entity)pair.getRight()).func_200600_R()) {
                EntityMenuContainer.copyEntityData((Entity)pair.getLeft(), (Entity)pair.getRight());
                continue;
            }
            successfulForAll = false;
        }
        return successfulForAll;
    }

    private static void copyEntityData(Entity source, @Nonnull Entity target) {
        if (source != null) {
            target.field_70173_aa = source.field_70173_aa;
            EntityMenuContainer.copyRotationAngles(source, target);
            if (source instanceof LivingEntity && target instanceof LivingEntity) {
                LivingEntity livingSource = (LivingEntity)source;
                LivingEntity livingTarget = (LivingEntity)target;
                livingTarget.field_184618_aE = livingSource.field_184618_aE;
                livingTarget.field_70721_aZ = livingSource.field_70721_aZ;
                livingTarget.field_184619_aG = livingSource.field_184619_aG;
                livingTarget.field_70737_aN = livingSource.field_70737_aN;
            }
        }
    }

    private static void copyRotationAngles(Entity source, Entity target) {
        target.field_70126_B = source.field_70126_B;
        target.field_70127_C = source.field_70127_C;
        target.field_70177_z = source.field_70177_z;
        target.field_70125_A = source.field_70125_A;
        if (source instanceof LivingEntity && target instanceof LivingEntity) {
            LivingEntity livingSource = (LivingEntity)source;
            LivingEntity livingTarget = (LivingEntity)target;
            livingTarget.field_70760_ar = livingSource.field_70760_ar;
            livingTarget.field_70758_at = livingSource.field_70758_at;
            livingTarget.field_70761_aq = livingSource.field_70761_aq;
            livingTarget.field_70759_as = livingSource.field_70759_as;
        }
    }

    private static void drawEntityOnScreen(MatrixStack matrixstack, double posX, double posY, double posZ, float partialTicks, Entity entity, BiConsumer<IRenderTypeBuffer, Integer> renderName, Runnable invalidate) {
        matrixstack.func_227860_a_();
        matrixstack.func_227861_a_(posX, posY, posZ);
        EntityRendererManager rendererManager = Minecraft.func_71410_x().func_175598_ae();
        rendererManager.func_178633_a(false);
        IRenderTypeBuffer.Impl irendertypebuffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        RenderSystem.runAsFancy(() -> {
            Consumer<Entity> render = safeEntity -> rendererManager.func_229084_a_(safeEntity, 0.0, 0.0, 0.0, 0.0f, partialTicks, matrixstack, (IRenderTypeBuffer)irendertypebuffer, 0xF000F0);
            Consumer<Entity> orElse = safeEntity -> {
                MenuEntityElement.get().addToBlacklist(safeEntity.func_200600_R());
                invalidate.run();
            };
            PuzzlesLibUtil.runOrElse(entity, render, orElse);
            renderName.accept((IRenderTypeBuffer)irendertypebuffer, 0xF000F0);
        });
        irendertypebuffer.func_228461_a_();
        rendererManager.func_178633_a(true);
        matrixstack.func_227865_b_();
    }

    private static void renderName(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, Entity entityIn, float renderHeight) {
        ITextComponent displayNameIn = entityIn.func_145748_c_();
        float renderOffset = "deadmau5".equals(displayNameIn.getString()) ? -10.0f : 0.0f;
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.0, (double)renderHeight, 0.0);
        matrixStackIn.func_227862_a_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
        float backgroundOpacity = Minecraft.func_71410_x().field_71474_y.func_216840_a(0.25f);
        int alpha = (int)(backgroundOpacity * 255.0f) << 24;
        FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
        int textWidth = -fontrenderer.func_238414_a_((ITextProperties)displayNameIn) / 2;
        fontrenderer.func_243247_a(displayNameIn, (float)textWidth, renderOffset, 0x20FFFFFF, false, matrix4f, bufferIn, true, alpha, packedLightIn);
        fontrenderer.func_243247_a(displayNameIn, (float)textWidth, renderOffset, -1, false, matrix4f, bufferIn, false, 0, packedLightIn);
        matrixStackIn.func_227865_b_();
    }
}

