/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.menucompanions.client.gui;

interface IStateContainer {
    public ContainerState getState();

    public void setState(ContainerState var1);

    default public boolean isEnabled() {
        return this.getState() == ContainerState.ENABLED;
    }

    default public boolean isNotEnabled() {
        return !this.isEnabled() && this.getState() != ContainerState.UPDATE_REQUIRED;
    }

    default public boolean isDisabled() {
        return this.getState() == ContainerState.DISABLED;
    }

    default public boolean isInvalid() {
        return this.getState() == ContainerState.INVALID || this.getState() == ContainerState.UPDATE_REQUIRED;
    }

    default public void setEnabled(boolean enable) {
        this.setState(enable ? ContainerState.ENABLED : ContainerState.DISABLED);
    }

    default public void setUpdateRequired() {
        if (this.isEnabled()) {
            this.setState(ContainerState.UPDATE_REQUIRED);
        } else if (!this.isDisabled()) {
            this.setState(ContainerState.INVALID);
        }
    }

    default public void setInvalid() {
        if (!this.isDisabled() && this.getState() != ContainerState.BROKEN) {
            this.setState(ContainerState.INVALID);
        }
    }

    default public void setBroken() {
        if (!this.isDisabled()) {
            this.setState(ContainerState.BROKEN);
        }
    }

    default public ContainerState getDefaultState() {
        return ContainerState.INVALID;
    }

    public static enum ContainerState {
        DISABLED,
        ENABLED,
        UPDATE_REQUIRED,
        INVALID,
        BROKEN;

    }
}

