/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.menucompanions.client.storage;

import com.fuzs.menucompanions.client.element.MenuEntityElement;
import com.fuzs.menucompanions.client.storage.MenuEntryBuilder;
import com.fuzs.menucompanions.client.storage.entry.EntityMenuEntry;
import com.fuzs.puzzleslib_mc.config.json.JsonConfigFileUtil;
import com.fuzs.puzzleslib_mc.util.PuzzlesLibUtil;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;

public class MenuEntityProvider {
    private static final List<EntityMenuEntry> MENU_ENTRIES = Lists.newArrayList();
    private static final List<EntityMenuEntry> DEFAULT_MENU_ENTRIES = Lists.newArrayList((Object[])new EntityMenuEntry[]{new MenuEntryBuilder().setType(EntityType.field_200729_aH).setRight().setWeight(31).renderName().build(), new MenuEntryBuilder().setType(EntityType.field_200729_aH).setRight().renderName().setNbt("{ArmorItems:[{Count:1,id:netherite_boots},{Count:1,id:netherite_leggings},{Count:1,id:netherite_chestplate},{Count:1,id:netherite_helmet}]}").build(), new MenuEntryBuilder().setType(EntityType.field_233592_ba_).setLeft().setWeight(13).build(), new MenuEntryBuilder().setType(EntityType.field_233592_ba_).setLeft().setWeight(2).setNbt("{IsBaby:1,HandItems:[{Count:1,id:golden_sword},{}]}").build(), new MenuEntryBuilder().setType(EntityType.field_200795_i).setLeft().setNbt("{Passengers:[{id:zombified_piglin,IsBaby:1,HandItems:[{Count:1,id:golden_sword},{}]}]}").build(), new MenuEntryBuilder().setType(EntityType.field_200811_y).setLeft().setWeight(10).setYOffset(24).setScale(0.4f).build(), new MenuEntryBuilder().setType(EntityType.field_200771_K).setLeft().setWeight(5).setNbt("{Size:0}").build(), new MenuEntryBuilder().setType(EntityType.field_200771_K).setLeft().setWeight(5).setNbt("{Size:1}").build(), new MenuEntryBuilder().setType(EntityType.field_200771_K).setLeft().setWeight(5).setNbt("{Size:3}").build(), new MenuEntryBuilder().setType(EntityType.field_200803_q).setLeft().setWeight(10).build(), new MenuEntryBuilder().setType(EntityType.field_200803_q).setLeft().setNbt("{carriedBlockState:{Name:crimson_fungus}}").build(), new MenuEntryBuilder().setType(EntityType.field_200803_q).setLeft().setNbt("{carriedBlockState:{Name:warped_fungus}}").build(), new MenuEntryBuilder().setType(EntityType.field_200803_q).setLeft().setNbt("{carriedBlockState:{Name:crimson_roots}}").build(), new MenuEntryBuilder().setType(EntityType.field_200803_q).setLeft().setNbt("{carriedBlockState:{Name:warped_roots}}").build(), new MenuEntryBuilder().setType(EntityType.field_200803_q).setLeft().setNbt("{carriedBlockState:{Name:crimson_nylium}}").build(), new MenuEntryBuilder().setType(EntityType.field_200803_q).setLeft().setNbt("{carriedBlockState:{Name:warped_nylium}}").build(), new MenuEntryBuilder().setType(EntityType.field_200792_f).setLeft().setWeight(16).build(), new MenuEntryBuilder().setType(EntityType.field_200722_aA).setLeft().setWeight(13).build(), new MenuEntryBuilder().setType(EntityType.field_200741_ag).setLeft().setWeight(3).build(), new MenuEntryBuilder().setType(EntityType.field_233591_ai_).setLeft().setWeight(13).build(), new MenuEntryBuilder().setType(EntityType.field_233591_ai_).setLeft().setWeight(3).setNbt("{IsBaby:1}").build(), new MenuEntryBuilder().setType(EntityType.field_242287_aj).setLeft().setWeight(6).build(), new MenuEntryBuilder().setType(EntityType.field_233588_G_).setLeft().setWeight(12).build(), new MenuEntryBuilder().setType(EntityType.field_233588_G_).setLeft().setNbt("{Age:-24000}").build(), new MenuEntryBuilder().setType(EntityType.field_233588_G_).setLeft().setNbt("{Age:-24000,Passengers:[{id:piglin,IsBaby:1}]}").build(), new MenuEntryBuilder().setType(EntityType.field_233588_G_).setLeft().setNbt("{Age:-24000,Passengers:[{id:piglin,IsBaby:1,Passengers:[{id:piglin,IsBaby:1}]}]}").build(), new MenuEntryBuilder().setType(EntityType.field_233588_G_).setLeft().setNbt("{Age:-24000,Passengers:[{id:piglin,IsBaby:1,Passengers:[{id:piglin,IsBaby:1,Passengers:[{id:piglin,IsBaby:1}]}]}]}").build(), new MenuEntryBuilder().setType(EntityType.field_233590_aW_).setLeft().build(), new MenuEntryBuilder().setType(EntityType.field_233589_aE_).setLeft().setWeight(10).build(), new MenuEntryBuilder().setType(EntityType.field_233589_aE_).setLeft().setWeight(2).setNbt("{Age:-24000}").build(), new MenuEntryBuilder().setType(EntityType.field_233589_aE_).setLeft().setWeight(3).setNbt("{Passengers:[{id:strider,Age:-24000}]}").build(), new MenuEntryBuilder().setType(EntityType.field_233589_aE_).setLeft().setWeight(1).setNbt("{Saddle:1,Passengers:[{id:zombified_piglin,HandItems:[{Count:1,id:warped_fungus_on_a_stick},{}]}]}").build()});

    @Nullable
    public static EntityMenuEntry getRandomEntry(MenuEntityElement.MenuSide side) {
        List sidedEntries = MENU_ENTRIES.stream().filter(entry -> entry.isSide(side)).collect(Collectors.toList());
        return PuzzlesLibUtil.getRandomEntry(sidedEntries, EntityMenuEntry::getWeight);
    }

    public static void removeEntry(EntityMenuEntry entry) {
        MENU_ENTRIES.remove(entry);
    }

    public static void serialize(File jsonFile) {
        ImmutableListMultimap defaultsAsMap = Multimaps.index(DEFAULT_MENU_ENTRIES, entry -> entry.getRawType().getRegistryName().func_110623_a());
        for (Map.Entry mapEntry : defaultsAsMap.asMap().entrySet()) {
            int index = 0;
            for (EntityMenuEntry entry2 : (Collection)mapEntry.getValue()) {
                String fileName = String.format("%s%d.json", mapEntry.getKey(), ++index);
                File file = new File(jsonFile, String.join((CharSequence)File.separator, (CharSequence)mapEntry.getKey(), fileName));
                JsonConfigFileUtil.saveToFile(file, entry2.serialize());
            }
        }
    }

    public static void deserialize(FileReader reader) throws NullPointerException {
        JsonElement jsonelement = (JsonElement)JsonConfigFileUtil.GSON.fromJson((Reader)reader, JsonElement.class);
        EntityMenuEntry deserialize = MenuEntryBuilder.deserialize(jsonelement);
        if (deserialize == null) {
            throw new NullPointerException("Couldn't deserialize file");
        }
        MENU_ENTRIES.add(deserialize);
    }

    public static void clear() {
        MENU_ENTRIES.clear();
    }
}

