/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.puzzleslib_mc;

import com.fuzs.puzzleslib_mc.capability.CapabilityController;
import com.fuzs.puzzleslib_mc.element.registry.ElementRegistry;
import com.fuzs.puzzleslib_mc.network.NetworkHandler;
import com.fuzs.puzzleslib_mc.registry.RegistryManager;
import com.fuzs.puzzleslib_mc.util.PuzzlesLibUtil;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PuzzlesLib {
    public static final String MODID = "puzzleslib";
    public static final String NAME = "Puzzles Lib";
    public static final Logger LOGGER = LogManager.getLogger((String)"Puzzles Lib");
    private static RegistryManager registryManager;
    private static NetworkHandler networkHandler;
    private static CapabilityController capabilityController;

    public PuzzlesLib() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onCommonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onServerSetup);
    }

    protected void onCommonSetup(FMLCommonSetupEvent evt) {
        ElementRegistry.load((ParallelDispatchEvent)evt);
    }

    protected void onClientSetup(FMLClientSetupEvent evt) {
        ElementRegistry.load((ParallelDispatchEvent)evt);
    }

    protected void onServerSetup(FMLDedicatedServerSetupEvent evt) {
        ElementRegistry.load((ParallelDispatchEvent)evt);
    }

    protected final void setSideSideOnly() {
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (remote, isServer) -> true));
    }

    public static RegistryManager getRegistryManager() {
        return PuzzlesLibUtil.getOrElse(registryManager, RegistryManager::new, instance -> {
            registryManager = instance;
        });
    }

    public static NetworkHandler getNetworkHandler() {
        return PuzzlesLibUtil.getOrElse(networkHandler, NetworkHandler::new, instance -> {
            networkHandler = instance;
        });
    }

    public static CapabilityController getCapabilityController() {
        return PuzzlesLibUtil.getOrElse(capabilityController, CapabilityController::new, instance -> {
            capabilityController = instance;
        });
    }
}

