/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.puzzleslib_mc.config;

import com.fuzs.puzzleslib_mc.PuzzlesLib;
import com.fuzs.puzzleslib_mc.config.ConfigBuilder;
import com.fuzs.puzzleslib_mc.config.ConfigValueData;
import com.fuzs.puzzleslib_mc.util.INamespaceLocator;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ConfigManager
implements INamespaceLocator {
    private static ConfigManager instance;
    private final Map<String, ConfigBuilder> configBuilders = Maps.newHashMap();
    private final Map<String, ConfigValueData<? extends ForgeConfigSpec.ConfigValue<?>, ?, ?>> configData = Maps.newHashMap();
    private final Map<Runnable, ConfigLoading> configListeners = Maps.newHashMap();

    private ConfigManager() {
    }

    public void load(String ... path) {
        if (path.length > 0) {
            this.getBuilder().moveToFolder(path);
        }
        this.getBuilder().registerConfigs(ModLoadingContext.get());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onModConfig);
    }

    public void onModConfig(ModConfig.ModConfigEvent evt) {
        String modid = evt.getConfig().getModId();
        ModConfig.Type type = evt.getConfig().getType();
        if (this.getBuilder(modid).isSpecNotValid(type)) {
            PuzzlesLib.LOGGER.error("Unable to get values from " + type.extension() + " config for " + modid + " during " + (evt instanceof ModConfig.Loading ? "loading" : "reloading") + " phase: Config spec not present");
        } else {
            this.syncType(modid, type);
            this.notifyListeners(ConfigLoading.getState(evt));
            if (evt instanceof ModConfig.Reloading) {
                PuzzlesLib.LOGGER.info("Reloading " + type.extension() + " config for " + modid);
            }
        }
    }

    public void sync(String modid) {
        this.getEntriesForMod(modid).forEach(ConfigValueData::sync);
    }

    private void syncType(String modid, ModConfig.Type type) {
        this.getEntriesForMod(modid).filter(configValue -> configValue.getType() == type).forEach(ConfigValueData::sync);
    }

    private Stream<ConfigValueData<? extends ForgeConfigSpec.ConfigValue<?>, ?, ?>> getEntriesForMod(String modid) {
        return this.configData.values().stream().filter(entry -> entry.getModId().equals(modid));
    }

    public Object getValue(String ... paths) {
        return this.getValue(String.join((CharSequence)".", paths));
    }

    public Object getValue(String path) {
        return this.getConfigDataAtPath(path).map(ConfigValueData::getValue).orElse(null);
    }

    public Optional<ConfigValueData<? extends ForgeConfigSpec.ConfigValue<?>, ?, ?>> getConfigDataAtPath(String ... paths) {
        return this.getConfigDataAtPath(String.join((CharSequence)".", paths));
    }

    public Optional<ConfigValueData<? extends ForgeConfigSpec.ConfigValue<?>, ?, ?>> getConfigDataAtPath(String path) {
        Optional<ConfigValueData<ForgeConfigSpec.ConfigValue<?>, ?, ?>> optional = Optional.ofNullable(this.configData.get(path));
        if (optional.isPresent()) {
            return optional;
        }
        PuzzlesLib.LOGGER.error("Unable to get config value for path \"" + path + "\": No config value found for path");
        return Optional.empty();
    }

    public <S extends ForgeConfigSpec.ConfigValue<T>, T> void registerCommonEntry(S entry, Consumer<T> action) {
        this.registerEntry(ModConfig.Type.COMMON, entry, action, Function.identity());
    }

    public <S extends ForgeConfigSpec.ConfigValue<T>, T> void registerClientEntry(S entry, Consumer<T> action) {
        this.registerEntry(ModConfig.Type.CLIENT, entry, action, Function.identity());
    }

    public <S extends ForgeConfigSpec.ConfigValue<T>, T> void registerServerEntry(S entry, Consumer<T> action) {
        this.registerEntry(ModConfig.Type.SERVER, entry, action, Function.identity());
    }

    public <S extends ForgeConfigSpec.ConfigValue<T>, T> void registerEntry(S entry, Consumer<T> action) {
        this.registerEntry(entry, action, Function.identity());
    }

    public <S extends ForgeConfigSpec.ConfigValue<T>, T, R> void registerEntry(S entry, Consumer<R> action, Function<T, R> transformer) {
        ModConfig.Type activeType = this.getBuilder().getActiveType();
        if (activeType == null) {
            PuzzlesLib.LOGGER.error("Unable to register config entry: Active builder is null");
        } else if (this.getBuilder().isSpecNotBuilt(activeType)) {
            this.registerEntry(activeType, entry, action, transformer);
        } else {
            PuzzlesLib.LOGGER.error("Unable to register config entry: Config spec already built");
        }
    }

    private <S extends ForgeConfigSpec.ConfigValue<T>, T, R> void registerEntry(ModConfig.Type type, S entry, Consumer<R> action, Function<T, R> transformer) {
        this.configData.put(String.join((CharSequence)".", entry.getPath()), new ConfigValueData<S, T, R>(type, entry, action, transformer, this.getActiveNamespace()));
    }

    public void addListener(Runnable listener) {
        this.addListener(listener, ConfigLoading.BOTH);
    }

    public void addLoadingListener(Runnable listener) {
        this.addListener(listener, ConfigLoading.LOADING);
    }

    public void addReloadingListener(Runnable listener) {
        this.addListener(listener, ConfigLoading.RELOADING);
    }

    private void addListener(Runnable listener, ConfigLoading state) {
        this.configListeners.merge(listener, state, (state1, state2) -> state1 != state2 ? ConfigLoading.BOTH : state1);
    }

    private void notifyListeners(ConfigLoading state) {
        this.configListeners.entrySet().stream().filter(entry -> ((ConfigLoading)((Object)((Object)entry.getValue()))).matches(state)).map(Map.Entry::getKey).forEach(Runnable::run);
    }

    public static String getConfigName(String modId, ModConfig.Type type) {
        return String.format("%s-%s.toml", modId, type.extension());
    }

    public static String getConfigNameInFolder(String modId, ModConfig.Type type) {
        return modId + File.separator + ConfigManager.getConfigName(modId, type);
    }

    @SafeVarargs
    public final <T extends IForgeRegistryEntry<T>> List<String> getKeyList(T ... entries) {
        return Stream.of(entries).map(IForgeRegistryEntry::getRegistryName).filter(Objects::nonNull).map(ResourceLocation::toString).collect(Collectors.toList());
    }

    private ConfigBuilder getBuilder() {
        return this.getBuilder(this.getActiveNamespace());
    }

    private ConfigBuilder getBuilder(String modid) {
        return this.configBuilders.computeIfAbsent(modid, key -> new ConfigBuilder());
    }

    public static ConfigManager get() {
        if (instance == null) {
            instance = new ConfigManager();
        }
        return instance;
    }

    public static ConfigBuilder builder() {
        return ConfigManager.get().getBuilder();
    }

    private static enum ConfigLoading {
        LOADING,
        RELOADING,
        BOTH;


        boolean matches(ConfigLoading state) {
            if (state == BOTH || this == BOTH) {
                return true;
            }
            if (state == LOADING && this != RELOADING) {
                return true;
            }
            return state == RELOADING && this != LOADING;
        }

        static ConfigLoading getState(ModConfig.ModConfigEvent evt) {
            return evt instanceof ModConfig.Loading ? LOADING : RELOADING;
        }
    }
}

