/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.puzzleslib_mc.network;

import com.fuzs.puzzleslib_mc.PuzzlesLib;
import com.fuzs.puzzleslib_mc.network.message.IMessage;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class NetworkHandler {
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    private static final SimpleChannel MAIN_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("puzzleslib", "main_channel"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
    private int discriminator;

    public <T extends IMessage> void registerMessage(Supplier<T> supplier, NetworkDirection direction) {
        MAIN_CHANNEL.registerMessage(this.discriminator++, ((IMessage)supplier.get()).getClass(), IMessage::writePacketData, buf -> ((IMessage)supplier.get()).getPacketData((PacketBuffer)buf), (message, side) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)side.get();
            if (ctx.getDirection() == direction) {
                PuzzlesLib.LOGGER.error("Receiving {} at wrong side!", (Object)message.getClass().getSimpleName());
            } else {
                ctx.enqueueWork(() -> message.processPacket(ctx.getSender()));
            }
            ctx.setPacketHandled(true);
        });
    }

    public void sendToServer(IMessage message) {
        MAIN_CHANNEL.sendToServer((Object)message);
    }

    public void sendTo(IMessage message, ServerPlayerEntity player) {
        MAIN_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)message);
    }

    public void sendToAll(IMessage message) {
        MAIN_CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)message);
    }

    public void sendToDimension(IMessage message, RegistryKey<World> dimension) {
        MAIN_CHANNEL.send(PacketDistributor.DIMENSION.with(() -> dimension), (Object)message);
    }
}

