/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.miningdimension.block;

import de.maxhenkel.mining_dimension.corelib.block.IItemBlock;
import de.maxhenkel.miningdimension.Main;
import de.maxhenkel.miningdimension.dimension.MiningDimensionTeleporter;
import de.maxhenkel.miningdimension.tileentity.TileentityTeleporter;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;

public class BlockTeleporter
extends Block
implements ITileEntityProvider,
IItemBlock {
    public BlockTeleporter() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a));
        this.setRegistryName(new ResourceLocation("mining_dimension", "teleporter"));
    }

    @Override
    public Item toItem() {
        return (Item)new BlockItem((Block)this, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName(this.getRegistryName());
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        if (player instanceof ServerPlayerEntity) {
            this.transferPlayer((ServerPlayerEntity)player, pos);
        }
        return ActionResultType.SUCCESS;
    }

    public boolean transferPlayer(ServerPlayerEntity player, BlockPos pos) {
        if (player.func_184187_bx() != null || player.func_184207_aI()) {
            return false;
        }
        if (player.field_70170_p.func_234923_W_().equals(Main.MINING_DIMENSION)) {
            ServerWorld teleportWorld = player.field_71133_b.func_71218_a(Main.SERVER_CONFIG.overworldDimension);
            if (teleportWorld == null) {
                Main.LOGGER.error("Could not find overworld dimension '{}'.", (Object)Main.SERVER_CONFIG.overworldDimension.getRegistryName());
                return false;
            }
            player.changeDimension(teleportWorld, (ITeleporter)new MiningDimensionTeleporter(pos));
        } else if (player.field_70170_p.func_234923_W_().equals(Main.SERVER_CONFIG.overworldDimension)) {
            ServerWorld teleportWorld = player.field_71133_b.func_71218_a(Main.MINING_DIMENSION);
            if (teleportWorld == null) {
                Main.LOGGER.error("Could not find mining dimension.");
                this.sendBugMessage((PlayerEntity)player);
                return false;
            }
            player.changeDimension(teleportWorld, (ITeleporter)new MiningDimensionTeleporter(pos));
        } else {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("message.wrong_dimension"), true);
        }
        return true;
    }

    private void sendBugMessage(PlayerEntity player) {
        player.func_145747_a((ITextComponent)new StringTextComponent("The Mining Dimension hasn't been created yet. This is a ").func_230529_a_((ITextComponent)TextComponentUtils.func_240647_a_((ITextComponent)new StringTextComponent("BUG")).func_240700_a_(style -> style.func_240721_b_(TextFormatting.RED).func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://bugs.mojang.com/browse/MC-195468")).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent("https://bugs.mojang.com/browse/MC-195468"))))).func_240702_b_(". "), Util.field_240973_b_);
        player.func_145747_a((ITextComponent)new StringTextComponent("A workaround can be found ").func_230529_a_((ITextComponent)TextComponentUtils.func_240647_a_((ITextComponent)new StringTextComponent("HERE")).func_240700_a_(style -> style.func_240721_b_(TextFormatting.GREEN).func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/henkelmax/advanced-mining-dimension/issues/14#issuecomment-707924771")).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent("https://github.com/henkelmax/advanced-mining-dimension/issues/14#issuecomment-707924771"))))).func_240702_b_("."), Util.field_240973_b_);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileentityTeleporter();
    }
}

